/** 
 *******************************************************************************
 * @file    bsp.h
 * @brief   Board Support Package External Reference Declaration. \n
 *          TMPM3HQA Evaluation Board.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */
/*------------------------------------------------------------------------------*/
/*  Define to prevent recursive inclusion                                       */
/*------------------------------------------------------------------------------*/
#ifndef __BSP_H
#define __BSP_H

#ifdef __cplusplus
extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "bsp_com.h"

/**
 *  @addtogroup BSP
 *  @{
 */

/** 
 *  @addtogroup TMPM3HQFDA_EVAL
 *  @{
 */
/*------------------------------------------------------------------------------*/
/*  Macro Function                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup TMPM3HQFDA_EVAL_Exported_macro TMPM3HQA Evaluation Board Exported Macro
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group TMPM3HQFDA_EVAL_Exported_macro */


/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup TMPM3HQFDA_EVAL_Exported_define TMPM3HQA Evaluation Board Exported Define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group TMPM3HQFDA_EVAL_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup TMPM3HQFDA_EVAL_Exported_define
 *  @{
 */

/* no define */


/** 
 *  @}
 */ /* End of group TMPM3HQFDA_EVAL_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup TMPM3HQFDA_EVAL_Exported_define
 *  @{
 */

/*----------------------------------*/
/** 
 * @brief  PORT LED.
*/
/*----------------------------------*/
typedef enum
{
    BSP_LED_1 = 0,          /*!< PORT LED : D10 */
    BSP_LED_2,              /*!< PORT LED : D9  */
    BSP_LED_3,              /*!< PORT LED : D8 */
    BSP_LED_4,              /*!< PORT LED : D7 */
    /*>>> be set bottom */
    BSP_LED_MAX             /*!< max */
    /*<<< be set bottom */
} BSPLed;


/*----------------------------------*/
/** 
 * @brief  PORT Push SW.
*/
/*----------------------------------*/
typedef enum
{
    BSP_PSW_1 = 0,          /*!< PORT Push SW :S4 */
    BSP_PSW_2,              /*!< PORT Push SW :S5 */
    BSP_PSW_3,              /*!< PORT Push SW :S6 */
    BSP_PSW_4,              /*!< PORT Push SW :S7 */
    BSP_PSW_5,              /*!< PORT Push SW :S9 */
    /*>>> be set bottom */
    BSP_PSW_MAX             /*!< max */
    /*<<< be set bottom */
} BSPPsw;

/*----------------------------------*/
/** 
 * @brief  USB UART.
*/
/*----------------------------------*/
typedef enum
{
    BSP_USB_UART_0 = 0,     /*!< USB UART 0 */
    BSP_USB_UART_1 = 1,     /*!< USB UART 1 */
    BSP_USB_UART_2 = 2,     /*!< USB UART 2 */
    BSP_USB_UART_3 = 3,     /*!< USB UART 3 */
    BSP_USB_UART_4 = 4,     /*!< USB UART 4 */
    /*>>> be set bottom */
    BSP_USB_UART_MAX        /*!< max */
    /*<<< be set bottom */
} BSPUsbUart;

/*----------------------------------*/
/** 
 * @brief  Thermistors.
*/
/*----------------------------------*/
typedef enum
{
    BSP_THERMISTORS_0 = 0,  /*!< Thermistors 0 */
    BSP_THERMISTORS_1 = 1,  /*!< Thermistors 0 */
    BSP_THERMISTORS_2 = 2,  /*!< Thermistors 0 */
    /*>>> be set bottom */
    BSP_THERMISTORS_MAX     /*!< max */
    /*<<< be set bottom */
} BSPThermistors;

/*----------------------------------*/
/** 
 * @brief  SPI Flash.
*/
/*----------------------------------*/
typedef enum
{
    BSP_SFLASH_0 = 0,       /*!< SFLASH 0 */
    BSP_SFLASH_1 = 1,       /*!< SFLASH 1 */
    BSP_SFLASH_2 = 2,       /*!< SFLASH 2 */
    BSP_SFLASH_3 = 3,       /*!< SFLASH 3 */
    BSP_SFLASH_4 = 4,       /*!< SFLASH 4 */   
    /*>>> be set bottom */
    BSP_SFLASH_MAX          /*!< max */
    /*<<< be set bottom */
} BSPSFlash;

/*----------------------------------*/
/** 
 * @brief  Timer.
*/
/*----------------------------------*/
typedef enum
{
    BSP_TIMER_1MS = 0,      /*!< 1ms timer */
    BSP_TIMER_1S,           /*!< 1s timer  */
    /*>>> be set bottom */
    BSP_TIMER_MAX           /*!< max */
    /*<<< be set bottom */
} BSPTimer;

/*----------------------------------*/
/** 
 * @brief  Output Pulse.
*/
/*----------------------------------*/
typedef enum
{
    BSP_OUT_PULSE_SAMPLE_A = 0, /*!< pulse A */
    BSP_OUT_PULSE_SAMPLE_B,     /*!< pulse B */
    /*>>> be set bottom */
    BSP_OUT_PULSE_SAMPLE_MAX    /*!< max */
    /*<<< be set bottom */
} BSPOutputPulse;

/*----------------------------------*/
/** 
 * @brief  Timer Counter.
*/
/*----------------------------------*/
typedef enum
{
    BSP_COUNTER_SAMPLE_A = 0, /*!< pulse A */
    BSP_COUNTER_SAMPLE_B,     /*!< pulse B */
    /*>>> be set bottom */
    BSP_COUNTER_SAMPLE_MAX    /*!< max */
    /*<<< be set bottom */
} BSPCounter;

/*----------------------------------*/
/** 
 * @brief  DLCD.
*/
/*----------------------------------*/
#if defined(TMPM3HQA)
typedef enum
{
    BSP_DLCD_00 = 0,          /*!< DLCD : SEG00 */
    BSP_DLCD_01,              /*!< DLCD : SEG01 */
    BSP_DLCD_02,              /*!< DLCD : SEG02 */
    BSP_DLCD_03,              /*!< DLCD : SEG03 */
    BSP_DLCD_04,              /*!< DLCD : SEG04 */
    BSP_DLCD_05,              /*!< DLCD : SEG05 */
    BSP_DLCD_06,              /*!< DLCD : SEG06 */
    BSP_DLCD_07,              /*!< DLCD : SEG07 */
    BSP_DLCD_08,              /*!< DLCD : SEG08 */
    BSP_DLCD_09,              /*!< DLCD : SEG09 */
    BSP_DLCD_10,              /*!< DLCD : SEG10 */
    BSP_DLCD_11,              /*!< DLCD : SEG11 */
    BSP_DLCD_12,              /*!< DLCD : SEG12 */
    BSP_DLCD_13,              /*!< DLCD : SEG13 */
    BSP_DLCD_14,              /*!< DLCD : SEG14 */
    BSP_DLCD_15,              /*!< DLCD : SEG15 */
    BSP_DLCD_16,              /*!< DLCD : SEG16 */
    BSP_DLCD_17,              /*!< DLCD : SEG17 */
    BSP_DLCD_18,              /*!< DLCD : SEG18 */
    BSP_DLCD_19,              /*!< DLCD : SEG19 */
    BSP_DLCD_20,              /*!< DLCD : SEG20 */
    BSP_DLCD_21,              /*!< DLCD : SEG21 */
    BSP_DLCD_22,              /*!< DLCD : SEG22 */
    BSP_DLCD_23,              /*!< DLCD : SEG23 */
    BSP_DLCD_24,              /*!< DLCD : SEG24 */
    BSP_DLCD_25,              /*!< DLCD : SEG25 */
    BSP_DLCD_26,              /*!< DLCD : SEG26 */
    BSP_DLCD_27,              /*!< DLCD : SEG27 */
    BSP_DLCD_28,              /*!< DLCD : SEG28 */
    BSP_DLCD_29,              /*!< DLCD : SEG29 */
    BSP_DLCD_30,              /*!< DLCD : SEG30 */
    BSP_DLCD_31,              /*!< DLCD : SEG31 */
    BSP_DLCD_32,              /*!< DLCD : SEG32 */
    BSP_DLCD_33,              /*!< DLCD : SEG33 */
    BSP_DLCD_34,              /*!< DLCD : SEG34 */
    BSP_DLCD_35,              /*!< DLCD : SEG35 */
    BSP_DLCD_36,              /*!< DLCD : SEG36 */
    BSP_DLCD_37,              /*!< DLCD : SEG37 */
    BSP_DLCD_38,              /*!< DLCD : SEG38 */
    BSP_DLCD_39,              /*!< DLCD : SEG39 */
    BSP_DLCD_40,              /*!< DLCD : DCOM0 */
    BSP_DLCD_41,              /*!< DLCD : DCOM1 */
    BSP_DLCD_42,              /*!< DLCD : DCOM2 */
    BSP_DLCD_43,              /*!< DLCD : DCOM3 */
    /*>>> be set bottom */
    BSP_DLCD_MAX             /*!< max */
    /*<<< be set bottom */
} BSPDlcd;
#endif
#if defined(TMPM3HPA)
typedef enum
{
    BSP_DLCD_00 = 0,          /*!< DLCD : SEG00 */
    BSP_DLCD_01,              /*!< DLCD : SEG01 */
    BSP_DLCD_02,              /*!< DLCD : SEG02 */
    BSP_DLCD_03,              /*!< DLCD : SEG03 */
    BSP_DLCD_04,              /*!< DLCD : SEG04 */
    BSP_DLCD_05,              /*!< DLCD : SEG05 */
    BSP_DLCD_06,              /*!< DLCD : SEG06 */
    BSP_DLCD_07,              /*!< DLCD : SEG07 */
    BSP_DLCD_08,              /*!< DLCD : SEG08 */
    BSP_DLCD_09,              /*!< DLCD : SEG09 */
    BSP_DLCD_10,              /*!< DLCD : SEG10 */
    BSP_DLCD_11,              /*!< DLCD : SEG11 */
    BSP_DLCD_12,              /*!< DLCD : SEG12 */
    BSP_DLCD_13,              /*!< DLCD : SEG13 */
    BSP_DLCD_14,              /*!< DLCD : SEG14 */
    BSP_DLCD_15,              /*!< DLCD : SEG15 */
    BSP_DLCD_16,              /*!< DLCD : SEG16 */
    BSP_DLCD_17,              /*!< DLCD : SEG17 */
    BSP_DLCD_18,              /*!< DLCD : SEG18 */
    BSP_DLCD_19,              /*!< DLCD : SEG19 */
    BSP_DLCD_20,              /*!< DLCD : SEG20 */
    BSP_DLCD_21,              /*!< DLCD : SEG21 */
    BSP_DLCD_22,              /*!< DLCD : SEG22 */
    BSP_DLCD_23,              /*!< DLCD : SEG23 */
    BSP_DLCD_24,              /*!< DLCD : SEG24 */
    BSP_DLCD_25,              /*!< DLCD : SEG25 */
    BSP_DLCD_26,              /*!< DLCD : SEG26 */
    BSP_DLCD_27,              /*!< DLCD : SEG27 */
    BSP_DLCD_28,              /*!< DLCD : SEG28 */
    BSP_DLCD_29,              /*!< DLCD : SEG29 */
    BSP_DLCD_30,              /*!< DLCD : SEG30 */
    BSP_DLCD_31,              /*!< DLCD : SEG31 */
    BSP_DLCD_32,              /*!< DLCD : SEG32 */
    BSP_DLCD_33,              /*!< DLCD : SEG33 */
    BSP_DLCD_34,              /*!< DLCD : SEG34 */
    BSP_DLCD_35,              /*!< DLCD : SEG35 */
    BSP_DLCD_36,              /*!< DLCD : SEG36 */
    BSP_DLCD_37,              /*!< DLCD : SEG37 */
    BSP_DLCD_38,              /*!< DLCD : SEG38 */
    BSP_DLCD_39,              /*!< DLCD : SEG39 */
    BSP_DLCD_40,              /*!< DLCD : DCOM0 */
    BSP_DLCD_41,              /*!< DLCD : DCOM1 */
    BSP_DLCD_42,              /*!< DLCD : DCOM2 */
    BSP_DLCD_43,              /*!< DLCD : DCOM3 */
    /*>>> be set bottom */
    BSP_DLCD_MAX             /*!< max */
    /*<<< be set bottom */
} BSPDlcd;
#endif
#if defined(TMPM3HNA)
typedef enum
{
    BSP_DLCD_04 = 0,          /*!< DLCD : SEG04 */
    BSP_DLCD_05,              /*!< DLCD : SEG05 */
    BSP_DLCD_06,              /*!< DLCD : SEG06 */
    BSP_DLCD_07,              /*!< DLCD : SEG07 */
    BSP_DLCD_08,              /*!< DLCD : SEG08 */
    BSP_DLCD_09,              /*!< DLCD : SEG09 */
    BSP_DLCD_10,              /*!< DLCD : SEG10 */
    BSP_DLCD_11,              /*!< DLCD : SEG11 */
    BSP_DLCD_12,              /*!< DLCD : SEG12 */
    BSP_DLCD_13,              /*!< DLCD : SEG13 */
    BSP_DLCD_14,              /*!< DLCD : SEG14 */
    BSP_DLCD_15,              /*!< DLCD : SEG15 */
    BSP_DLCD_16,              /*!< DLCD : SEG16 */
    BSP_DLCD_17,              /*!< DLCD : SEG17 */
    BSP_DLCD_18,              /*!< DLCD : SEG18 */
    BSP_DLCD_19,              /*!< DLCD : SEG19 */
    BSP_DLCD_20,              /*!< DLCD : SEG20 */
    BSP_DLCD_21,              /*!< DLCD : SEG21 */
    BSP_DLCD_22,              /*!< DLCD : SEG22 */
    BSP_DLCD_23,              /*!< DLCD : SEG23 */
    BSP_DLCD_24,              /*!< DLCD : SEG24 */
    BSP_DLCD_25,              /*!< DLCD : SEG25 */
    BSP_DLCD_26,              /*!< DLCD : SEG26 */
    BSP_DLCD_27,              /*!< DLCD : SEG27 */
    BSP_DLCD_28,              /*!< DLCD : SEG28 */
    BSP_DLCD_33,              /*!< DLCD : SEG33 */
    BSP_DLCD_34,              /*!< DLCD : SEG34 */
    BSP_DLCD_35,              /*!< DLCD : SEG35 */
    BSP_DLCD_36,              /*!< DLCD : SEG36 */
    BSP_DLCD_37,              /*!< DLCD : SEG37 */
    BSP_DLCD_38,              /*!< DLCD : SEG38 */
    BSP_DLCD_39,              /*!< DLCD : SEG39 */
    BSP_DLCD_40,              /*!< DLCD : DCOM0 */
    BSP_DLCD_41,              /*!< DLCD : DCOM1 */
    BSP_DLCD_42,              /*!< DLCD : DCOM2 */
    BSP_DLCD_43,              /*!< DLCD : DCOM3 */
    /*>>> be set bottom */
    BSP_DLCD_MAX             /*!< max */
    /*<<< be set bottom */
} BSPDlcd;
#endif
#if defined(TMPM3HMA)
typedef enum
{
    BSP_DLCD_05 = 0,          /*!< DLCD : SEG05 */
    BSP_DLCD_06,              /*!< DLCD : SEG06 */
    BSP_DLCD_07,              /*!< DLCD : SEG07 */
    BSP_DLCD_08,              /*!< DLCD : SEG08 */
    BSP_DLCD_09,              /*!< DLCD : SEG09 */
    BSP_DLCD_10,              /*!< DLCD : SEG10 */
    BSP_DLCD_11,              /*!< DLCD : SEG11 */
    BSP_DLCD_12,              /*!< DLCD : SEG12 */
    BSP_DLCD_13,              /*!< DLCD : SEG13 */
    BSP_DLCD_14,              /*!< DLCD : SEG14 */
    BSP_DLCD_15,              /*!< DLCD : SEG15 */
    BSP_DLCD_16,              /*!< DLCD : SEG16 */
    BSP_DLCD_17,              /*!< DLCD : SEG17 */
    BSP_DLCD_18,              /*!< DLCD : SEG18 */
    BSP_DLCD_19,              /*!< DLCD : SEG19 */
    BSP_DLCD_20,              /*!< DLCD : SEG20 */
    BSP_DLCD_21,              /*!< DLCD : SEG21 */
    BSP_DLCD_22,              /*!< DLCD : SEG22 */
    BSP_DLCD_23,              /*!< DLCD : SEG23 */
    BSP_DLCD_24,              /*!< DLCD : SEG24 */
    BSP_DLCD_25,              /*!< DLCD : SEG25 */
    BSP_DLCD_26,              /*!< DLCD : SEG26 */
    BSP_DLCD_27,              /*!< DLCD : SEG27 */
    BSP_DLCD_37,              /*!< DLCD : SEG37 */
    BSP_DLCD_38,              /*!< DLCD : SEG38 */
    BSP_DLCD_39,              /*!< DLCD : SEG39 */
    BSP_DLCD_40,              /*!< DLCD : DCOM0 */
    BSP_DLCD_41,              /*!< DLCD : DCOM1 */
    BSP_DLCD_42,              /*!< DLCD : DCOM2 */
    BSP_DLCD_43,              /*!< DLCD : DCOM3 */
    /*>>> be set bottom */
    BSP_DLCD_MAX             /*!< max */
    /*<<< be set bottom */
} BSPDlcd;
#endif

/*----------------------------------*/
/** 
 * @brief  Degital IO.
*/
/*----------------------------------*/
typedef enum
{
    BSP_DIAGNOSIS_DIGITALIO = 0, /*!< DIO */
    /*>>> be set bottom */
    BSP_DIAGNOSIS_DIGITALIO_MAX  /*!< max */
    /*<<< be set bottom */
} BSPDio;
/** 
 *  @}
 */ /* End of group TMPM3HQFDA_EVAL_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup TMPM3HQFDA_EVAL_Exported_typedef TMPM3HQA Evaluation Board Exported Typedef
 *  @{
 */

/*----------------------------------*/
/** 
 * @brief  Thermistors degC Table Info.
*/
/*----------------------------------*/
typedef struct
{
    int32_t  degC;      /*!< deg.C            */
    uint32_t low;       /*!< AD value :Low    */
    uint32_t center;    /*!< AD value :Center */
    uint32_t high;      /*!< AD value :High   */
} bsp_thermistors_degc_t;

/*----------------------------------*/
/** 
 * @brief  Potentiometers.
*/
/*----------------------------------*/
typedef enum
{
    BSP_POTENTIOMETERS_0 = 0,  /*!< Thermistors 0 */
    BSP_POTENTIOMETERS_1 = 1,  /*!< Thermistors 0 */
    /*>>> be set bottom */
    BSP_POTENTIOMETERS_MAX     /*!< max */
    /*<<< be set bottom */
} BSPPotentiometers;

/*----------------------------------*/
/** 
 * @brief  External Interrupt.
*/
/*----------------------------------*/
typedef enum
{
    BSP_EXINT_0 = 0,  /*!< low level */
    BSP_EXINT_1 = 1,  /*!<  high level */
    /*>>> be set bottom */
    BSP_EXINT_MAX     /*!< max */
    /*<<< be set bottom */
} BSPExInt;

/*----------------------------------*/
/** 
 * @brief  DNF Table Info.
*/
/*----------------------------------*/
typedef enum
{
    BSP_DNF_0 = 0,  /*!< DNF 0 */
    /*>>> be set bottom */
    BSP_DNF_MAX     /*!< max */
    /*<<< be set bottom */
} BSPDnf;

/*----------------------------------*/
/** 
 * @brief  RMC Table Info.
*/
/*----------------------------------*/
typedef enum
{
    BSP_RMC_SAMPLE = 0,  /*!< RMC Sample */
    /*>>> be set bottom */
    BSP_RMC_MAX     /*!< max */
    /*<<< be set bottom */
} BSPRmc;
/**
 *  @}
 */ /* End of group TMPM3HQFDA_EVAL_Exported_typedef */

/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup TMPM3HQFDA_EVAL_Exported_typedef TMPM3HQA Evaluation Board Exported Typedef
 *  @{
 */
/* No Define */
/**
 *  @}
 */ /* End of group TMPM3HQFDA_EVAL_Exported_typedef */
 
/*------------------------------------------------------------------------------*/
/*  Functions                                                                   */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup TMPM3HQFDA_EVAL_Exported_functions TMPM3HQA Evaluation Board Exported Functions
 *  @{
 */

void bsp_initialize(void);
void bsp_finalize(void);
gpio_t *bsp_get_gpio_instance_address(void);
/* led */
void bsp_get_gpio_led(BSPLed led, uint32_t *p_group, uint32_t *p_num);
uint32_t bsp_get_gpio_group_led(BSPLed led);
uint32_t bsp_get_gpio_num_led(BSPLed led);
/* psw */
void bsp_get_gpio_psw(BSPPsw psw, uint32_t *p_group, uint32_t *p_num);
uint32_t bsp_get_gpio_group_psw(BSPPsw psw);
uint32_t bsp_get_gpio_num_psw(BSPPsw psw);
/* usb uart */
uint32_t bsp_get_usb_uart_tx_ch(BSPUsbUart uart);
uint32_t bsp_get_usb_uart_rx_ch(BSPUsbUart uart);
uint32_t bsp_get_usb_uart_tx_dma_ch(BSPUsbUart uart);
uint32_t bsp_get_usb_uart_rx_dma_ch(BSPUsbUart uart);
uint32_t bsp_get_usb_uart_tx_baudrate(BSPUsbUart uart);
uint32_t bsp_get_usb_uart_rx_baudrate(BSPUsbUart uart);
IRQn_Type bsp_get_usb_uart_tx_nvic(BSPUsbUart uart);
IRQn_Type bsp_get_usb_uart_rx_nvic(BSPUsbUart uart);
IRQn_Type bsp_get_usb_uart_err_nvic(BSPUsbUart uart);
IRQn_Type bsp_get_uart4_tx_nvic(BSPUsbUart uart);
IRQn_Type bsp_get_uart4_rx_nvic(BSPUsbUart uart);
IRQn_Type bsp_get_uart4_err_nvic(BSPUsbUart uart);
/* tspi */
uint32_t bsp_get_tspi_tx_ch(BSPSFlash tspi);
uint32_t bsp_get_tspi_clk_ch(BSPSFlash tspi);
uint32_t bsp_get_tspi_rx_ch(BSPSFlash tspi);
IRQn_Type bsp_get_tspi_tx_nvic(BSPSFlash tspi);
IRQn_Type bsp_get_tspi_rx_nvic(BSPSFlash tspi);
IRQn_Type bsp_get_tspi_tx_err_nvic(BSPSFlash tspi);
IRQn_Type bsp_get_tspi_rx_err_nvic(BSPSFlash tspi);
/* timer */
void bsp_get_timer(BSPTimer timer, uint32_t *p_ch, uint32_t *p_type);
uint32_t bsp_get_timer_ch(BSPTimer timer);
uint32_t bsp_get_timer_type(BSPTimer timer);
IRQn_Type bsp_get_timer_nvic(BSPTimer timer);
/* output pulse */
uint32_t bsp_get_output_pulse_ch(BSPOutputPulse pulse);
uint32_t bsp_get_output_pulse_type(BSPOutputPulse pulse);
IRQn_Type bsp_get_output_pulse_nvic(BSPOutputPulse pulse);
/* thermistors */
uint32_t bsp_get_thermistors_adin(BSPThermistors thermistors);
uint32_t bsp_get_thermistors_ch(BSPThermistors thermistors);
uint32_t bsp_get_thermistors_dma_ch(BSPThermistors thermistors);
TXZ_Result bsp_get_thermistors_degC(BSPThermistors thermistors, uint32_t cnt, int32_t *p_degC);
#if (defined(TMPM3HNA) || defined(TMPM3HMA) || defined(TMPM3HQA) || defined(TMPM3HPA))
/* dlcd */
uint32_t bsp_get_gpio_group_dlcd(BSPDlcd dlcd);
uint32_t bsp_get_gpio_num_dlcd(BSPDlcd dlcd);
uint32_t bsp_get_gpio_func_dlcd(BSPDlcd dlcd);
#endif
/* dio */
uint32_t bsp_get_gpio_group_dio(BSPDio dio);
uint32_t bsp_get_gpio_num_dio(BSPDio dio);
uint32_t bsp_get_gpio_func_dio(BSPDio dio);
/* rtc */
void bsp_irq_rtc_enable(void);
void bsp_irq_rtc_disable(void);
/* rmc */
void bsp_irq_rmc_enable(void);
void bsp_irq_rmc_disable(void);
TSB_RMC_TypeDef * bsp_get_rmc_reg(BSPRmc rmc);
uint32_t bsp_get_rmc_ch(BSPRmc rmc);
IRQn_Type bsp_get_rmc_nvic(BSPRmc rmc);
/* external interrupt */
void bsp_irq_exint_enable(void);
void bsp_irq_exint_disable(void);
IRQn_Type bsp_get_exint_nvic(void);
/* dnf */
void bsp_irq_dnf_enable(void);
void bsp_irq_dnf_disable(void);
TSB_DNF_TypeDef * bsp_get_dnf_reg(BSPDnf dnf);
uint32_t bsp_get_dnf_int_num(BSPDnf dnf);
IRQn_Type bsp_get_dnf_nvic(BSPDnf dnf);


/*>>> Add to processing by user. */
extern void irq_systick(void);
extern void irq_psw(BSPPsw psw);
extern void irq_thermistors_sgl(BSPThermistors thermistors);
extern void irq_potentiometers_cnt(BSPPotentiometers potentiometers);
extern void irq_sflash_rx(BSPSFlash sflash);
extern void irq_sflash_tx(BSPSFlash sflash);
extern void irq_sflash_err(BSPSFlash sflash);
extern void irq_usb_uart_rx(BSPUsbUart uart);
extern void irq_usb_uart_tx(BSPUsbUart uart);
extern void irq_usb_uart_err(BSPUsbUart uart);
extern void irq_uart4_rx(BSPUsbUart uart);
extern void irq_uart4_tx(BSPUsbUart uart);
extern void irq_uart4_err(BSPUsbUart uart);
extern void irq_timer(BSPTimer timer);
extern void irq_counter(BSPCounter cnt);
extern void irq_dmac_done(uint32_t ch);
extern void irq_dmac_err(void);
extern void irq_rtc(void);
extern void irq_rmc(uint32_t status);
extern void irq_i2c(void);
extern void irq_tbe(void);
extern void irq_rbf(void);
extern void irq_adc_sgl(void);
extern void irq_adc_cnt(void);
extern void irq_adc_trig(void);
extern void irq_adc_cp0(void);
extern void irq_adc_cp1(void);

extern void irq_exint(BSPExInt exi);
/*<<< Add to processing by user. */

/** 
 *  @}
 */ /* End of group TMPM3HQFDA_EVAL_Exported_functions */

/**
 *  @}
 */ /* End of group TMPM3HQFDA_EVAL */

/**
 *  @} 
 */ /* End of group Example */

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __BSP_H */

