/** 
 *******************************************************************************
 * @file    bsp_config_adbun_m3hqa_dlcd.h
 * @brief   This file provides all the functions prototypes for DLCD Driver.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */
/*------------------------------------------------------------------------------*/
/*  Define to prevent recursive inclusion                                       */
/*------------------------------------------------------------------------------*/
#ifndef __BSP_CONFIG_ADBUN_M3HQA_DLCD_H
#define __BSP_CONFIG_ADBUN_M3HQA_DLCD_H

#ifdef __cplusplus
extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "dlcd.h"
#include "cg.h"
#include "port.h"
#include "bsp.h"
/**
 *  @addtogroup BSP BSP
 *  @{
 */

/** 
 *  @addtogroup BSP_DLCD
 *  @{
 */
/*------------------------------------------------------------------------------*/
/*  Macro Function                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_DLCD_Exported_macro
 *  @{
 */

/** 
 *  @}
 */ /* End of group BSP_DLCD_Exported_macro */


/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_DLCD_Exported_define
 *  @{
 */

/**
 *  @}
 */ /* End of group EI2C_NullPointer */

/** 
 *  @}
 */ /* End of group BSP_DLCD_Exported_define */

/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_DLCD_Exported_define
 *  @{
 */
#define   DLCDCR2_CONTSEL               DLCDCR2_CONTSEL_FRAME_LENGTH
#define   DLCDCR2_CLKSEL                DLCDCR2_CLKSEL_FS
#define   DLCDCR2_DUTY                  DLCDCR2_DUTY_4COM_1_6
#define   DLCD_CLOCK                    DLCD_CLOCK_FS

#define   DLCD_DLSTCLKCYC_DATA_FS       ((uint8_t)0x24)             /*!< fs DLSTCLKCYC Data  */
#define   DLCD_DLCONTCYC_DATA_FS        ((uint8_t)0x1E)             /*!< fs DLCONTCYC Data  */
#define   DLCD_DLSTCLKCYC_DATA_IHOSC2   ((uint8_t)0x2C)             /*!< IHOSC2 DLSTCLKCYC Data  */
#define   DLCD_DLCONTCYC_DATA_IHOSC2    ((uint8_t)0x23)             /*!< IHOSC2 DLCONTCYC Data  */
#define   DLCD_DLSTCLKCYC_DATA          DLCD_DLSTCLKCYC_DATA_FS     /*!< DLSTCLKCYC Data  */
#define   DLCD_DLCONTCYC_DATA           DLCD_DLCONTCYC_DATA_FS      /*!< DLCONTCYC Data  */

#define   BSP_DLCD_MbedSw_A_MAX         ((uint32_t)4)               /*!< MBEDSW A MAX */
#define   BSP_DLCD_MbedSw_d_MAX         ((uint32_t)4)               /*!< MBEDSW d MAX */
#define   BSP_DLCD_MbedSw_c_MAX         ((uint32_t)4)               /*!< MBEDSW c MAX */
#define   BSP_DLCD_MbedSw_Semicoron_MAX ((uint32_t)2)               /*!< MBEDSW : MAX */
#define   BSP_DLCD_MbedSw_H_MAX         ((uint32_t)4)               /*!< MBEDSW H MAX */

#define   BSP_DLCD_MbedSw_Left0_MAX     ((uint32_t)2)               /*!< MBEDSW Left 0 MAX */
#define   BSP_DLCD_MbedSw_Middle0_MAX   ((uint32_t)2)               /*!< MBEDSW Middle 0 MAX */
#define   BSP_DLCD_MbedSw_Right0_MAX    ((uint32_t)2)               /*!< MBEDSW Right 0 MAX */
#define   BSP_DLCD_MbedSw_Left1_MAX     ((uint32_t)1)               /*!< MBEDSW Left 1 MAX */
#define   BSP_DLCD_MbedSw_Middle1_MAX   ((uint32_t)1)               /*!< MBEDSW Middle 1 MAX */
#define   BSP_DLCD_MbedSw_Right1_MAX    ((uint32_t)1)               /*!< MBEDSW Right 1 MAX */
#define   BSP_DLCD_MbedSw_Left2_MAX     ((uint32_t)4)               /*!< MBEDSW Left 2 MAX */
#define   BSP_DLCD_MbedSw_Middle2_MAX   ((uint32_t)4)               /*!< MBEDSW Middle 2 MAX */
#define   BSP_DLCD_MbedSw_Right2_MAX    ((uint32_t)4)               /*!< MBEDSW Right 2 MAX */
#define   BSP_DLCD_MbedSw_Left3_MAX     ((uint32_t)4)               /*!< MBEDSW Left 3 MAX */
#define   BSP_DLCD_MbedSw_Middle3_MAX   ((uint32_t)4)               /*!< MBEDSW Middle 3 MAX */
#define   BSP_DLCD_MbedSw_Right3_MAX    ((uint32_t)4)               /*!< MBEDSW Right 3 MAX */
#define   BSP_DLCD_MbedSw_Left4_MAX     ((uint32_t)4)               /*!< MBEDSW Left 4 MAX */
#define   BSP_DLCD_MbedSw_Middle4_MAX   ((uint32_t)4)               /*!< MBEDSW Middle 4 MAX */
#define   BSP_DLCD_MbedSw_Right4_MAX    ((uint32_t)4)               /*!< MBEDSW Right 4 MAX */
#define   BSP_DLCD_MbedSw_Left5_MAX     ((uint32_t)4)               /*!< MBEDSW Left 5 MAX */
#define   BSP_DLCD_MbedSw_Middle5_MAX   ((uint32_t)4)               /*!< MBEDSW Middle 5 MAX */
#define   BSP_DLCD_MbedSw_Right5_MAX    ((uint32_t)4)               /*!< MBEDSW Right 5 MAX */
#define   BSP_DLCD_MbedSw_Left6_MAX     ((uint32_t)4)               /*!< MBEDSW Left 6 MAX */
#define   BSP_DLCD_MbedSw_Middle6_MAX   ((uint32_t)4)               /*!< MBEDSW Middle 6 MAX */
#define   BSP_DLCD_MbedSw_Right6_MAX    ((uint32_t)4)               /*!< MBEDSW Right 6 MAX */
#define   BSP_DLCD_MbedSw_Left7_MAX     ((uint32_t)2)               /*!< MBEDSW Left 7 MAX */
#define   BSP_DLCD_MbedSw_Middle7_MAX   ((uint32_t)2)               /*!< MBEDSW Middle 7 MAX */
#define   BSP_DLCD_MbedSw_Right7_MAX    ((uint32_t)2)               /*!< MBEDSW Right 7 MAX */
#define   BSP_DLCD_MbedSw_Left8_MAX     ((uint32_t)4)               /*!< MBEDSW Left 8 MAX */
#define   BSP_DLCD_MbedSw_Middle8_MAX   ((uint32_t)4)               /*!< MBEDSW Middle 8 MAX */
#define   BSP_DLCD_MbedSw_Right8_MAX    ((uint32_t)4)               /*!< MBEDSW Right 8 MAX */
#define   BSP_DLCD_MbedSw_Left9_MAX     ((uint32_t)4)               /*!< MBEDSW Left 9 MAX */
#define   BSP_DLCD_MbedSw_Middle9_MAX   ((uint32_t)4)               /*!< MBEDSW Middle 9 MAX */
#define   BSP_DLCD_MbedSw_Right9_MAX    ((uint32_t)4)               /*!< MBEDSW Right 9 MAX */
#define   BSP_DLCD_MbedSw_LeftA_MAX     ((uint32_t)4)               /*!< MBEDSW Left A MAX */
#define   BSP_DLCD_MbedSw_MiddleA_MAX   ((uint32_t)4)               /*!< MBEDSW Middle A MAX */
#define   BSP_DLCD_MbedSw_RightA_MAX    ((uint32_t)4)               /*!< MBEDSW Right A MAX */
#define   BSP_DLCD_MbedSw_LeftB_MAX     ((uint32_t)4)               /*!< MBEDSW Left B MAX */
#define   BSP_DLCD_MbedSw_MiddleB_MAX   ((uint32_t)4)               /*!< MBEDSW Middle B MAX */
#define   BSP_DLCD_MbedSw_RightB_MAX    ((uint32_t)4)               /*!< MBEDSW Right B MAX */
#define   BSP_DLCD_MbedSw_LeftC_MAX     ((uint32_t)2)               /*!< MBEDSW Left C MAX */
#define   BSP_DLCD_MbedSw_MiddleC_MAX   ((uint32_t)2)               /*!< MBEDSW Middle C MAX */
#define   BSP_DLCD_MbedSw_RightC_MAX    ((uint32_t)2)               /*!< MBEDSW Right C MAX */
#define   BSP_DLCD_MbedSw_LeftD_MAX     ((uint32_t)4)               /*!< MBEDSW Left D MAX */
#define   BSP_DLCD_MbedSw_MiddleD_MAX   ((uint32_t)4)               /*!< MBEDSW Middle D MAX */
#define   BSP_DLCD_MbedSw_RightD_MAX    ((uint32_t)4)               /*!< MBEDSW Right D MAX */
#define   BSP_DLCD_MbedSw_LeftE_MAX     ((uint32_t)4)               /*!< MBEDSW Left E MAX */
#define   BSP_DLCD_MbedSw_MiddleE_MAX   ((uint32_t)4)               /*!< MBEDSW Middle E MAX */
#define   BSP_DLCD_MbedSw_RightE_MAX    ((uint32_t)4)               /*!< MBEDSW Right E MAX */
#define   BSP_DLCD_MbedSw_LeftF_MAX     ((uint32_t)4)               /*!< MBEDSW Left F MAX */
#define   BSP_DLCD_MbedSw_MiddleF_MAX   ((uint32_t)4)               /*!< MBEDSW Middle F MAX */
#define   BSP_DLCD_MbedSw_RightF_MAX    ((uint32_t)4)               /*!< MBEDSW Right F MAX */
/** 
 *  @}
 */ /* End of group BSP_DLCD_Exported_define */

/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_DLCD_Exported_define
 *  @{
 */

/*----------------------------------*/
/** 
 * @brief  DLCD Number.
*/
/*----------------------------------*/
typedef enum
{
    BSP_DLCD_NUMBER_0 = 0,          /*!< DLCD Number : 0 */
    BSP_DLCD_NUMBER_1,              /*!< DLCD Number : 1 */
    BSP_DLCD_NUMBER_2,              /*!< DLCD Number : 2 */
    BSP_DLCD_NUMBER_3,              /*!< DLCD Number : 3 */
    BSP_DLCD_NUMBER_4,              /*!< DLCD Number : 4 */
    BSP_DLCD_NUMBER_5,              /*!< DLCD Number : 5 */
    BSP_DLCD_NUMBER_6,              /*!< DLCD Number : 6 */
    BSP_DLCD_NUMBER_7,              /*!< DLCD Number : 7 */
    BSP_DLCD_NUMBER_8,              /*!< DLCD Number : 8 */
    BSP_DLCD_NUMBER_9,              /*!< DLCD Number : 9 */
    BSP_DLCD_NUMBER_A,              /*!< DLCD Number : A */
    BSP_DLCD_NUMBER_B,              /*!< DLCD Number : B */
    BSP_DLCD_NUMBER_C,              /*!< DLCD Number : C */
    BSP_DLCD_NUMBER_D,              /*!< DLCD Number : D */
    BSP_DLCD_NUMBER_E,              /*!< DLCD Number : E */
    BSP_DLCD_NUMBER_F,              /*!< DLCD Number : F */
    /*>>> be set bottom */
    BSP_DLCD_NUMBER_MAX             /*!< max */
    /*<<< be set bottom */
} BSPDlcdNumber;

/*----------------------------------*/
/** 
 * @brief  DLCD clock.
*/
/*----------------------------------*/
typedef enum
{
    DLCD_CLOCK_IHOSC2,               /*!< IHOSC2.                 */
    DLCD_CLOCK_FS                    /*!< FS.                     */
} DLCDClock;
/** 
 *  @}
 */ /* End of group BSP_DLCD_Exported_define */

/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_DLCD_Exported_typedef
 *  @{
 */
/*----------------------------------*/
/** 
 * @brief  Initial setting. \n
 *         User must be set.
*/
/*----------------------------------*/
typedef struct
{
    uint32_t        id;             /*!< ID: User value.          */
    gpio_t          *p_gpio;        /*!< GPIO Driver Instance Address. */
    dlcd_t          *p_dlcd;        /*!< DLCD Driver Instance Address. */
    dlcd_dip_t      dlcd_data;      /*!< DLCD Driver Data. */
    cg_t            *p_cg;          /*!< CG Driver Data. */
    rlm_t           *p_rlm;         /*!< RLM Driver Data. */
    DLCDClock       clock;          /*!< DLCD source clock. */
    uint32_t        data;           /*!< DLCD data. */
    struct
    {
        uint32_t    group;          /*!< GPIO Group. \n
                                            : Use @ref gpio_gr_t. */
        uint32_t    num;            /*!< GPIO Num. \n
                                            : Use @ref gpio_num_t.*/
        uint32_t    func;           /*!< GPIO Func. \n
                                            : Use @ref gpio_pxx_func_t.*/
    } port;
} display_initial_setting_t;

/*----------------------------------*/
/** 
 * @brief  DLCD Class.
*/
/*----------------------------------*/
typedef struct
{
    display_initial_setting_t init;     /*!< Initial setting.     */
} display_t;
/**
 *  @}
 */ /* End of group BSP_DLCD_Exported_typedef */


/*------------------------------------------------------------------------------*/
/*  Functions                                                                   */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_DLCD_Exported_functions
 *  @{
 */
void dlcd_initialize(display_t *p_instance);
void dlcd_finalize(display_t *p_instance);
void dlcd_display_set(display_t *p_instance, uint32_t data);
/** 
 *  @}
 */ /* End of group BSP_DLCD_Exported_functions */

/**
 *  @}
 */ /* End of group BSP_DLCD */

/**
 *  @} 
 */ /* End of group BSP */

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __BSP_CONFIG_ADBUN_M3HQA_DLCD_H */

