/** 
 *******************************************************************************
 * @file    bsp_config_adbun_m3hqa_led.c
 * @brief   LED
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */
#ifdef __cplusplus
 extern "C" {
#endif
/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "bsp_led.h"

#if defined(__BSP_CONFIG_ADBUN_M3HQA_LED_H)
/**
 *  @addtogroup BSP BSP
 *  @{
 */

/** 
 *  @addtogroup BSP_BSP_LED
 *  @{
 */
/*------------------------------------------------------------------------------*/
/*  Macro Function                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_LED_Private_macro
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group BSP_BSP_LED_Private_macro */


/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_LED_Private_define
 *  @{
 */
/*----------------------*/
/*  for Debug           */
/*----------------------*/
#ifdef DEBUG
    #if 1
        #define LED_CFG_DEBUG
    #endif
#endif
/** 
 *  @}
 */ /* End of group BSP_BSP_LED_Private_define */


/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_LED_Private_define
 *  @{
 */

#define LED_NULL        ((void *)0)  /*!< Null Pointer */

/** 
 *  @}
 */ /* End of group BSP_BSP_LED_Private_define */


/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_LED_Private_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group BSP_BSP_LED_Private_define */


/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_LED_Private_typedef
 *  @{
 */

/* no define */

/**
 *  @}
 */ /* End of group BSP_BSP_LED_Private_typedef */


/*------------------------------------------------------------------------------*/
/*  Private Member                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_LED_Private_variables
 *  @{
 */

/* no define */

/**
 *  @}
 */ /* End of group BSP_BSP_LED_Private_variables */


/*------------------------------------------------------------------------------*/
/*  Private Function                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_LED_Private_fuctions
 *  @{
 */
static void led_error(void);
/*--------------------------------------------------*/
/** 
  * @brief  Error Hook
  * @param  -
  * @retval -
  * @note   for debug
  */
/*--------------------------------------------------*/
static void led_error(void)
{
#ifdef LED_CFG_DEBUG
    while(1)
    {
        __nop();
    }
#endif
}
/**
 *  @}
 */ /* End of group BSP_BSP_LED_Private_fuctions */


/*------------------------------------------------------------------------------*/
/*  Public Function                                                             */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_LED_Exported_functions
 *  @{
 */
/*--------------------------------------------------*/
/** 
  * @brief  Initialize
  * @param  p_instance :Instance Source Address.
  * @return -
  * @retval -
  * @note   Parameter check isn't performed.
  * @attention This function is not available in interrupt.
  */
/*--------------------------------------------------*/
void led_initialize(led_t *p_instance)
{
    /*------------------------------*/
    /*  Timer Processing Disable    */
    /*------------------------------*/
    p_instance->info.timer   = TXZ_DISABLE;
    /*------------------------------*/
    /*  Port Setting                */
    /*------------------------------*/
    /*--- DATA setting ---*/
    {
        gpio_pinstate_t value;
        if (p_instance->init.state == LED_STATE_OFF)
        {
            value = GPIO_PIN_RESET;
        }
        else
        {
            value = GPIO_PIN_SET;
        }
        if (gpio_write_bit(
                p_instance->init.p_gpio, 
                p_instance->init.port.group, 
                p_instance->init.port.num, 
                GPIO_Mode_DATA, 
                value
                ) != TXZ_SUCCESS)
        {
            led_error();
        }
    }
    /*------------------------------*/
    /*  Private Information Initialize*/
    /*------------------------------*/
    p_instance->info.state   = p_instance->init.state;
    p_instance->info.counter = 0;
    /*------------------------------*/
    /*  Timer Processing Enable     */
    /*------------------------------*/
    if (p_instance->init.blink.func == TXZ_ENABLE)
    {
        p_instance->info.timer = TXZ_ENABLE;
    }
}

/*--------------------------------------------------*/
/** 
  * @brief  Finalize
  * @param  p_instance :Instance Source Address.
  * @return -
  * @retval -
  * @note   Parameter check isn't performed.
  * @attention This function is not available in interrupt.
  */
/*--------------------------------------------------*/
void led_finalize(led_t *p_instance)
{
    /*------------------------------*/
    /*  Timer Processing Disable    */
    /*------------------------------*/
    p_instance->info.timer   = TXZ_DISABLE;
    /*------------------------------*/
    /* Turn off                     */
    /*------------------------------*/
    if (gpio_write_bit(
            p_instance->init.p_gpio, 
            p_instance->init.port.group, 
            p_instance->init.port.num, 
            GPIO_Mode_DATA, 
            GPIO_PIN_RESET
            ) != TXZ_SUCCESS)
    {
        led_error();
    }
}

/*--------------------------------------------------*/
/** 
  * @brief  Task Processing
  * @param  p_instance :Instance Source Address.
  * @return -
  * @retval -
  * @note   Parameter check isn't performed. \n
  *         Call by Main Processing.
  * @attention This function is not available in interrupt.
  */
/*--------------------------------------------------*/
void led_task(led_t *p_instance)
{
    if (p_instance->init.blink.func == TXZ_ENABLE)
    {
        LEDState crt;
        LEDState nxt;
        gpio_pinstate_t val = GPIO_PIN_SET;

        /*------------------------------*/
        /* Check State                  */
        /*------------------------------*/
        /*--- Current LED ---*/
        if(gpio_read_bit(
                p_instance->init.p_gpio, 
                p_instance->init.port.group, 
                p_instance->init.port.num, 
                GPIO_Mode_DATA, 
               &val) == TXZ_SUCCESS)
        {
            if(val == GPIO_PIN_RESET)
            {
                crt = LED_STATE_OFF;
            }
            else
            {
                crt = LED_STATE_ON;
            }
        }
        /*--- Next LED    ---*/
        nxt = p_instance->info.state;
        /*------------------------------*/
        /* Turn on/off                  */
        /*------------------------------*/
        if (crt != nxt)
        {
            gpio_pinstate_t value;

            if (nxt == LED_STATE_OFF)
            {
                value = GPIO_PIN_RESET;
            }
            else
            {
                value = GPIO_PIN_SET;
            }
            if (gpio_write_bit(
                    p_instance->init.p_gpio, 
                    p_instance->init.port.group, 
                    p_instance->init.port.num, 
                    GPIO_Mode_DATA, 
                    value
                    ) != TXZ_SUCCESS)
            {
                led_error();
            }
        }
    }
}

/*--------------------------------------------------*/
/** 
  * @brief  Turn on.
  * @param  p_instance :Instance Source Address.
  * @return -
  * @retval -
  * @note   Parameter check isn't performed.
  * @attention This function is not available in interrupt.
  */
/*--------------------------------------------------*/
void led_turn_on(led_t *p_instance)
{
    /*------------------------------*/
    /*  Timer Processing Disable    */
    /*------------------------------*/
    p_instance->info.timer = TXZ_DISABLE;
    /*------------------------------*/
    /* Turn on                      */
    /*------------------------------*/
    if (gpio_write_bit(
            p_instance->init.p_gpio, 
            p_instance->init.port.group, 
            p_instance->init.port.num, 
            GPIO_Mode_DATA, 
            GPIO_PIN_SET
            ) != TXZ_SUCCESS)
    {
        led_error();
    }
    /*------------------------------*/
    /* Update Information           */
    /*------------------------------*/
    p_instance->info.state   = LED_STATE_ON;
    p_instance->info.counter = 0;
    /*------------------------------*/
    /*  Timer Processing Enable     */
    /*------------------------------*/
    if (p_instance->init.blink.func == TXZ_ENABLE)
    {
        p_instance->info.timer = TXZ_ENABLE;
    }
}

/*--------------------------------------------------*/
/** 
  * @brief  Turn off.
  * @param  p_instance :Instance Source Address.
  * @return -
  * @retval -
  * @note   Parameter check isn't performed.
  * @attention This function is not available in interrupt.
  */
/*--------------------------------------------------*/
void led_turn_off(led_t *p_instance)
{
    /*------------------------------*/
    /*  Timer Processing Disable    */
    /*------------------------------*/
    p_instance->info.timer = TXZ_DISABLE;
    /*------------------------------*/
    /* Turn off                     */
    /*------------------------------*/
    if (gpio_write_bit(
            p_instance->init.p_gpio, 
            p_instance->init.port.group, 
            p_instance->init.port.num, 
            GPIO_Mode_DATA, 
            GPIO_PIN_RESET
            ) != TXZ_SUCCESS)
    {
        led_error();
    }
    /*------------------------------*/
    /* Update Information           */
    /*------------------------------*/
    p_instance->info.state   = LED_STATE_OFF;
    p_instance->info.counter = 0;
    /*------------------------------*/
    /*  Timer Processing Enable     */
    /*------------------------------*/
    if (p_instance->init.blink.func == TXZ_ENABLE)
    {
        p_instance->info.timer = TXZ_ENABLE;
    }
}

/*--------------------------------------------------*/
/** 
  * @brief  1ms Timer Handler
  * @param  p_instance :Instance Source Address.
  * @return -
  * @retval -
  * @note   Parameter check isn't performed. \n
  *         Call by 1ms Timer.
  */
/*--------------------------------------------------*/
void led_1ms_timer_handler(led_t *p_instance)
{
    if (p_instance->info.timer == TXZ_ENABLE)
    {
        /*------------------------------*/
        /* Counter Update               */
        /*------------------------------*/
        p_instance->info.counter++;
        /*------------------------------*/
        /* LED Update Check             */
        /*------------------------------*/
        if (p_instance->init.blink.func == TXZ_ENABLE)
        {
          
            if (p_instance->info.state == LED_STATE_ON)
            {
                if (p_instance->init.blink.interval.on  <= p_instance->info.counter)
                {
                    p_instance->info.state   = LED_STATE_OFF;
                    p_instance->info.counter = 0;
                }
            }
            else
            {
                if (p_instance->init.blink.interval.off <= p_instance->info.counter)
                {
                    p_instance->info.state   = LED_STATE_ON;
                    p_instance->info.counter = 0;
                }
            }
        }
    }
}

/**
 *  @}
 */ /* End of group BSP_BSP_LED_Exported_functions */


/**
 *  @}
 */ /* End of group BSP_BSP_LED */

/**
 *  @} 
 */ /* End of group BSP */

#endif /* defined(__BSP_CONFIG_ADBUN_M3HQA_LED_H)  */
#ifdef __cplusplus
}
#endif /* __cplusplus */
