/** 
 *******************************************************************************
 * @file    bsp_config_adbun_m3hqa_led.h
 * @brief   External reference declaration for LED.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */
/*------------------------------------------------------------------------------*/
/*  Define to prevent recursive inclusion                                       */
/*------------------------------------------------------------------------------*/
#ifndef __BSP_CONFIG_ADBUN_M3HQA_LED_H
#define __BSP_CONFIG_ADBUN_M3HQA_LED_H

#ifdef __cplusplus
extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "bsp_com.h"

/**
 *  @addtogroup BSP BSP
 *  @{
 */

/** 
 *  @addtogroup BSP_BSP_LED
 *  @{
 */
/*------------------------------------------------------------------------------*/
/*  Macro Function                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_LED_Exported_macro
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group BSP_BSP_LED_Exported_macro */


/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_LED_Exported_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group BSP_BSP_LED_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_LED_Exported_define
 *  @{
 */

/* no define */


/** 
 *  @}
 */ /* End of group BSP_BSP_LED_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_LED_Exported_define
 *  @{
 */

/*----------------------------------*/
/** 
 * @brief  LED state.
*/
/*----------------------------------*/
typedef enum
{
    LED_STATE_OFF,                  /*!< Turn on.                 */
    LED_STATE_ON                    /*!< Turn off.                */
} LEDState;

/**
 *  @}
 */ /* End of group BSP_BSP_LED_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_LED_Exported_typedef
 *  @{
 */
/*----------------------------------*/
/** 
 * @brief  Initial setting. \n
 *         User must be set.
*/
/*----------------------------------*/
typedef struct
{
    uint32_t        id;             /*!< ID: User value.          */
    gpio_t          *p_gpio;        /*!< GPIO Driver Instance Address. */
    LEDState        state;          /*!< Initial State.           */
    struct
    {
        uint32_t    group;          /*!< GPIO Group. \n
                                            : Use @ref gpio_gr_t. */
        uint32_t    num;            /*!< GPIO Num. \n
                                            : Use @ref gpio_num_t.*/
    } port;
    struct
    {
        TXZ_FunctionalState func;   /*!< Turn on/off is enable/disable. 
                                            :TXZ_ENABLE/TXZ_DISABLE :Enable/Disable. */
        struct
        {
            uint32_t on;            /*!< LED ON Interval(ms). (0 < Value < 0xFFFFFFFF) */
            uint32_t off;           /*!< LED OFF Interval(ms).(0 < Value < 0xFFFFFFFF) */
        } interval;
    } blink;
} led_initial_setting_t;

/*----------------------------------*/
/** 
 * @brief  Private Information.
*/
/*----------------------------------*/
typedef struct
{
    TXZ_FunctionalState   timer;    /*!< 1ms timer processing is enable/disable. 
                                            :TXZ_ENABLE/TXZ_DISABLE :processing enable/processing disable */
    LEDState              state;    /*!< LED State.           */
    uint32_t              counter;  /*!< Interval Counter.    */
} led_private_info_t;

/*----------------------------------*/
/** 
 * @brief  LED Class.
*/
/*----------------------------------*/
typedef struct
{
    led_initial_setting_t init;     /*!< Initial setting.     */
    led_private_info_t    info;     /*!< Private information. */
} led_t;
/**
 *  @}
 */ /* End of group BSP_BSP_LED_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Functions                                                                   */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_LED_Exported_functions
 *  @{
 */
void led_initialize(led_t *p_instance);
void led_finalize(led_t *p_instance);
void led_task(led_t *p_instance);
void led_1ms_timer_handler(led_t *p_instance);
void led_turn_on(led_t *p_instance);
void led_turn_off(led_t *p_instance);
/** 
 *  @}
 */ /* End of group BSP_BSP_LED_Exported_functions */

/**
 *  @}
 */ /* End of group BSP_BSP_LED */

/**
 *  @} 
 */ /* End of group BSP */

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __BSP_CONFIG_ADBUN_M3HQA_LED_H */

