/** 
 *******************************************************************************
 * @file    bsp_config_adbun_m3hqa_pulse.c
 * @brief   PULSE
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */
#ifdef __cplusplus
 extern "C" {
#endif
/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "bsp_pulse.h"

#if defined(__BSP_CONFIG_ADBUN_M3HQA_PULSE_H)
/**
 *  @addtogroup BSP BSP
 *  @{
 */

/** 
 *  @addtogroup BSP_BSP_PULSE
 *  @{
 */
/*------------------------------------------------------------------------------*/
/*  Macro Function                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_PULSE_Private_macro
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group BSP_BSP_PULSE_Private_macro */


/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_PULSE_Private_define
 *  @{
 */
/*----------------------*/
/*  for Debug           */
/*----------------------*/
#ifdef DEBUG
    #if 1
        #define PULSE_CFG_DEBUG
    #endif
#endif
/** 
 *  @}
 */ /* End of group BSP_BSP_PULSE_Private_define */


/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_PULSE_Private_define
 *  @{
 */

#define PULSE_NULL        ((void *)0)  /*!< Null Pointer */

/** 
 *  @}
 */ /* End of group BSP_BSP_PULSE_Private_define */


/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_PULSE_Private_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group BSP_BSP_PULSE_Private_define */


/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_PULSE_Private_typedef
 *  @{
 */

/* no define */

/**
 *  @}
 */ /* End of group BSP_BSP_PULSE_Private_typedef */


/*------------------------------------------------------------------------------*/
/*  Private Member                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_PULSE_Private_variables
 *  @{
 */

/* no define */

/**
 *  @}
 */ /* End of group BSP_BSP_PULSE_Private_variables */


/*------------------------------------------------------------------------------*/
/*  Private Function                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_PULSE_Private_fuctions
 *  @{
 */
static void pulse_timer_driver_match_handler(uint32_t id, uint32_t status, TXZ_Result result);

static void pulse_timer_error(void);
/*--------------------------------------------------*/
/** 
  * @brief  Error Hook
  * @param  -
  * @return -
  * @retval -
  * @note   for debug
  */
/*--------------------------------------------------*/
static void pulse_timer_error(void)
{
#ifdef PULSE_CFG_DEBUG
    while(1)
    {
        __NOP();
    }
#endif
}

/*--------------------------------------------------*/
/** 
  * @brief  Timer Driver Compare Match Detection Handler.
  * @param  id        :User ID
  * @param  status    :Status
  * @param  result    :Result
  * @return -
  * @retval -
  * @note   Call by T32A Driver
  */
/*--------------------------------------------------*/
static void pulse_timer_driver_match_handler(uint32_t id, uint32_t status, TXZ_Result result)
{
   pulse_t *p_instance = (pulse_t *)id;

    if ((p_instance != PULSE_NULL) && (result == TXZ_SUCCESS))
    {
        /* Check INTA1 */
        if ((status & T32A_INTx1_FLG_MASK) == T32A_INTx1_FLG_MASK)
        {
            if (p_instance->init.handler != PULSE_NULL)
            {
                /* Call Handler */
                p_instance->init.handler(p_instance->init.id);
            }
        }
    }
}
/**
 *  @}
 */ /* End of group BSP_BSP_PULSE_Private_fuctions */


/*------------------------------------------------------------------------------*/
/*  Public Function                                                             */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_PULSE_Exported_functions
 *  @{
 */

/*--------------------------------------------------*/
/** 
  * @brief  Initialize for Output Pulse.
  * @param  p_instance  :Instance Source Address.
  * @return -
  * @retval -
  * @note   -
  */
/*--------------------------------------------------*/
void pulse_initialize(pulse_t *p_instance)
{
    t32a_t *pulse_t32a = p_instance->init.pulse_t32a;
    t32a_initial_setting_t *p_init = &p_instance->init.pulse_t32a->init[p_instance->init.type];
    cg_t paramCG;

    /* CG Driver Register Address Allocation. */
    paramCG.p_instance = TSB_CG;
    /*--- Initialize ---*/
    /* Calculate timer counter  . */
    {
        TXZ_WorkState loopBreak0 = TXZ_BUSY;
        TXZ_WorkState loopBreak1 = TXZ_BUSY;
        uint32_t i;

        for (i=0; (i < 8) && ((loopBreak0 == TXZ_BUSY) || (loopBreak1 == TXZ_BUSY) ); i++)
        {
            if (i == 0)
            {
                p_init->crx.prscl = T32A_PRSCLx_1;
                if (t32a_Calculator(
                        &p_init->rgx0.rgx0, 
                        p_instance->init.pulse_rising, 
                        cg_get_phyt0(&paramCG),
                        p_init->crx.prscl
                        ) == TXZ_SUCCESS)
                {
                    loopBreak0 = TXZ_DONE;
                }
                if (t32a_Calculator(
                        &p_init->rgx1.rgx1, 
                        p_instance->init.pulse_trailing, 
                        cg_get_phyt0(&paramCG),
                        p_init->crx.prscl
                        ) == TXZ_SUCCESS)
                {
                    loopBreak1 = TXZ_DONE;
                }
            }
            else
            {
                p_init->crx.prscl = (uint32_t)(i << 28);
                if (t32a_Calculator(
                        &p_init->rgx0.rgx0, 
                        p_instance->init.pulse_rising, 
                        cg_get_phyt0(&paramCG),
                        p_init->crx.prscl
                        ) == TXZ_SUCCESS)
                {
                    loopBreak0 = TXZ_DONE;
                }
                if (t32a_Calculator(
                        &p_init->rgx1.rgx1, 
                        p_instance->init.pulse_trailing, 
                        cg_get_phyt0(&paramCG),
                        p_init->crx.prscl
                        ) == TXZ_SUCCESS)
                {
                    loopBreak1 = TXZ_DONE;
                }
            }
        }
        if ((loopBreak0 == TXZ_BUSY) || (loopBreak1 == TXZ_BUSY))
        {
            pulse_timer_error();
        }
    }
    /* Run Control      */
    p_init->runx.sftstp        = T32A_COUNT_STOP;
    p_init->runx.sftsta        = T32A_COUNT_DONT_START;
    p_init->runx.run           = T32A_RUN_DISABLE;
    /* Counter Control  */
    p_init->crx.clk            = T32A_CLKx_PRSCLx;
    p_init->crx.wbf            = T32A_WBF_DISABLE;
    p_init->crx.updn           = T32A_COUNT_UP;
    p_init->crx.reld           = T32A_RELOAD_TREGx;
    p_init->crx.stop           = T32A_STOP_NON;
    p_init->crx.start          = T32A_START_NON;
    /* Output Control 0 */
    p_init->outcrx0.ocr        = T32A_OCR_DISABLE;
    /* Output Control 1 */
    p_init->outcrx1.ocrcap1    = T32A_OCRCAPx1_DISABLE;
    p_init->outcrx1.ocrcap0    = T32A_OCRCAPx0_DISABLE;
    p_init->outcrx1.ocrcmp1    = T32A_OCRCMPx1_CLR;
    p_init->outcrx1.ocrcmp0    = T32A_OCRCMPx0_SET;
    /* Counter Capture  */
    p_init->tmrx.tmrx          = 0;
    /* Counter Capture Control A0 */
    p_init->capx0.capx0        = 0;
    /* Counter Capture Control A1 */
    p_init->capx1.capx1        = 0;
    /* Interrupt mask register Set */
    p_init->imx.imuf           = T32A_IMUFx_MASK_REQ;
    p_init->imx.imof           = T32A_IMOFx_MASK_REQ;
    p_init->imx.imx1           = T32A_IMx1_MASK_NOREQ;
    p_init->imx.imx0           = T32A_IMx0_MASK_NOREQ;
    /* DMA Request      */
    p_init->dma_req.dmaenx2    = T32A_DMAENx2_DISABLE;
    p_init->dma_req.dmaenx1    = T32A_DMAENx1_DISABLE;
    p_init->dma_req.dmaenx0    = T32A_DMAENx0_DISABLE;
    /* User ID          */
    p_init->id                 = (uint32_t)p_instance;
    /* Handler          */
    p_init->handler_T = pulse_timer_driver_match_handler;
    if (t32a_timer_init(pulse_t32a, (t32_type_t)p_instance->init.type) != TXZ_SUCCESS)
    {
        pulse_timer_error();
    }
}

/*--------------------------------------------------*/
/** 
  * @brief  Finalize.
  * @param  p_instance  :Instance Source Address.
  * @return -
  * @retval -
  * @note   -
  */
/*--------------------------------------------------*/
void pulse_timer_finalize(pulse_t *p_instance)
{
    t32a_t *pulse_t32a = p_instance->init.pulse_t32a;

    if (t32a_deinit(pulse_t32a, (t32_type_t)p_instance->init.type) != TXZ_SUCCESS)
    {
        pulse_timer_error();
    }
}

/*--------------------------------------------------*/
/** 
  * @brief  Start.
  * @param  p_instance  :Instance Source Address.
  * @return -
  * @retval -
  * @note   -
  */
/*--------------------------------------------------*/
void pulse_timer_start(pulse_t *p_instance)
{
    t32a_t *pulse_t32a = p_instance->init.pulse_t32a;

    /*--- Start       ---*/
    if (t32a_timer_startIT(pulse_t32a, (t32_type_t)p_instance->init.type) != TXZ_SUCCESS)
    {
        pulse_timer_error();
    }
    if (t32a_SWcounter_start(pulse_t32a, (t32_type_t)p_instance->init.type) != TXZ_SUCCESS)
    {
        pulse_timer_error();
    }
    /*--- NVIC Enable ---*/
    NVIC_EnableIRQ(p_instance->init.irq);
}

/*--------------------------------------------------*/
/** 
  * @brief  Stop.
  * @param  p_instance  :Instance Source Address.
  * @return -
  * @retval -
  * @note   -
  */
/*--------------------------------------------------*/
void pulse_timer_stop(pulse_t *p_instance)
{
    t32a_t *pulse_t32a = p_instance->init.pulse_t32a;

    /*--- NVIC Disable ---*/
    NVIC_DisableIRQ(p_instance->init.irq);
    /*--- Stop         ---*/
    if (t32a_timer_stopIT(pulse_t32a, (t32_type_t)p_instance->init.type) != TXZ_SUCCESS)
    {
        pulse_timer_error();
    }
    if (t32a_SWcounter_stop(pulse_t32a, (t32_type_t)p_instance->init.type) != TXZ_SUCCESS)
    {
        pulse_timer_error();
    }
}

/*--------------------------------------------------*/
/** 
  * @brief  IRQ Handler.
  * @param  p_instance  :Instance Source Address.
  * @return -
  * @retval -
  * @note   -
  */
/*--------------------------------------------------*/
void pulse_timer_irq_handler(pulse_t *p_instance)
{
    t32a_t *pulse_t32a = p_instance->init.pulse_t32a;

    t32a_timer_IRQHandler(pulse_t32a);
}

/**
 *  @}
 */ /* End of group BSP_BSP_PULSE_Exported_functions */


/**
 *  @}
 */ /* End of group BSP_BSP_PULSE */

/**
 *  @} 
 */ /* End of group BSP */

#endif /* defined(__BSP_CONFIG_ADBUN_M3HQA_PULSE_H)  */
#ifdef __cplusplus
}
#endif /* __cplusplus */
