/** 
 *******************************************************************************
 * @file    bsp_config_adbun_m3hqa_pulse.h
 * @brief   External reference declaration for Timer.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */
/*------------------------------------------------------------------------------*/
/*  Define to prevent recursive inclusion                                       */
/*------------------------------------------------------------------------------*/
#ifndef __BSP_CONFIG_ADBUN_M3HQA_PULSE_H
#define __BSP_CONFIG_ADBUN_M3HQA_PULSE_H

#ifdef __cplusplus
extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "bsp_com.h"
#include "bsp_timer.h"
/**
 *  @addtogroup BSP BSP
 *  @{
 */

/** 
 *  @addtogroup BSP_BSP_PULSE
 *  @{
 */
/*------------------------------------------------------------------------------*/
/*  Macro Function                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_PULSE_Exported_macro
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group BSP_BSP_PULSE_Exported_macro */


/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_PULSE_Exported_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group BSP_BSP_PULSE_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_PULSE_Exported_define
 *  @{
 */

/* no define */


/** 
 *  @}
 */ /* End of group BSP_BSP_PULSE_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_PULSE_Exported_define
 *  @{
 */

/* no define */

/**
 *  @}
 */ /* End of group BSP_BSP_PULSE_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup BSP_BSP_PULSE_Exported_typedef
 *  @{
 */
/*----------------------------------*/
/** 
 * @brief  Initial setting. \n
 *         User must be set.
*/
/*----------------------------------*/
typedef struct
{
    uint32_t    id;         /*!< User ID.                      */
    t32a_t      *pulse_t32a;    /*!< T32A Driver Instance Address. */
    uint32_t    type;       /*!< Type. \n 
                                    Use @ref t32_type_t.       */
    IRQn_Type   irq;        /*!< Interrupt Number. \n          */
    uint32_t    pulse_rising;   /*!< Pulse Rise Period Time (us).  */
    uint32_t    pulse_trailing;   /*!< Pulse Down Period Time (us).  */
    void (*handler)(uint32_t id);   /*!< Notify :Interval Time Passed. */
} pulse_initial_setting_t;

/*----------------------------------*/
/** 
 * @brief  Private Information.
*/
/*----------------------------------*/
typedef struct
{
    uint32_t reserved;
} pulse_private_info_t;

/*----------------------------------*/
/** 
 * @brief  Timer Class.
*/
/*----------------------------------*/
typedef struct
{
    pulse_initial_setting_t init;      /*!< Initial setting.     */
    pulse_private_info_t    info;      /*!< Private information. */
} pulse_t;
/**
 *  @}
 */ /* End of group BSP_BSP_PULSE_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Functions                                                                   */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_PULSE_Exported_functions
 *  @{
 */
void pulse_initialize(pulse_t *p_instance);
void pulse_timer_finalize(pulse_t *p_instance);
void pulse_timer_start(pulse_t *p_instance);
void pulse_timer_stop(pulse_t *p_instance);
void pulse_timer_irq_handler(pulse_t *p_instance);


/** 
 *  @}
 */ /* End of group BSP_BSP_PULSE_Exported_functions */

/**
 *  @}
 */ /* End of group BSP_BSP_PULSE */

/**
 *  @} 
 */ /* End of group BSP */

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __BSP_CONFIG_ADBUN_M3HQA_PULSE_H */

