/** 
 *******************************************************************************
 * @file    bsp_config_adbun_m3hqa_sw.c
 * @brief   SW
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */
#ifdef __cplusplus
 extern "C" {
#endif
/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "bsp_sw.h"

#if defined(__BSP_CONFIG_ADBUN_M3HQA_SW_H)
/**
 *  @addtogroup BSP BSP
 *  @{
 */

/** 
 *  @addtogroup BSP_BSP_SW
 *  @{
 */
/*------------------------------------------------------------------------------*/
/*  Macro Function                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_SW_Private_macro
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group BSP_BSP_SW_Private_macro */


/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_SW_Private_define
 *  @{
 */
/*----------------------*/
/*  for Debug           */
/*----------------------*/
#ifdef DEBUG
    #if 1
        #define SW_CFG_DEBUG
    #endif
#endif
/** 
 *  @}
 */ /* End of group BSP_BSP_SW_Private_define */


/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_SW_Private_define
 *  @{
 */

#define SW_NULL        ((void *)0)  /*!< Null Pointer */

/** 
 *  @}
 */ /* End of group BSP_BSP_SW_Private_define */


/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_SW_Private_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group BSP_BSP_SW_Private_define */


/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_SW_Private_typedef
 *  @{
 */

/* no define */

/**
 *  @}
 */ /* End of group BSP_BSP_SW_Private_typedef */


/*------------------------------------------------------------------------------*/
/*  Private Member                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_SW_Private_variables
 *  @{
 */

/* no define */

/**
 *  @}
 */ /* End of group BSP_BSP_SW_Private_variables */


/*------------------------------------------------------------------------------*/
/*  Private Function                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_SW_Private_fuctions
 *  @{
 */
static void call_handler(sw_t *p_instance);

#if 0
/* now, unuse */
static void sw_error(void);
/*--------------------------------------------------*/
/** 
  * @brief  Error Hook
  * @param  -
  * @return -
  * @retval -
  * @note   for debug
  */
/*--------------------------------------------------*/
static void sw_error(void)
{
#ifdef SW_CFG_DEBUG
    while(1)
    {
        __nop();
    }
#endif
}
#endif

/*--------------------------------------------------*/
/** 
  * @brief  Call Handler
  * @param  p_instance :Instance Source Address.
  * @return -
  * @retval -
  * @note   When port state is changed, it's called.
  */
/*--------------------------------------------------*/
static void call_handler(sw_t *p_instance)
{
    if (p_instance->init.handler != SW_NULL)
    {
        p_instance->init.handler(p_instance->init.id, (gpio_pinstate_t)p_instance->info.polling.state);
    }
}

/**
 *  @}
 */ /* End of group BSP_BSP_SW_Private_fuctions */


/*------------------------------------------------------------------------------*/
/*  Public Function                                                             */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_SW_Exported_functions
 *  @{
 */
/*--------------------------------------------------*/
/** 
  * @brief  Initialize
  * @param  p_instance :Instance Source Address.
  * @return -
  * @retval -
  * @note   Parameter check isn't performed.
  * @attention This function is not available in interrupt.
  */
/*--------------------------------------------------*/
void sw_initialize(sw_t *p_instance)
{
    /*------------------------------*/
    /*  Timer Processing Disable    */
    /*------------------------------*/
    p_instance->info.timer   = TXZ_DISABLE;
    /*------------------------------*/
    /*  Private Information Initialize*/
    /*------------------------------*/
    p_instance->info.counter = 0;
    /* Notify First State */
    p_instance->info.polling.state = 0xFF;  /* Except for @ref gpio_pinstate_t */
    p_instance->info.polling.check = TXZ_ENABLE;
    /*------------------------------*/
    /*  Timer Processing Enable     */
    /*------------------------------*/
    if (p_instance->init.polling.func == TXZ_ENABLE)
    {
        p_instance->info.timer = TXZ_ENABLE;
    }
}

/*--------------------------------------------------*/
/** 
  * @brief  Finalize
  * @param  p_instance :Instance Source Address.
  * @return -
  * @retval -
  * @note   Parameter check isn't performed.
  * @attention This function is not available in interrupt.
  */
/*--------------------------------------------------*/
void sw_finalize(sw_t *p_instance)
{
    /*------------------------------*/
    /*  Timer Processing Disable    */
    /*------------------------------*/
    p_instance->info.timer   = TXZ_DISABLE;
    /*------------------------------*/
    /*  Port Setting                */
    /*------------------------------*/
    /* now, no processing */
}

/*--------------------------------------------------*/
/** 
  * @brief  Task Processing
  * @param  p_instance :Instance Source Address.
  * @return -
  * @retval -
  * @note   Parameter check isn't performed. \n
  *         Call by Main Processing.
  * @attention This function is not available in interrupt.
  */
/*--------------------------------------------------*/
void sw_task(sw_t *p_instance)
{
    if (p_instance->init.polling.func == TXZ_ENABLE)
    {
        TXZ_FunctionalState check;
        gpio_pinstate_t crt = GPIO_PIN_RESET;
        /*------------------------------*/
        /*  Check Event Flag            */
        /*------------------------------*/
        check = p_instance->info.polling.check;
        if (check == TXZ_ENABLE)
        {
            /*------------------------------*/
            /*  Timer Processing Disable    */
            /*------------------------------*/
            p_instance->info.timer = TXZ_DISABLE;
            /*------------------------------*/
            /*  Read Check Flag             */
            /*------------------------------*/
            p_instance->info.polling.check = TXZ_DISABLE;
            /*------------------------------*/
            /*  Timer Processing Enable     */
            /*------------------------------*/
            p_instance->info.timer = TXZ_ENABLE;
            /*------------------------------*/
            /* Check State                  */
            /*------------------------------*/
            {
                if(gpio_read_bit(
                                            p_instance->init.p_gpio, 
                                            p_instance->init.port.group, 
                                            p_instance->init.port.num, 
                                            GPIO_Mode_DATA, 
                                            &crt
                ) == TXZ_SUCCESS)
                {
                    if (p_instance->info.polling.state == (uint32_t)crt)
                    {
                        /*------------------------------*/
                        /* Chattering                   */
                        /*------------------------------*/
                        if (p_instance->init.chattering.func == TXZ_ENABLE)
                        {
                            p_instance->info.chattering.count++;
                            if (p_instance->info.chattering.count >= p_instance->init.chattering.count)
                            {
                                p_instance->info.chattering.count = 0;
                                /*------------------------------*/
                                /* Call Handler                 */
                                /*------------------------------*/
                                call_handler(p_instance);
                            }
                        }
                    }
                    else
                    {
                        /* Save Current State */
                        p_instance->info.polling.state = (uint32_t)crt;
                        if (p_instance->init.chattering.func == TXZ_ENABLE)
                        {
                            p_instance->info.chattering.count = 0;
                        }
                        else
                        {
                            /*------------------------------*/
                            /* Call Handler                 */
                            /*------------------------------*/
                            call_handler(p_instance);
                        }
                    }
                }
            }
        }
    }
}

/*--------------------------------------------------*/
/** 
  * @brief  1ms Timer Handler
  * @param  p_instance :Instance Source Address.
  * @return -
  * @retval -
  * @note   Parameter check isn't performed. \n
  *         Call by 1ms Timer.
  */
/*--------------------------------------------------*/
void sw_1ms_timer_handler(sw_t *p_instance)
{
    if (p_instance->info.timer == TXZ_ENABLE)
    {
        /*------------------------------*/
        /* Counter Update               */
        /*------------------------------*/
        p_instance->info.counter++;
        /*------------------------------*/
        /* Event Flag                    */
        /*------------------------------*/
        if (p_instance->init.polling.func == TXZ_ENABLE)
        {
            if (p_instance->init.polling.interval <= p_instance->info.counter)
            {
                p_instance->info.polling.check = TXZ_ENABLE;
                p_instance->info.counter = 0;
            }
        }
    }
}

/**
 *  @}
 */ /* End of group BSP_BSP_SW_Exported_functions */


/**
 *  @}
 */ /* End of group BSP_BSP_SW */

/**
 *  @} 
 */ /* End of group BSP */

#endif /* defined(__BSP_CONFIG_ADBUN_M3HQA_SW_H)  */
#ifdef __cplusplus
}
#endif /* __cplusplus */
