/** 
 *******************************************************************************
 * @file    bsp_config_adbun_m3hqa_sw.h
 * @brief   External reference declaration for SW.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */
/*------------------------------------------------------------------------------*/
/*  Define to prevent recursive inclusion                                       */
/*------------------------------------------------------------------------------*/
#ifndef __BSP_CONFIG_ADBUN_M3HQA_SW_H
#define __BSP_CONFIG_ADBUN_M3HQA_SW_H

#ifdef __cplusplus
extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "bsp_com.h"

/**
 *  @addtogroup BSP BSP
 *  @{
 */

/** 
 *  @addtogroup BSP_BSP_SW
 *  @{
 */
/*------------------------------------------------------------------------------*/
/*  Macro Function                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_SW_Exported_macro
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group BSP_BSP_SW_Exported_macro */


/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_SW_Exported_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group BSP_BSP_SW_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_SW_Exported_define
 *  @{
 */

/* no define */


/** 
 *  @}
 */ /* End of group BSP_BSP_SW_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_SW_Exported_define
 *  @{
 */

/* no define */

/**
 *  @}
 */ /* End of group BSP_BSP_SW_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_SW_Exported_typedef
 *  @{
 */
/*----------------------------------*/
/** 
 * @brief  Initial setting. \n
 *         User must be set.
*/
/*----------------------------------*/
typedef struct
{
    uint32_t        id;             /*!< ID: User value.          */
    gpio_t          *p_gpio;        /*!< GPIO Driver Instance Address. */
    struct
    {
        uint32_t    group;          /*!< GPIO Group. \n
                                            : Use @ref gpio_gr_t. */
        uint32_t    num;            /*!< GPIO Num. \n
                                            : Use @ref gpio_num_t.*/
    } port;
    struct
    {
        TXZ_FunctionalState func;   /*!< Polling is enable/disable. 
                                            :TXZ_ENABLE/TXZ_DISABLE :Enable/Disable. */
        uint32_t    interval;       /*!< Polling Interval(ms).    */
    } polling;
    struct
    {
        TXZ_FunctionalState func;   /*!< Chattering is enable/disable. 
                                            :TXZ_ENABLE/TXZ_DISABLE :Enable/Disable. */
        uint32_t    count;          /*!< Chattering Count.        */
    } chattering;
    void (*handler)(uint32_t id, gpio_pinstate_t state);    /*!< SW State Change Handler. */
} sw_initial_setting_t;

/*----------------------------------*/
/** 
 * @brief  Private Information.
*/
/*----------------------------------*/
typedef struct
{
    TXZ_FunctionalState timer;      /*!< 1ms timer processing is enable/disable. 
                                            :TXZ_ENABLE/TXZ_DISABLE :processing enable/processing disable */
    uint32_t counter;               /*!< Interval Counter.    */
    struct
    {
        TXZ_FunctionalState check;  /*!< Port Check is enable/disable. 
                                            :TXZ_ENABLE/TXZ_DISABLE :Enable/Disable. */
        uint32_t state;             /*!< SW Port State.       */
    } polling;
    struct
    {
        uint32_t count;             /*!< Chattering Count.    */
    } chattering;
} sw_private_info_t;

/*----------------------------------*/
/** 
 * @brief  SW Class.
*/
/*----------------------------------*/
typedef struct
{
    sw_initial_setting_t init;      /*!< Initial setting.     */
    sw_private_info_t    info;      /*!< Private information. */
} sw_t;
/**
 *  @}
 */ /* End of group BSP_BSP_SW_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Functions                                                                   */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_SW_Exported_functions
 *  @{
 */
void sw_initialize(sw_t *p_instance);
void sw_finalize(sw_t *p_instance);
void sw_task(sw_t *p_instance);
void sw_1ms_timer_handler(sw_t *p_instance);
/** 
 *  @}
 */ /* End of group BSP_BSP_SW_Exported_functions */

/**
 *  @}
 */ /* End of group BSP_BSP_SW */

/**
 *  @} 
 */ /* End of group BSP */

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __BSP_CONFIG_ADBUN_M3HQA_SW_H */

