/** 
 *******************************************************************************
 * @file    bsp_config_adbun_m3hqa_timer.h
 * @brief   External reference declaration for Timer.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */
/*------------------------------------------------------------------------------*/
/*  Define to prevent recursive inclusion                                       */
/*------------------------------------------------------------------------------*/
#ifndef __BSP_CONFIG_ADBUN_M3HQA_TIMER_H
#define __BSP_CONFIG_ADBUN_M3HQA_TIMER_H

#ifdef __cplusplus
extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "bsp_com.h"

/**
 *  @addtogroup BSP BSP
 *  @{
 */

/** 
 *  @addtogroup BSP_BSP_TIMER
 *  @{
 */
/*------------------------------------------------------------------------------*/
/*  Macro Function                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_TIMER_Exported_macro
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group BSP_BSP_TIMER_Exported_macro */


/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_TIMER_Exported_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group BSP_BSP_TIMER_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_TIMER_Exported_define
 *  @{
 */

/* no define */


/** 
 *  @}
 */ /* End of group BSP_BSP_TIMER_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_TIMER_Exported_define
 *  @{
 */

/* no define */

/**
 *  @}
 */ /* End of group BSP_BSP_TIMER_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup BSP_BSP_TIMER_Exported_typedef
 *  @{
 */
/*----------------------------------*/
/** 
 * @brief  Initial setting. \n
 *         User must be set.
*/
/*----------------------------------*/
typedef struct
{
    uint32_t    id;         /*!< User ID.                      */
    t32a_t      *p_t32a;    /*!< T32A Driver Instance Address. */
    uint32_t    type;       /*!< Type. \n 
                                    Use @ref t32_type_t.       */
    IRQn_Type   irq;        /*!< Interrupt Number. \n          */
    uint32_t    interval;   /*!< Interval Time (us).           */
    void (*handler)(uint32_t id);   /*!< Notify :Interval Time Passed. */
} timer_initial_setting_t;

/*----------------------------------*/
/** 
 * @brief  Private Information.
*/
/*----------------------------------*/
typedef struct
{
    uint32_t reserved;
} timer_private_info_t;

/*----------------------------------*/
/** 
 * @brief  Timer Class.
*/
/*----------------------------------*/
typedef struct
{
    timer_initial_setting_t init;      /*!< Initial setting.     */
    timer_private_info_t    info;      /*!< Private information. */
} timer_t;
/**
 *  @}
 */ /* End of group BSP_BSP_TIMER_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Functions                                                                   */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_TIMER_Exported_functions
 *  @{
 */
void timer_initialize(timer_t *p_instance);
void timer_finalize(timer_t *p_instance);
void timer_start(timer_t *p_instance);
void timer_stop(timer_t *p_instance);
void timer_irq_handler(timer_t *p_instance);


/** 
 *  @}
 */ /* End of group BSP_BSP_TIMER_Exported_functions */

/**
 *  @}
 */ /* End of group BSP_BSP_TIMER */

/**
 *  @} 
 */ /* End of group BSP */

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __BSP_CONFIG_ADBUN_M3HQA_TIMER_H */

