/** 
 *******************************************************************************
 * @file    bsp_config_adbun_m3hqa_uart_io.h
 * @brief   External reference declaration for USB UART.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */
/*------------------------------------------------------------------------------*/
/*  Define to prevent recursive inclusion                                       */
/*------------------------------------------------------------------------------*/
#ifndef __BSP_CONFIG_ADBUN_M3HQA_UART_IO_H
#define __BSP_CONFIG_ADBUN_M3HQA_UART_IO_H

#ifdef __cplusplus
extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include <stdarg.h>
#include "bsp_com.h"

/**
 *  @addtogroup BSP BSP
 *  @{
 */

/** 
 *  @addtogroup BSP_BSP_UART_IO
 *  @{
 */
/*------------------------------------------------------------------------------*/
/*  Macro Function                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_UART_IO_Exported_macro
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group BSP_BSP_UART_IO_Exported_macro */


/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_UART_IO_Exported_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group BSP_BSP_UART_IO_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_UART_IO_Exported_define
 *  @{
 */

#define UART_IO_SEND_MAX       ((uint32_t)32)   /*!< Size of send max. (byte)    */
#define UART_IO_RECEIVE_MAX    ((uint32_t)32)   /*!< Size of receive max. (byte) */
/** 
 *  @}
 */ /* End of group BSP_BSP_UART_IO_Exported_define */

/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_UART_IO_Exported_define
 *  @{
 */

/*----------------------------------*/
/** 
 * @brief  Send state.
*/
/*----------------------------------*/
typedef enum {
    UART_IO_SEND_IDLE = 0U,     /*!< Idle                   */
    UART_IO_SEND_RUN,           /*!< Transmiting.           */
    UART_IO_SEND_SUCCESS,       /*!< Transmission complete. */
    UART_IO_SEND_FAILURE        /*!< Transmission error.    */
} UartIOTxState;

/*----------------------------------*/
/** 
 * @brief  Receive state.
*/
/*----------------------------------*/
typedef enum {
    UART_IO_RECV_IDLE = 0U,     /*!< Idle                   */
    UART_IO_RECV_RUN,           /*!< Receiving              */
    UART_IO_RECV_FAILURE        /*!< Received error.        */
} UartIORxState;

/**
 *  @}
 */ /* End of group BSP_BSP_UART_IO_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_UART_IO_Exported_typedef
 *  @{
 */
/*----------------------------------*/
/** 
 * @brief  Initial setting. \n
 *         User must be set.
*/
/*----------------------------------*/
typedef struct
{
    uint32_t            id;             /*!< User ID.                */
    TSB_UART_TypeDef    *p_reg;         /*!< Register Bass Address.  */
    uint32_t            boudrate;       /*!< Boudrate(bps).          */
    struct
    {
        IRQn_Type       tx;             /*!< Interrupt Number :Tx    */
        IRQn_Type       rx;             /*!< Interrupt Number :Rx    */
        IRQn_Type       err;            /*!< Interrupt Number :Err   */
    } irq;
} uart_io_initial_setting_t;

/*----------------------------------*/
/** 
 * @brief  Send information.
 * @brief  Private Member.
*/
/*----------------------------------*/
typedef struct
{
    volatile UartIOTxState  state;              /*!< Status.                     */
    uint32_t                wp;                 /*!< Write pointer.              */
    uint32_t                rp;                 /*!< Read pointer(Now, no use).  */
    uint8_t                 buff[UART_IO_SEND_MAX];     /*!< Send data.                  */
} uart_io_private_tx_t;

/*----------------------------------*/
/** 
 * @brief  Receive information.
 * @brief  Private Member.
*/
/*----------------------------------*/
typedef struct
{
    volatile UartIORxState  state;              /*!< Status.                     */
    volatile uint32_t       wp;                 /*!< Write pointer.              */
    volatile uint32_t       rp;                 /*!< Read pointer(Now, no use).  */
    volatile uint32_t       length;             /*!< Num of receive data.        */
    volatile uint8_t        buff[UART_IO_RECEIVE_MAX];  /*!< Receive data.               */
} uart_io_private_rx_t;

/*----------------------------------*/
/** 
 * @brief  Private Member.
*/
/*----------------------------------*/
typedef struct
{
    uart_t                  uart;               /*!< Uart driver instance.       */
    uart_io_private_tx_t    tx;                 /*!< Send information.           */
    uart_io_private_rx_t    rx;                 /*!< Receive information.        */
    uint8_t                 work[UART_RX_FIFO_MAX];     /*!< Receive buffer for uart driver. */
} uart_io_private_info_t;

/*----------------------------------*/
/** 
 * @brief  USB UART class.
*/
/*----------------------------------*/
typedef struct
{
    uart_io_initial_setting_t init; /*!< Initial setting.     */
    uart_io_private_info_t    info; /*!< Private information. */
} uart_io_t;

/**
 *  @}
 */ /* End of group BSP_BSP_UART_IO_Exported_typedef */

/*------------------------------------------------------------------------------*/
/*  Functions                                                                   */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_UART_IO_Exported_functions
 *  @{
 */
TXZ_Result uart_io_initialize(uart_io_initial_setting_t *p_pram);
void uart_io_finalize(void);
void uart_io_tx_irq_handler(void);
void uart_io_rx_irq_handler(void);
void uart_io_err_irq_handler(void);
/** 
 *  @}
 */ /* End of group BSP_BSP_UART_IO_Exported_functions */

/**
 *  @}
 */ /* End of group BSP_BSP_UART_IO */

/**
 *  @} 
 */ /* End of group BSP */

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __BSP_CONFIG_ADBUN_M3HQA_UART_IO_H */

