/** 
 *******************************************************************************
 * @file    bsp_config_adbun_m3hqa_uart_io_dma.h
 * @brief   External reference declaration for UART input/output
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */
/*------------------------------------------------------------------------------*/
/*  Define to prevent recursive inclusion                                       */
/*------------------------------------------------------------------------------*/
#ifndef __BSP_CONFIG_ADBUN_M3HQA_UART_IO_DMA_H
#define __BSP_CONFIG_ADBUN_M3HQA_UART_IO_DMA_H

#ifdef __cplusplus
extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include <stdarg.h>
#include "bsp_com.h"

/**
 *  @addtogroup BSP BSP
 *  @{
 */

/** 
 *  @addtogroup BSP_BSP_UART_IO_DMA
 *  @{
 */
/*------------------------------------------------------------------------------*/
/*  Macro Function                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_UART_IO_DMA_Exported_macro
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group BSP_BSP_UART_IO_DMA_Exported_macro */


/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_UART_IO_DMA_Exported_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group BSP_BSP_UART_IO_DMA_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_UART_IO_DMA_Exported_define
 *  @{
 */

#define UART_IO_DMA_SEND_MAX       ((uint32_t)32)   /*!< Size of send max. (byte)    */
#define UART_IO_DMA_RECEIVE_MAX    ((uint32_t)32)   /*!< Size of receive max. (byte) */
/** 
 *  @}
 */ /* End of group BSP_BSP_UART_IO_DMA_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_UART_IO_DMA_Exported_define
 *  @{
 */

/*----------------------------------*/
/** 
 * @brief  Send state.
*/
/*----------------------------------*/
typedef enum {
    UART_IO_DMA_SEND_IDLE = 0U,     /*!< Idle                   */
    UART_IO_DMA_SEND_RUN,           /*!< Transmiting.           */
    UART_IO_DMA_SEND_SUCCESS,       /*!< Transmission complete. */
    UART_IO_DMA_SEND_FAILURE        /*!< Transmission error.    */
} UartIODmaTxState;

/*----------------------------------*/
/** 
 * @brief  Receive state.
*/
/*----------------------------------*/
typedef enum {
    UART_IO_DMA_RECV_IDLE = 0U,     /*!< Idle                   */
    UART_IO_DMA_RECV_RUN,           /*!< Receiving              */
    UART_IO_DMA_RECV_SUCCESS,       /*!< Received complete.     */
    UART_IO_DMA_RECV_FAILURE        /*!< Received error.        */
} UartIODmaRxState;

/**
 *  @}
 */ /* End of group BSP_BSP_UART_IO_DMA_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_UART_IO_DMA_Exported_typedef
 *  @{
 */
/*----------------------------------*/
/** 
 * @brief  USB UART Initial Setting.
*/
/*----------------------------------*/
typedef struct
{
    uint32_t            id;         /*!< User ID.         */
    TSB_UART_TypeDef    *p_reg;     /*!< Register Bass Address.  */
    uint32_t            boudrate;   /*!< Boudrate(bps).   */
    struct
    {
        dma_t           *p_dma;     /*!< DMA driver instance address.  */
        uint32_t        tx;         /*!< DMA Tx Channel.  */
        uint32_t        rx;         /*!< DMA Rx Channel.  */
    } dma;
} uart_io_dma_initial_setting_t;

/*----------------------------------*/
/** 
 * @brief  USB UART Send information.
 * @brief  Private Member.
*/
/*----------------------------------*/
typedef struct
{
    volatile UartIODmaTxState   state;  /*!< Status.                     */
    uint8_t                     buff[UART_IO_DMA_SEND_MAX];         /*!< Send data.                  */
} uart_io_dma_private_tx_t;

/*----------------------------------*/
/** 
 * @brief  USB UART Receive information.
 * @brief  Private Member.
*/
/*----------------------------------*/
typedef struct
{
    volatile UartIODmaRxState   state;  /*!< Status.                     */
    uint8_t                     buff[UART_IO_DMA_RECEIVE_MAX];    /*!< Receive data.               */
} uart_io_dma_private_rx_t;

/*----------------------------------*/
/** 
 * @brief  USB UART Private Member.
*/
/*----------------------------------*/
typedef struct
{
    uart_dma_t                  uart;   /*!< Uart driver instance.       */
    uart_io_dma_private_tx_t    tx;     /*!< Send information.           */
    uart_io_dma_private_rx_t    rx;     /*!< Receive information.        */
} uart_io_dma_private_info_t;

/*----------------------------------*/
/** 
 * @brief  USB UART class.
*/
/*----------------------------------*/
typedef struct
{
    uart_io_dma_initial_setting_t init; /*!< Initial setting.     */
    uart_io_dma_private_info_t    info; /*!< Private information. */
} uart_io_dma_t;

/**
 *  @}
 */ /* End of group BSP_BSP_UART_IO_DMA_Exported_typedef */


/*------------------------------------------------------------------------------*/
/*  Functions                                                                   */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup BSP_BSP_UART_IO_DMA_Exported_functions
 *  @{
 */
uart_io_dma_t *uart_io_dma_initialize(uart_io_dma_initial_setting_t *p_param);
void uart_io_dma_finalize(uart_io_dma_t *p_instance);
/** 
 *  @}
 */ /* End of group BSP_BSP_UART_IO_DMA_Exported_functions */

/**
 *  @}
 */ /* End of group BSP_BSP_UART_IO_DMA */

/**
 *  @} 
 */ /* End of group BSP */

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __BSP_CONFIG_ADBUN_M3HQA_UART_IO_DMA_H */

