/**
 *****************************************************************************
 * @file     configration.h
 * @brief    CMSIS Cortex-M3 Device Peripheral Access Layer Header File for the
 *           TOSHIBA 'TMPM3Hz' Device Series 
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *****************************************************************************
 */

#ifndef __CONFIGRATION_H
#define __CONFIGRATION_H

#ifdef __cplusplus
extern "C" {
#endif 

/* Define clocks */
#define IOSC_10M_DIV4_PLLON     (80000000UL)    /* 10.00MHz * 32.0000 / 4 */
#define IOSC_10M_DIV8_PLLON     (40000000UL)    /* 10.00MHz * 32.0000 / 8 */
#define IOSC_10M_DIV2_PLLON     (120000000UL)   /* 10.00MHz * 24.0000 / 2 */

#define EOSC_6M                 (6000000UL)
#define EOSC_8M                 (8000000UL)
#define EOSC_10M                (10000000UL)
#define EOSC_12M                (12000000UL)
#define EXTALH                  EOSC_12M        /* External high-speed oscillator freq */
#define EOSC_6M_DIV4_PLLON      (79970000UL)    /* 6.00MHz  * 53.3125 / 4 */
#define EOSC_8M_DIV4_PLLON      (80000000UL)    /* 8.00MHz  * 40.0000 / 4 */
#define EOSC_10M_DIV4_PLLON     (80000000UL)    /* 10.00MHz * 32.0000 / 4 */
#define EOSC_12M_DIV4_PLLON     (79880000UL)    /* 12.00MHz * 26.6250 / 4 */
#define EOSC_6M_DIV8_PLLON      (39980000UL)    /* 6.00MHz  * 53.3125 / 8 */
#define EOSC_8M_DIV8_PLLON      (40000000UL)    /* 8.00MHz  * 40.0000 / 8 */
#define EOSC_10M_DIV8_PLLON     (40000000UL)    /* 10.00MHz * 32.0000 / 8 */
#define EOSC_12M_DIV8_PLLON     (39940000UL)    /* 12.00MHz * 26.6250 / 8 */
#define EOSC_6M_DIV2_PLLON      (120000000UL)   /* 6.00MHz  * 40.0000 / 2 */
#define EOSC_8M_DIV2_PLLON      (120000000UL)   /* 8.00MHz  * 30.0000 / 2 */
#define EOSC_10M_DIV2_PLLON     (120000000UL)   /* 10.00MHz * 24.0000 / 2 */
#define EOSC_12M_DIV2_PLLON     (120000000UL)   /* 12.00MHz * 20.0000 / 2 */

#define FIXED_6MHz              (6000000UL)     /* 6.00MHz */
#define FIXED_8MHz              (8000000UL)     /* 8.00MHz */
#define FIXED_10MHz             (10000000UL)    /* 10.00MHz */
#define FIXED_12MHz             (12000000UL)    /* 12.00MHz */
#define FIXED_40MHz             (40000000UL)    /* 40.00MHz */
#define FIXED_80MHz             (80000000UL)    /* 80.00MHz */
#define FIXED_120MHz            (120000000UL)   /* 120.00MHz */

#ifdef __cplusplus
}
#endif

#endif
