/**
 *******************************************************************************
 * @file    system_TRMOSC.c
 * @brief   TRMOSC Sample Application.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */

#include "bsp_com.h"
#include "flash.h"
#include "fc_copy.h"
#include "siwdt.h"

/*-------- <<< Start of configuration section >>> ----------------------------*/

/* Semi-Independent Watchdog Timer (SIWDT) Configuration */
#define SIWDEN_Val              (0x00000000UL)            /* SIWD Disable */
#define SIWDCR_Val              (0x000000B1UL)            /* SIWD Disable code */

/*-------- <<< End of configuration section >>> ------------------------------*/

/*-------- DEFINES -----------------------------------------------------------*/
/* Define clocks */
#define IOSC_10M                (10000000UL)
#define IXTALH                  IOSC_10M        /* Internal high-speed oscillator freq */

/* Determine core clock frequency according to settings */
/* System clock is high-speed clock*/
#define CORE_TALH (IXTALH)
#define __CORE_CLK   (CORE_TALH)
#define __CORE_SYS   (__CORE_CLK)


/* Clock Variable definitions */
uint32_t SystemCoreClock = __CORE_SYS;  /*!< System Clock Frequency (Core Clock) */

/**
 * Initialize the system
 *
 * @param  -
 * @return -
 *
 * @brief  Update SystemCoreClock according register values.
 */
void SystemCoreClockUpdate(void)
{                               /* Get Core Clock Frequency */
    SystemCoreClock = IXTALH;
}

/**
 * Initialize the system
 *
 * @param  -
 * @return -
 *
 * @brief  Setup the microcontroller system.
 *         Initialize the System.
 */
void SystemInit(void)
{
    flash_t flash;
    flash.p_instance = TSB_FC;

    /* SIWD Disable */
    wdt_disable(TSB_SIWD0);

    /* Internal HOSC Enable (Setting after a Reset) */

    copy_fc_function();
    fc_read_clock_set(&flash);
}
