/** 
 *******************************************************************************
 * @file    cg_m3h1_d.h
 * @brief   This file provides all the functions prototypes for CG driver.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */
/*------------------------------------------------------------------------------*/
/*  Define to prevent recursive inclusion                                       */
/*------------------------------------------------------------------------------*/
#ifndef __CG_M3H1_H
#define __CG_M3H1_H

#ifdef __cplusplus
extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "driver_com.h"
#include "configration.h"
/**
 *  @addtogroup Periph_Driver
 *  @{
 */

/** 
 *  @defgroup CG CG
 *  @brief    CG Driver.
 *  @{
 */

/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup CG_Exported_define CG Exported Define
 *  @{
 */

#define CG_GEAR_FC_1            ((uint32_t)0x00000000)      /*!< CG fc register value */
#define CG_GEAR_FC_2            ((uint32_t)0x00000001)      /*!< CG fc/2 register value */
#define CG_GEAR_FC_4            ((uint32_t)0x00000002)      /*!< CG fc/4 register value */
#define CG_GEAR_FC_8            ((uint32_t)0x00000003)      /*!< CG fc/8 register value */
#define CG_GEAR_FC_16           ((uint32_t)0x00000004)      /*!< CG fc/16 register value */
#define CG_PRCK_FC_1            ((uint32_t)0x00000000)      /*!< CG T0 fc register value */
#define CG_PRCK_FC_2            ((uint32_t)0x00000100)      /*!< CG T0 fc/2 register value */
#define CG_PRCK_FC_4            ((uint32_t)0x00000200)      /*!< CG T0 fc/4 register value */
#define CG_PRCK_FC_8            ((uint32_t)0x00000300)      /*!< CG T0 fc/8 register value */
#define CG_PRCK_FC_16           ((uint32_t)0x00000400)      /*!< CG T0 fc/16 register value */
#define CG_PRCK_FC_32           ((uint32_t)0x00000500)      /*!< CG T0 fc/32 register value */
#define CG_PRCK_FC_64           ((uint32_t)0x00000600)      /*!< CG T0 fc/64 register value */
#define CG_PRCK_FC_128          ((uint32_t)0x00000700)      /*!< CG T0 fc/128 register value */
#define CG_PRCK_FC_256          ((uint32_t)0x00000800)      /*!< CG T0 fc/256 register value */
#define CG_PRCK_FC_512          ((uint32_t)0x00000900)      /*!< CG T0 fc/512 register value */

#define IOSC_10M                (10000000UL)
#define IXTALH                  IOSC_10M                    /* Internal high-speed oscillator freq */

#define CG_WARM_UP_SRC_EHOSC    ((uint32_t)0x000000100)     /*!< CG warm up src EHOSC */
#define CG_WARM_UP_SRC_IHOSC1   ((uint32_t)0x00000000)      /*!< CG warm up src IHOSC1 */

#define CG_EHOSCEN_UNUSE        ((uint32_t)0x00000000)      /*!< CG EHOSCEN unuse */
#define CG_EHOSCEN_EHOSC        ((uint32_t)0x00000002)      /*!< CG EHOSCEN EHOSC */
#define CG_EHOSCEN_EHOCLKIN     ((uint32_t)0x00000004)      /*!< CG EHOSCEN EHOCLKIN */

#define CG_OSCSEL_EHOSC         ((uint32_t)0x00000100)      /*!< CG OSCSEL EHOSC */
#define CG_OSCSEL_IHOSC1        ((uint32_t)0x00000000)      /*!< CG OSCSEL IHOSC1 */

#define CG_STBY_IDLE            ((uint32_t)0x00000000)      /*!< CG STBY IDLE */
#define CG_STBY_STOP1           ((uint32_t)0x00000001)      /*!< CG STBY STOP1 */
#define CG_STBY_STOP2           ((uint32_t)0x00000002)      /*!< CG STBY STOP2 */

#define CG_SCOSEL_FOSC          ((uint32_t)0x00000000)      /*!< CG SCOUT fosc */
#define CG_SCOSEL_FC            ((uint32_t)0x00000002)      /*!< CG SCOUT fc */
#define CG_SCOSEL_FS            ((uint32_t)0x00000004)      /*!< CG SCOUT fs */
#define CG_SCOSEL_FSYS          ((uint32_t)0x00000006)      /*!< CG SCOUT fsys */

#define CG_SCODIV_1             ((uint32_t)0x00000000)      /*!< CG SCOUT/1 register value */
#define CG_SCODIV_2             ((uint32_t)0x00000010)      /*!< CG SCOUT/2 register value */
#define CG_SCODIV_4             ((uint32_t)0x00000020)      /*!< CG SCOUT/4 register value */
#define CG_SCODIV_8             ((uint32_t)0x00000030)      /*!< CG SCOUT/8 register value */
#define CG_SCODIV_16            ((uint32_t)0x00000040)      /*!< CG SCOUT/16 register value */

/* Configure Warm-up time */
#define HZ_1M                   (1000000UL)
#define WU_TIME_EXT             (5000UL)                    /* warm-up time for EXT is 5ms   */
#define WU_TIME_INT             (1634UL)                    /* warm-up time for INT is 163.4us x 10 */
#define WU_TIME_INT_MIN         (0x03C << 20U)              /* minimum warm-up time for INT */
#define CGWUPHCR_WUEF_R_DONE    ((uint32_t)0x00000000)      /*!< WUEF    :[R]    :Done    */

/* Warm-up setting value */
/* EOSC OSCCR<WUPT11:0> = (warm-up time(us) * EXTALH - 16) / 16 */
#define WUPHCR_WUPT_EXT         ((uint32_t)(((((uint64_t)WU_TIME_EXT * EXTALH / HZ_1M) - 16UL) /16UL) << 20U))
/* IOSC OSCCR<WUPT11:0> = ((warm-up time(us) - 63.3us) * IXTALH - 41) / 16 */
#define WUPHCR_WUPT_INT         ((uint32_t)(((((uint64_t)(WU_TIME_INT - 633UL) * (IXTALH / 10) / HZ_1M) - 41UL) / 16UL) << 20U))

#if (CLOCK_SETUP)
    #define WUPHCR_INIT_PLL     ((uint32_t)(((((uint64_t)INIT_TIME_PLL * EXTALH / HZ_1M) - 16UL) /16UL) << 20U))
    #define WUPHCR_LUPT_PLL     ((uint32_t)(((((uint64_t)LOCKUP_TIME_PLL * EXTALH / HZ_1M) - 16UL) /16UL) << 20U))
#else
    #define WUPHCR_INIT_PLL     ((uint32_t)(((((uint64_t)((INIT_TIME_PLL * 10) - 633UL) * (IXTALH / 10) / HZ_1M) - 41UL) /16UL) << 20U))
    #define WUPHCR_LUPT_PLL     ((uint32_t)(((((uint64_t)((LOCKUP_TIME_PLL * 10) - 633UL) * (IXTALH /10) / HZ_1M) - 41UL) /16UL) << 20U))
#endif

#define CG_6M_MUL_6_664_FPLL    (0x001C3535UL<<8U)          /* 6MHz  ->  40MHz  fPLL = 6MHz  * 6.664    */
#define CG_8M_MUL_5_FPLL        (0x00247028UL<<8U)          /* 8MHz  ->  40MHz  fPLL = 8MHz  * 5        */
#define CG_10M_MUL_4_FPLL       (0x002EB020UL<<8U)          /* 10MHz ->  40MHz  fPLL = 10MHz * 4        */
#define CG_12M_MUL_3_328_FPLL   (0x0036FA1AUL<<8U)          /* 12MHz ->  40MHz  fPLL = 12MHz * 3.328    */
#define CG_6M_MUL_13_328_FPLL   (0x001C2535UL<<8U)          /* 6MHz  ->  80MHz  fPLL = 6MHz  * 13.328   */
#define CG_8M_MUL_10_FPLL       (0x00246028UL<<8U)          /* 8MHz  ->  80MHz  fPLL = 8MHz  * 10       */
#define CG_10M_MUL_8_FPLL       (0x002EA020UL<<8U)          /* 10MHz ->  80MHz  fPLL = 10MHz * 8        */
#define CG_12M_MUL_6_656_FPLL   (0x0036EA1AUL<<8U)          /* 12MHz ->  80MHz  fPLL = 12MHz * 6.656    */
#define CG_6M_MUL_20_FPLL       (0x001C1028UL<<8U)          /* 6MHz  ->  120MHz fPLL = 6MHz  * 20       */
#define CG_8M_MUL_15_FPLL       (0x0024501EUL<<8U)          /* 8MHz  ->  120MHz fPLL = 8MHz  * 15       */
#define CG_10M_MUL_12_FPLL      (0x002E9018UL<<8U)          /* 10MHz ->  120MHz fPLL = 10MHz * 12       */
#define CG_12M_MUL_10_FPLL      (0x0036D014UL<<8U)          /* 12MHz ->  120MHz fPLL = 12MHz * 10       */

#define CG_PLL0SEL_FPLL         ((uint32_t)0x00000002)      /*!< CG PLL0SEL fPLL */
#define CG_PLL0SEL_FOSC         ((uint32_t)0x00000000)      /*!< CG PLL0SEL fosc */

#define CG_PLL0SEL_PLL0ON_SET   (0x00000001)                /*!< CG PLL0OON on */
#define PLL0SEL_MASK            (0xFFFFFF00UL)              /*!< CG PLL mask */
/**
 *  @}
 */ /* End of group CG_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup CG_Exported_define CG Exported Define
 *  @{
 */
/* no define */
/**
 *  @}
 */ /* End of group CG_Exported_define */

/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup CG_Exported_typedef CG Exported Typedef
 *  @{
 */
/** 
 * @brief  CG member.
*/
/*----------------------------------*/
typedef struct
{
    TSB_CG_TypeDef       *p_instance;     /*!< Registers base address.           */
} cg_t;

/** 
 * @brief  RLM member.
*/
/*----------------------------------*/
typedef struct
{
    TSB_RLM_TypeDef       *p_instance;     /*!< Registers base address.           */
} rlm_t;
/**
 *  @}
 */ /* End of group CG_Exported_typedef */

/*------------------------------------------------------------------------------*/
/*  Functions                                                                   */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup CG_Exported_functions CG Exported Functions
 *  @{
 */
void cg_set_gear(cg_t *p_obj, uint32_t gear);
void cg_set_phyt0(cg_t *p_obj, uint32_t prck);
void cg_set_warm_up_time(cg_t *p_obj, uint32_t source, uint32_t time);
void cg_start_warmup(void);
void cg_wait_warmup(void);
TXZ_WorkState cg_get_warm_up_state(void);
void cg_set_ehoscen(cg_t *p_obj, uint32_t eoscen);
void cg_set_oscsel(uint32_t source);
uint32_t cg_get_oscsel(void);
uint32_t cg_get_gear(cg_t *p_obj);
uint32_t cg_get_phyt0(cg_t *p_obj);
void cg_ihosc1_enable(void);
void cg_ihosc1_disable(void);
void cg_set_PLL(cg_t *p_obj, uint32_t PLLset);
void cg_PLL_enable(void);
void cg_PLL_disable(void);
void cg_set_stby_mode(cg_t *p_obj, uint32_t mode);
void cg_set_PLL_clock(uint32_t clock);
uint32_t cg_get_PLL_status(void);
void cg_protect_enable(cg_t *p_obj);
void cg_protect_disable(cg_t *p_obj);
TXZ_WorkState cg_get_ihosc1_state(void);
TXZ_WorkState cg_get_ihosc2_state(void);
void cg_ihosc2_enable(void);
void cg_ihosc2_disable(void);
void cg_scout_enable(void);
void cg_scout_disable(void);
void cg_set_scout_clock(cg_t *p_obj, uint32_t source);
void cg_set_scout_time(cg_t *p_obj, uint32_t time);
uint32_t cg_get_stby_mode(cg_t *p_obj);
void cg_set_low_warm_up_time(cg_t *p_obj, uint32_t time);
void cg_start_low_warmup(void);
TXZ_WorkState cg_get_low_warm_up_state(void);
void cg_get_system_core_clock(cg_t *p_obj);
void rlm_port_keep_enable(rlm_t *p_obj);
void rlm_port_keep_disable(rlm_t *p_obj);
void rlm_protect_enable(rlm_t *p_obj);
void rlm_protect_disable(rlm_t *p_obj);
void rlm_fs_enable(rlm_t *p_obj);
void rlm_fs_disable(rlm_t *p_obj);
/**
 *  @}
 */ /* End of group CG_Exported_functions */

/**
 *  @}
 */ /* End of group CG */

/**
 *  @}
 */ /* End of group Periph_Driver */

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __CG_M3H1_H */


