/**
 *******************************************************************************
 * @file    crc_a.c
 * @brief   This file provides API functions for CRC.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */

#ifdef __cplusplus
 extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "crc.h"

#if defined(__CRC_A_H)
/**
 *  @addtogroup Periph_Driver Peripheral Driver
 *  @{
 */

/** 
 *  @addtogroup CRC
 *  @brief      CRC Driver
 *  @{
 */
/*------------------------------------------------------------------------------*/
/*  Macro Function                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup CRC_Private_macro
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group CRC_Private_macro */


/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup CRC_Private_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group CRC_Private_define */

/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup CRC_Private_define
 *  @{
 */

/** 
 *  @defgroup Null Null Pointer
 *  @brief    Null Pointer.
 *  @{
 */
#define REG_CRC_NULL                  ((void *)0)
/**
 *  @}
 */ /* End of group Null */

/** 
 *  @defgroup CheckParamResult Parameter Check Result
 *  @brief    Whether the parameter is specified or not.
 *  @{
 */
#define REG_CRC_PARAM_OK              ((int32_t)1)              /*!< Parameter is valid(specified).         */
#define REG_CRC_PARAM_NG              ((int32_t)0)              /*!< Parameter is invalid(not specified).   */
/**
 *  @}
 */ /* End of name Parameter CheckParamResult */


/** 
 *  @}
 */ /* End of group CRC_Private_define */


/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup CRC_Private_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group CRC_Private_define */


/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup CRC_Private_typedef
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group CRC_Private_typedef */

/*------------------------------------------------------------------------------*/
/*  Private Member                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup CRC_Private_variables
 *  @{
 */

/* no define */

/**
 *  @}
 */ /* End of group CRC_Private_variables */


/*------------------------------------------------------------------------------*/
/*  Private Function                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup CRC_Private_fuctions
 *  @{
 */

/* No define */

/**
 *  @}
 */ /* End of group CRC_Private_fuctions */


/*------------------------------------------------------------------------------*/
/*  Public Function                                                             */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup CRC_Exported_functions
 *  @{
 */
/*--------------------------------------------------*/
/**
  * @brief  Set CRC input data.
  * @param  p_reg   :Register Base Address.
  * @param  data    :Input Data
  * @return -
  * @retval -
  * @note   The used register.
  * | Register  | Bit Symbol |
  * | :---      | :---       |
  * | CRCDIN    | CRCDIN     |
  */
/*--------------------------------------------------*/
void REG_CRCDIN_set(TSB_CRC_TypeDef *p_reg, uint32_t data)
{
    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
#ifdef DEBUG
    /* Check the REG_CRC_NULL of address. */
    assert_param(IS_POINTER_NOT_NULL(p_reg));
#endif /* #ifdef DEBUG */
    /*--- [CRCDIN]<CRCDIN> ---*/
    /*------------------------------*/
    /*  Register Set                */
    /*------------------------------*/
    p_reg->DIN = data;
}
/*--------------------------------------------------*/
/**
  * @brief  Set CRC parameter.
  * @param  p_reg   :Register Base Address.
  * @param  param   :Input Data
  * @return -
  * @retval -
  * @note   The used register.
  * | Register  | Bit Symbol |
  * | :---      | :---       |
  * | CRCTYP    | :---       |
  * |           | RRFL       |
  * |           | DRFL       |
  * |           | BINV       |
  * |           | CFMT[3:2]  |
  * |           | DBIT[1:0]  |
  */
/*--------------------------------------------------*/
void REG_CRCTYP_set(TSB_CRC_TypeDef *p_reg, crc_crctyp_t param)
{
    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
#ifdef DEBUG
    /* Check the REG_CRC_NULL of address. */
    assert_param(IS_POINTER_NOT_NULL(p_reg));
#endif /* #ifdef DEBUG */
    /*--- [CRCDIN]<CRCDIN> ---*/
    /*------------------------------*/
    /*  Register Set                */
    /*------------------------------*/
    p_reg->TYP = (param.rrfl | param.drfl | param.binv | param.cfmt | param.dbit);
}
/*--------------------------------------------------*/
/**
  * @brief  Set Default value CRC Calculation Result Register.
  * @param  p_reg   :Register Base Address.
  * @param  val     :Default Value
  * @return -
  * @retval -
  * @note   The used register.
  * | Register  | Bit Symbol |
  * | :---      | :---       |
  * | CRCCLC    | CRCCLC     |
  */
/*--------------------------------------------------*/
void REG_CRCCLC_set(TSB_CRC_TypeDef *p_reg, uint32_t val)
{
    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
#ifdef DEBUG
    /* Check the REG_CRC_NULL of address. */
    assert_param(IS_POINTER_NOT_NULL(p_reg));
#endif /* #ifdef DEBUG */
    /*--- [NFCKCR]<NFCKS> ---*/
    /*------------------------------*/
    /*  Register Set                */
    /*------------------------------*/
    p_reg->CLC = val;
}

/*--------------------------------------------------*/
/**
  * @brief  Get value CRC Calculation Result.
  * @param  p_reg   :Register Base Address.
  * @return CRCCLC.
  * @retval value   :Calculation Result Value.
  * @note   The used register.
  * | Register  | Bit Symbol |
  * | :---      | :---       |
  * | CRCCLC    | CRCRST     |
  */
/*--------------------------------------------------*/
uint32_t REG_CRCCLC_get(TSB_CRC_TypeDef *p_reg)
{
    uint32_t value = 0U;
    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
#ifdef DEBUG
    /* Check the REG_CRC_NULL of address. */
    assert_param(IS_POINTER_NOT_NULL(p_reg));
#endif /* #ifdef DEBUG */
    /*--- [NFCKCR]<NFCKS> ---*/
    /*------------------------------*/
    /*  Register Value Get          */
    /*------------------------------*/
    value = p_reg->CLC;
    return (value);
}
/**
 *  @}
 */ /* End of group CRC_Exported_functions */

/**
 *  @}
 */ /* End of group CRC */

/**
 *  @} 
 */ /* End of group Periph_Driver */

#endif /* defined(__CRC_A_H)  */
#ifdef __cplusplus
}
#endif /* __cplusplus */


