/** 
 *******************************************************************************
 * @file    crc_a.h
 * @brief   This file provides all the functions prototypes for A-CRC.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */
/*------------------------------------------------------------------------------*/
/*  Define to prevent recursive inclusion                                       */
/*------------------------------------------------------------------------------*/
#ifndef __CRC_A_H
#define __CRC_A_H

#ifdef __cplusplus
extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "bsp_com.h"

/**
 *  @addtogroup Periph_Driver Peripheral Driver
 *  @{
 */

/** 
 *  @addtogroup CRC
 *  @brief      CRC Driver
 *  @{
 */
/*------------------------------------------------------------------------------*/
/*  Macro Function                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup CRC_Exported_macro
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group CRC_Exported_macro */


/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup CRC_Exported_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group CRC_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup CRC_Exported_define
 *  @{
 */

/** ---------------------------------------
 *  @defgroup CRCTYP CRCTYP
 *  @brief    CRC Data Width Register.
 *  @{
 */

/** 
 *  @defgroup CRCTYP_RRFL RRFL
 *  @brief    [Bit6]: CRC Result Mirror Image Inversion Select.
 *  @{
 */
#define REG_CRC_RRFL_INVERSION_ON           ((uint32_t)0x00000040)        /*!< CRC Result Mirror Image Inversion.          */
#define REG_CRC_RRFL_INVERSION_OFF          ((uint32_t)0x00000000)        /*!< CRC Result Mirror Image Not Inversion.      */
/**
 *  @}
 */ /* End of group CRCTYP_RRFL */
/** 
 *  @defgroup CRCTYP_DRFL DRFL
 *  @brief    [Bit5]: CRC Input Data Mirror Image Inversion Select.
 *  @{
 */
#define REG_CRC_DRFL_INVERSION_ON           ((uint32_t)0x00000020)        /*!< CRC Input Data Mirror Image Inversion.      */
#define REG_CRC_DRFL_INVERSION_OFF          ((uint32_t)0x00000000)        /*!< CRC Input Data Mirror Image Not Inversion.  */
/**
 *  @}
 */ /* End of group CRCTYP_DRFL */
/** 
 *  @defgroup CRCTYP_BINV BINV
 *  @brief    [Bit4]: Bit Inversion Output Select.
 *  @{
 */
#define REG_CRC_BINV_INVERSION_ON           ((uint32_t)0x00000010)        /*!< Bit Inversion Output.                       */
#define REG_CRC_BINV_INVERSION_OFF          ((uint32_t)0x00000000)        /*!< Bit Not Inversion Output.                   */
/**
 *  @}
 */ /* End of group CRCTYP_BINV */
/** 
 *  @defgroup CRCTYP_CFMT CFMT
 *  @brief    [Bit3:2]: CRC Format Select.
 *  @{
 */
#define REG_CRC_CFMT_CRC16                  ((uint32_t)0x00000000)        /*!< CRC16 Format.                                */
#define REG_CRC_CFMT_CRC32                  ((uint32_t)0x0000000C)        /*!< CRC32 Fromat.                                */
/**
 *  @}
 */ /* End of group CRCTYP_CFMT */
/** 
 *  @defgroup CRCTYP_DBIT DBIT
 *  @brief    [Bit1:0]: CRC Format Select.
 *  @{
 */
#define REG_CRC_DBIT_32bit                  ((uint32_t)0x00000000)        /*!< Input data 32bit.                            */
#define REG_CRC_DBIT_8bit                   ((uint32_t)0x00000001)        /*!< Input data 8bit.                             */
#define REG_CRC_DBIT_16bit                  ((uint32_t)0x00000002)        /*!< Input data 16bit.                            */
/**
 *  @}
 */ /* End of group CRCTYP_DBIT */


/**
 *  @}
 */ /* End of group CRCTYP */

/** ---------------------------------------
 *  @defgroup CRCCLC CRCCLC
 *  @brief    CRC Calculation Result Register.
 *  @{
 */
 /** 
 *  @defgroup CRCCLC_CRCCLC CRCCLC
 *  @brief    [Bit31:0]: CRC Calculation Result Store.
 *  @{
 */
#define REG_CRCCLC_DEFAULT_VAL_16           ((uint32_t)0x0000FFFF)        /*!< Default Value for 16bit.                     */
#define REG_CRCCLC_DEFAULT_VAL_32           ((uint32_t)0xFFFFFFFF)        /*!< Default Value for 32bit.                     */
/**
 *  @}
 */ /* End of group CRCCLC_CRCCLC */
 
 /**
 *  @}
 */ /* End of group CRCCLC */

 
/** 
 *  @}
 */ /* End of group CRC_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup CRC_Exported_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group CRC_Exported_define */

/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup CRC_Exported_typedef
 *  @{
 */
/*----------------------------------*/
/** 
 * @struct crc_crctyp_t
 * @brief  CRC Data Width Register structure definenition.
*/
/*----------------------------------*/
typedef struct
{
    uint32_t  rrfl;        /*!< @ref CRCTYP_RRFL  */
    uint32_t  drfl;        /*!< @ref CRCTYP_DRFL  */
    uint32_t  binv;        /*!< @ref CRCTYP_BINV  */
    uint32_t  cfmt;        /*!< @ref CRCTYP_CFMT  */
    uint32_t  dbit;        /*!< @ref CRCTYP_DBIT  */
} crc_crctyp_t;

/**
 *  @}
 */ /* End of group CRC_Exported_typedef */


/*------------------------------------------------------------------------------*/
/*  Functions                                                                   */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup CRC_Exported_functions
 *  @{
 */
void REG_CRCDIN_set(TSB_CRC_TypeDef *p_reg, uint32_t data);
void REG_CRCTYP_set(TSB_CRC_TypeDef *p_reg, crc_crctyp_t param);
void REG_CRCCLC_set(TSB_CRC_TypeDef *p_reg, uint32_t val);
uint32_t REG_CRCCLC_get(TSB_CRC_TypeDef *p_reg);

/** 
 *  @}
 */ /* End of group CRC_Exported_functions */

/**
 *  @}
 */ /* End of group CRC */

/**
 *  @} 
 */ /* End of group Periph_Driver */

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __CRC_A_H */


