/**
 *******************************************************************************
 * @file    dac_b.c
 * @brief   This file provides API functions for DAC.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */

#ifdef __cplusplus
 extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "dac.h"

#if defined(__DAC_H)
/**
 *  @addtogroup Periph_Driver Peripheral Driver
 *  @{
 */

/** 
 *  @defgroup DAC DAC
 *  @brief    DAC Driver.
 *  @{
 */
/*------------------------------------------------------------------------------*/
/*  Macro Function                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DAC_Private_macro
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group DAC_Private_macro */


/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DAC_Private_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group DAC_Private_define */

/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DAC_Private_define
 *  @{
 */

/** 
 *  @defgroup Null Null Pointer
 *  @brief    Null Pointer.
 *  @{
 */
#define REG_DAC_NULL                  ((void *)0)
/**
 *  @}
 */ /* End of group Null */

/** 
 *  @}
 */ /* End of group DAC_Private_define */


/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DAC_Private_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group DAC_Private_define */


/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DAC_Private_typedef
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group DAC_Private_typedef */

/*------------------------------------------------------------------------------*/
/*  Private Member                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DAC_Private_variables
 *  @{
 */

/* no define */

/**
 *  @}
 */ /* End of group DAC_Private_variables */


/*------------------------------------------------------------------------------*/
/*  Private Function                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DAC_Private_fuctions
 *  @{
 */

/**
 *  @}
 */ /* End of group DAC_Private_fuctions */


/*------------------------------------------------------------------------------*/
/*  Public Function                                                             */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DAC_Exported_functions
 *  @{
 */
/*--------------------------------------------------*/
/**
  * @brief  Set Value DAxREG.
  * @param  p_reg   :Register Base Address.
  * @param  val     :Setting Value
  * @return -
  * @retval -
  * @note   The used register.
  * | Register  | Bit Symbol |
  * | :---      | :---       |
  * | DAxREG    | DAC[7:0]   |
  */
/*--------------------------------------------------*/
TXZ_Result REG_DAC_DAxREG_set(TSB_DA_TypeDef *p_reg, uint32_t val)
{
    TXZ_Result result = TXZ_SUCCESS;
    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
    if(p_reg == REG_DAC_NULL)
    {
        result = TXZ_ERROR;
        return (result);
    }
    if(val > 0xFF )
    {
        result = TXZ_ERROR;
        return (result);
    }
    /*--- [DAxREG]<DAC> ---*/
    /*------------------------------*/
    /*  Register Set                */
    /*------------------------------*/
    p_reg->REG = val;
    
    return (result);
}

/*--------------------------------------------------*/
/**
  * @brief  Set DAC Control Enable.
  * @param  p_reg   :Register Base Address.
  * @return -
  * @retval -
  * @note   The used register.
  * | Register   | Bit Symbol    |
  * | :---       | :---          |
  * | DAxCR      | [Bit0]: DAC   |
  */
/*--------------------------------------------------*/
TXZ_Result REG_DAC_enable(TSB_DA_TypeDef *p_reg)
{
    TXZ_Result result = TXZ_SUCCESS;
    
    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
    if(p_reg == REG_DAC_NULL)
    {
        result = TXZ_ERROR;
        return (result);
    }
    
    /*------------------------------*/
    /*  Register Set                */
    /*------------------------------*/
    /*--- [ENxINTCR] ---*/
    p_reg->CTL = REG_DAC_DAxCR_REN_ENABLE;
    
    return (result);
}

/*--------------------------------------------------*/
/**
  * @brief  Set DAC Control Disable.
  * @param  p_reg   :Register Base Address.
  * @return -
  * @retval -
  * @note   The used register.
  * | Register   | Bit Symbol    |
  * | :---       | :---          |
  * | DAxCR      | [Bit0]: DAC   |
  */
/*--------------------------------------------------*/
TXZ_Result REG_DAC_disable(TSB_DA_TypeDef *p_reg)
{
    TXZ_Result result = TXZ_SUCCESS;
    
    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
    if(p_reg == REG_DAC_NULL)
    {
        result = TXZ_ERROR;
        return (result);
    }
    
    /*------------------------------*/
    /*  Register Set                */
    /*------------------------------*/
    /*--- [ENxINTCR] ---*/
    p_reg->CTL = REG_DAC_DAxCR_REN_DISABLE;
    
    return (result);
}

/**
 *  @}
 */ /* End of group DAC_Exported_functions */

/**
 *  @}
 */ /* End of group DAC */

/**
 *  @} 
 */ /* End of group Periph_Driver */

#endif /* defined(__DAC_H)  */
#ifdef __cplusplus
}
#endif /* __cplusplus */


