/** 
 *******************************************************************************
 * @file    dac_b.h
 * @brief   This file provides all the functions prototypes for DAC.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */
/*------------------------------------------------------------------------------*/
/*  Define to prevent recursive inclusion                                       */
/*------------------------------------------------------------------------------*/
#ifndef __DAC_H
#define __DAC_H

#ifdef __cplusplus
extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "driver_com.h"

/**
 *  @addtogroup Periph_Driver Peripheral Driver
 *  @{
 */

/** 
 *  @defgroup DAC DAC
 *  @brief    DAC Driver.
 *  @{
 */
/*------------------------------------------------------------------------------*/
/*  Macro Function                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DAC_Exported_macro
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group DAC_Exported_macro */


/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DAC_Exported_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group DAC_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DAC_Exported_define
 *  @{
 */

/** ---------------------------------------
 *  @defgroup DAxCR DAxCR
 *  @brief    DAC Control Register.
 *  @{
 */

/** 
 *  @defgroup DAxCR_EN EN
 *  @brief    [Bit0]: DAC Enable/Disable.
 *  @{
 */
#define REG_DAC_DAxCR_REN_DISABLE           ((uint32_t)0x00000000)        /*!< DAC Control Disable.     */
#define REG_DAC_DAxCR_REN_ENABLE            ((uint32_t)0x00000001)        /*!< DAC Control Enable.      */

/**
 *  @}
 */ /* End of group DAxCR_EN */

/**
 *  @}
 */ /* End of group DAxCR */


/** ---------------------------------------
 *  @defgroup DAxREG
 *  @brief    DAC Convert value setting Register.
 *  @{
 */

/** 
 *  @defgroup DAxREG_DAC DAC
 *  @brief    [Bit7-0]: DAC Convert value.
 *  @{
 */
#define DAxREG_DAC_MASK                     ((uint32_t)0x000000FF)        /*!< for Bit Mask.  */
/**
 *  @}
 */ /* End of group DAxREG_DAC */
/**
 *  @}
 */ /* End of group DAxREG */

/** 
 *  @}
 */ /* End of group DAC_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DAC_Exported_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group DAC_Exported_define */

/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DAC_Exported_typedef
 *  @{
 */


/**
 *  @}
 */ /* End of group DAC_Exported_typedef */


/*------------------------------------------------------------------------------*/
/*  Functions                                                                   */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DAC_Exported_functions
 *  @{
 */
/* DAxCR */
TXZ_Result REG_DAC_enable(TSB_DA_TypeDef *p_reg);
TXZ_Result REG_DAC_disable(TSB_DA_TypeDef *p_reg);
/* DAxREG */
TXZ_Result REG_DAC_DAxREG_set(TSB_DA_TypeDef *p_reg, uint32_t val);
/** 
 *  @}
 */ /* End of group DAC_Exported_functions */

/**
 *  @}
 */ /* End of group DAC */

/**
 *  @} 
 */ /* End of group Periph_Driver */

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __DAC_H */


