/**
 *******************************************************************************
 * @file    dlcd_a.c
 * @brief   This file provides API functions for DLCD Class.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */

#ifdef __cplusplus
 extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "dlcd.h"

#if defined(__DLCD_H)

/**
 *  @addtogroup Periph_Driver Peripheral Driver
 *  @{
 */

/** 
 *  @defgroup DLCD DLCD
 *  @brief    DLCD Driver.
 *  @{
 */
/*------------------------------------------------------------------------------*/
/*  Macro Function                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DLCD_Private_macro
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group DLCD_Private_macro */

/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DLCD_Private_define 
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group DLCD_Private_define */

/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DLCD_Private_define 
 *  @{
 */
#define DLCDCR2_CLKSEL_MASK             ((uint8_t)0x04)     /*!< CLKSEL mask                */
#define DLCDBUF_CLEAR                   ((uint8_t)0x00)     /*!< SEG clear                  */
/** 
 *  @}
 */ /* End of group DLCD_Private_define */

/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DLCD_Private_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group DLCD_Private_define */

/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DLCD_Private_typedef
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group DLCD_Private_typedef */

/*------------------------------------------------------------------------------*/
/*  Private Member                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DLCD_Private_variables
 *  @{
 */

/* no define */

/**
 *  @}
 */ /* End of group DLCD_Private_variables */

/*------------------------------------------------------------------------------*/
/*  Const Table                                                                 */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DLCD_Private_const
 *  @{
 */

/**
 *  @}
 */ /* End of group DLCD_Private_const */

/*------------------------------------------------------------------------------*/
/*  Private Function                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DLCD_Private_functions
 *  @{
 */
 
/* no define */

/**
 *  @}
 */ /* End of group DLCD_Private_functions */

/*------------------------------------------------------------------------------*/
/*  Public Function                                                             */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DLCD_Exported_functions
 *  @{
 */
/*--------------------------------------------------*/
/**
  * @brief     setting      DLCD Register
  * @param     p_obj       :DLCD object.
  * @param     buf         :set register
  * @param     data        :set data
  * @retval    TXZ_SUCCESS :Success.
  * @retval    TXZ_ERROR   :Failure.
  * @note      -
  */
/*--------------------------------------------------*/
TXZ_Result DLCD_reg_set(dlcd_t *p_obj, uint32_t buf, uint8_t data)
{
    TXZ_Result result = TXZ_SUCCESS;

    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
#ifdef DEBUG
    assert_param(IS_POINTER_NOT_NULL(p_obj));
#endif /* #ifdef DEBUG */

#if !defined(TMPM3HMA) && !defined(TMPM3HNA)
    if(buf == DLCD_BUF00)
    {
        p_obj->p_instance1->BUF00 = data;
    }
    else if(buf == DLCD_BUF01){
        p_obj->p_instance1->BUF01 = data;
    }
    else if(buf == DLCD_BUF02){
        p_obj->p_instance1->BUF02 = data;
    }
    else if(buf == DLCD_BUF03){
        p_obj->p_instance1->BUF03 = data;
    }
#else
#if !defined(TMPM3HMA)
    if(buf == DLCD_BUF04){
        p_obj->p_instance1->BUF04 = data;
    }
#else
    if(buf == DLCD_BUF05){
        p_obj->p_instance1->BUF05 = data;
    }
#endif
#endif
#if !defined(TMPM3HMA)
    else if(buf == DLCD_BUF04){
        p_obj->p_instance1->BUF04 = data;
    }
#endif
    else if(buf == DLCD_BUF05){
        p_obj->p_instance1->BUF05 = data;
    }
    else if(buf == DLCD_BUF06){
        p_obj->p_instance1->BUF06 = data;
    }
    else if(buf == DLCD_BUF07){
        p_obj->p_instance1->BUF07 = data;
    }
    else if(buf == DLCD_BUF08){
        p_obj->p_instance1->BUF08 = data;
    }
    else if(buf == DLCD_BUF09){
        p_obj->p_instance1->BUF09 = data;
    }
    else if(buf == DLCD_BUF10){
        p_obj->p_instance1->BUF10 = data;
    }
    else if(buf == DLCD_BUF11){
        p_obj->p_instance1->BUF11 = data;
    }
    else if(buf == DLCD_BUF12){
        p_obj->p_instance1->BUF12 = data;
    }
    else if(buf == DLCD_BUF13){
        p_obj->p_instance1->BUF13 = data;
    }
    else if(buf == DLCD_BUF14){
        p_obj->p_instance1->BUF14 = data;
    }
    else if(buf == DLCD_BUF15){
        p_obj->p_instance1->BUF15 = data;
    }
    else if(buf == DLCD_BUF16){
        p_obj->p_instance1->BUF16 = data;
    }
    else if(buf == DLCD_BUF17){
        p_obj->p_instance1->BUF17 = data;
    }
    else if(buf == DLCD_BUF18){
        p_obj->p_instance1->BUF18 = data;
    }
    else if(buf == DLCD_BUF19){
        p_obj->p_instance1->BUF19 = data;
    }
    else if(buf == DLCD_BUF20){
        p_obj->p_instance1->BUF20 = data;
    }
    else if(buf == DLCD_BUF21){
        p_obj->p_instance1->BUF21 = data;
    }
    else if(buf == DLCD_BUF22){
        p_obj->p_instance1->BUF22 = data;
    }
    else if(buf == DLCD_BUF23){
        p_obj->p_instance1->BUF23 = data;
    }
    else if(buf == DLCD_BUF24){
        p_obj->p_instance1->BUF24 = data;
    }
    else if(buf == DLCD_BUF25){
        p_obj->p_instance1->BUF25 = data;
    }
    else if(buf == DLCD_BUF26){
        p_obj->p_instance1->BUF26 = data;
    }
    else if(buf == DLCD_BUF27){
        p_obj->p_instance1->BUF27 = data;
    }
#if !defined(TMPM3HMA)
    else if(buf == DLCD_BUF28){
        p_obj->p_instance1->BUF28 = data;
    }
#if !defined(TMPM3HNA)
    else if(buf == DLCD_BUF29){
        p_obj->p_instance1->BUF29 = data;
    }
    else if(buf == DLCD_BUF30){
        p_obj->p_instance1->BUF30 = data;
    }
    else if(buf == DLCD_BUF31){
        p_obj->p_instance1->BUF31 = data;
    }
    else if(buf == DLCD_BUF32){
        p_obj->p_instance1->BUF32 = data;
    }
#endif
    else if(buf == DLCD_BUF33){
        p_obj->p_instance1->BUF33 = data;
    }
    else if(buf == DLCD_BUF34){
        p_obj->p_instance1->BUF34 = data;
    }
    else if(buf == DLCD_BUF35){
        p_obj->p_instance1->BUF35 = data;
    }
    else if(buf == DLCD_BUF36){
        p_obj->p_instance1->BUF36 = data;
    }
#endif
    else if(buf == DLCD_BUF37){
        p_obj->p_instance1->BUF37 = data;
    }
    else if(buf == DLCD_BUF38){
        p_obj->p_instance1->BUF38 = data;
    }
    else if(buf == DLCD_BUF39){
        p_obj->p_instance1->BUF39 = data;
    }
    else{
        /* Do nothing */
    }
    return (result);
}

/*--------------------------------------------------*/
/**
  * @brief     setting      DLCD Register
  * @param     p_obj       :DLCD object.
  * @param     buf         :get register
  * @retval    DLCD Register value
  * @note      -
  */
/*--------------------------------------------------*/
uint8_t DLCD_reg_get(dlcd_t *p_obj, uint32_t buf)
{
    uint8_t result = 0;

    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
#ifdef DEBUG
    assert_param(IS_POINTER_NOT_NULL(p_obj));
#endif /* #ifdef DEBUG */

#if !defined(TMPM3HMA) && !defined(TMPM3HNA)
    if(buf == DLCD_BUF00)
    {
        result = p_obj->p_instance1->BUF00;
    }
    else if(buf == DLCD_BUF01){
        result = p_obj->p_instance1->BUF01;
    }
    else if(buf == DLCD_BUF02){
        result = p_obj->p_instance1->BUF02;
    }
    else if(buf == DLCD_BUF03){
        result = p_obj->p_instance1->BUF03;
    }
#else
#if !defined(TMPM3HMA)
    if(buf == DLCD_BUF04){
        result = p_obj->p_instance1->BUF04;
    }
#else
    if(buf == DLCD_BUF05){
        result = p_obj->p_instance1->BUF05;
    }
#endif
#endif
#if !defined(TMPM3HMA)
    else if(buf == DLCD_BUF04){
        result = p_obj->p_instance1->BUF04;
    }
#endif
    else if(buf == DLCD_BUF05){
        result = p_obj->p_instance1->BUF05;
    }
    else if(buf == DLCD_BUF06){
        result = p_obj->p_instance1->BUF06;
    }
    else if(buf == DLCD_BUF07){
        result = p_obj->p_instance1->BUF07;
    }
    else if(buf == DLCD_BUF08){
        result = p_obj->p_instance1->BUF08;
    }
    else if(buf == DLCD_BUF09){
        result = p_obj->p_instance1->BUF09;
    }
    else if(buf == DLCD_BUF10){
        result = p_obj->p_instance1->BUF10;
    }
    else if(buf == DLCD_BUF11){
        result = p_obj->p_instance1->BUF11;
    }
    else if(buf == DLCD_BUF12){
        result = p_obj->p_instance1->BUF12;
    }
    else if(buf == DLCD_BUF13){
        result = p_obj->p_instance1->BUF13;
    }
    else if(buf == DLCD_BUF14){
        result = p_obj->p_instance1->BUF14;
    }
    else if(buf == DLCD_BUF15){
        result = p_obj->p_instance1->BUF15;
    }
    else if(buf == DLCD_BUF16){
        result = p_obj->p_instance1->BUF16;
    }
    else if(buf == DLCD_BUF17){
        result = p_obj->p_instance1->BUF17;
    }
    else if(buf == DLCD_BUF18){
        result = p_obj->p_instance1->BUF18;
    }
    else if(buf == DLCD_BUF19){
        result = p_obj->p_instance1->BUF19;
    }
    else if(buf == DLCD_BUF20){
        result = p_obj->p_instance1->BUF20;
    }
    else if(buf == DLCD_BUF21){
        result = p_obj->p_instance1->BUF21;
    }
    else if(buf == DLCD_BUF22){
        result = p_obj->p_instance1->BUF22;
    }
    else if(buf == DLCD_BUF23){
        result = p_obj->p_instance1->BUF23;
    }
    else if(buf == DLCD_BUF24){
        result = p_obj->p_instance1->BUF24;
    }
    else if(buf == DLCD_BUF25){
        result = p_obj->p_instance1->BUF25;
    }
    else if(buf == DLCD_BUF26){
        result = p_obj->p_instance1->BUF26;
    }
    else if(buf == DLCD_BUF27){
        result = p_obj->p_instance1->BUF27;
    }
#if !defined(TMPM3HMA)
    else if(buf == DLCD_BUF28){
        result = p_obj->p_instance1->BUF28;
    }
#if !defined(TMPM3HNA)
    else if(buf == DLCD_BUF29){
        result = p_obj->p_instance1->BUF29;
    }
    else if(buf == DLCD_BUF30){
        result = p_obj->p_instance1->BUF30;
    }
    else if(buf == DLCD_BUF31){
        result = p_obj->p_instance1->BUF31;
    }
    else if(buf == DLCD_BUF32){
        result = p_obj->p_instance1->BUF32;
    }
#endif
    else if(buf == DLCD_BUF33){
        result = p_obj->p_instance1->BUF33;
    }
    else if(buf == DLCD_BUF34){
        result = p_obj->p_instance1->BUF34;
    }
    else if(buf == DLCD_BUF35){
        result = p_obj->p_instance1->BUF35;
    }
    else if(buf == DLCD_BUF36){
        result = p_obj->p_instance1->BUF36;
    }
#endif
    else if(buf == DLCD_BUF37){
        result = p_obj->p_instance1->BUF37;
    }
    else if(buf == DLCD_BUF38){
        result = p_obj->p_instance1->BUF38;
    }
    else if(buf == DLCD_BUF39){
        result = p_obj->p_instance1->BUF39;
    }
    else{
        /* Do nothing */
    }
    return (result);
}

/*--------------------------------------------------*/
/**
  * @brief     setting      DLCD Buffer All Clear
  * @param     p_obj       :DLCD object.
  * @retval    -
  * @note      -
  */
/*--------------------------------------------------*/
void DLCD_Buffer_ALL_Clear(dlcd_t *p_obj)
{
    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
#ifdef DEBUG
    assert_param(IS_POINTER_NOT_NULL(p_obj));
    assert_param(IS_POINTER_NOT_NULL(p_obj->p_instance1));
#endif /* #ifdef DEBUG */

#if !defined(TMPM3HMA) && !defined(TMPM3HNA)
    p_obj->p_instance1->BUF00 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF01 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF02 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF03 = DLCDBUF_CLEAR;
#endif
#if !defined(TMPM3HMA)
    p_obj->p_instance1->BUF04 = DLCDBUF_CLEAR;
#endif
    p_obj->p_instance1->BUF05 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF06 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF07 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF08 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF09 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF10 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF11 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF12 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF13 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF14 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF15 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF16 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF17 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF18 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF19 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF20 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF21 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF22 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF23 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF24 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF25 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF26 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF27 = DLCDBUF_CLEAR;
#if !defined(TMPM3HMA)
    p_obj->p_instance1->BUF28 = DLCDBUF_CLEAR;
#if !defined(TMPM3HNA)
    p_obj->p_instance1->BUF29 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF30 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF31 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF32 = DLCDBUF_CLEAR;
#endif
    p_obj->p_instance1->BUF33 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF34 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF35 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF36 = DLCDBUF_CLEAR;
#endif
    p_obj->p_instance1->BUF37 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF38 = DLCDBUF_CLEAR;
    p_obj->p_instance1->BUF39 = DLCDBUF_CLEAR;
}
/*--------------------------------------------------*/
/**
  * @brief     setting      DLCD Display Start
  * @param     p_obj       :DLCD object.
  * @param     p_disp      :DLCD data.
  * @retval    -
  * @note      -
  */
/*--------------------------------------------------*/
void DLCD_Display_Start(dlcd_t *p_obj, dlcd_dip_t p_disp)
{
    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
#ifdef DEBUG
    assert_param(IS_POINTER_NOT_NULL(p_obj));
    assert_param(IS_POINTER_NOT_NULL(p_obj->p_instance1));
#endif /* #ifdef DEBUG */
    p_obj->p_instance1->CR2 = (p_disp.DLCDCR2_data & DLCDCR2_CLKSEL_MASK);
    p_obj->p_instance1->CR2 = p_disp.DLCDCR2_data;
    p_obj->p_instance1->CR4 = p_disp.DLCDCR4_data;
    p_obj->p_instance1->EN = DLCDEN_LCDE_ENABLE;
    p_obj->p_instance1->STCLKCYC = p_disp.DLSTCLKCYC_data;
    p_obj->p_instance1->CONTCYC = p_disp.DLCONTCYC_data;

    DLCD_Buffer_ALL_Clear(p_obj);

    p_obj->p_instance1->CR1 = p_disp.DLCDCR1_data;
}

/*--------------------------------------------------*/
/**
  * @brief     setting      DLCD Hidden
  * @param     p_obj       :DLCD object.
  * @retval    -
  * @note      -
  */
/*--------------------------------------------------*/
void DLCD_Hidden(dlcd_t *p_obj)
{
    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
#ifdef DEBUG
    assert_param(IS_POINTER_NOT_NULL(p_obj));
    assert_param(IS_POINTER_NOT_NULL(p_obj->p_instance1));
#endif /* #ifdef DEBUG */

    p_obj->p_instance1->CR1 = DLCDCR1_EDSP_ENABLE_10;
}

/*--------------------------------------------------*/
/**
  * @brief     setting      DLCD Stop
  * @param     p_obj       :DLCD object.
  * @retval    -
  * @note      -
  */
/*--------------------------------------------------*/
void DLCD_Stop(dlcd_t *p_obj)
{
    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
#ifdef DEBUG
    assert_param(IS_POINTER_NOT_NULL(p_obj));
    assert_param(IS_POINTER_NOT_NULL(p_obj->p_instance1));
#endif /* #ifdef DEBUG */

    p_obj->p_instance1->CR1 = DLCDCR1_LCDF_STOP;
    while(p_obj->p_instance1->CR1 & DLCDCR1_LCDF_RUNNING){
    }
    p_obj->p_instance1->EN = DLCDEN_LCDE_DISABLE;

}
/*--------------------------------------------------*/
/**
  * @brief     setting      DLCD Display Change
  * @param     p_obj       :DLCD object.
  * @param     p_disp      :DLCD data.
  * @retval    -
  * @note      -
  */
/*--------------------------------------------------*/
void DLCD_Display_Change(dlcd_t *p_obj, dlcd_dip_t p_disp)
{
    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
#ifdef DEBUG
    assert_param(IS_POINTER_NOT_NULL(p_obj));
    assert_param(IS_POINTER_NOT_NULL(p_obj->p_instance1));
#endif /* #ifdef DEBUG */

    while(p_obj->p_instance1->REGBSY){
    }

    p_obj->p_instance1->STCLKCYC = p_disp.DLSTCLKCYC_data;
    p_obj->p_instance1->CONTCYC = p_disp.DLCONTCYC_data;
    p_obj->p_instance1->CR3 = p_disp.DLCDCR3_data;
}

/*--------------------------------------------------*/
/**
  * @brief     setting      DLCD Output Change
  * @param     p_obj       :DLCD object.
  * @param     p_disp      :DLCD data.
  * @retval    -
  * @note      -
  */
/*--------------------------------------------------*/
void DLCD_Output_Change(dlcd_t *p_obj, dlcd_dip_t p_disp)
{
    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
#ifdef DEBUG
    assert_param(IS_POINTER_NOT_NULL(p_obj));
    assert_param(IS_POINTER_NOT_NULL(p_obj->p_instance2));
#endif /* #ifdef DEBUG */

    p_obj->p_instance2->REG0 = p_disp.AGPREG0_data;
}

/*--------------------------------------------------*/
/**
  * @brief     setting      DLCD Terminal Change
  * @param     p_obj       :DLCD object.
  * @param     p_disp      :DLCD data.
  * @retval    -
  * @note      -
  */
/*--------------------------------------------------*/
void DLCD_Terminal_Change(dlcd_t *p_obj, dlcd_dip_t p_disp)
{
    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
#ifdef DEBUG
    assert_param(IS_POINTER_NOT_NULL(p_obj));
    assert_param(IS_POINTER_NOT_NULL(p_obj->p_instance2));
#endif /* #ifdef DEBUG */

    p_obj->p_instance2->REG1 = p_disp.AGPREG1_data;
}
/**
 *  @}
 */ /* End of group DLCD_Exported_functions */

/**
 *  @} 
 */ /* End of group DLCD */

/**
 *  @} 
 */ /* End of group Periph_Driver */

#endif /* defined(__DLCD_H)  */

#ifdef __cplusplus
}
#endif /* __cplusplus */

