/** 
 *******************************************************************************
 * @file    dlcd_a.h
 * @brief   This file provides all the functions prototypes for DLCD Class.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */
/*------------------------------------------------------------------------------*/
/*  Define to prevent recursive inclusion                                       */
/*------------------------------------------------------------------------------*/
#ifndef __DLCD_H
#define __DLCD_H

#ifdef __cplusplus
extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "driver_com.h"

/**
 *  @addtogroup Periph_Driver Peripheral Driver
 *  @{
 */

/** 
 *  @addtogroup DLCD
 *  @{
 */
/*------------------------------------------------------------------------------*/
/*  Macro Function                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DLCD_Private_macro
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group DLCD_Private_macro */


/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DLCD_Private_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group DLCD_Private_define */


/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DLCD_Private_define
 *  @{
 */

#ifdef DEBUG
/** 
 *  @name  DLCD_NULL Pointer
 *  @brief NULL Pointer.
 *  @{
 */
#define DLCD_NULL                ((void *)0)
/**
 *  @}
 */ /* End of name DLCD_NULL Pointer */
#endif

/** 
 *  @name  DLCDEN Macro Definition.
 *  @brief DLCDEN Register Macro Definition.
 *  @{
 */
#define DLCDEN_LCDE_ENABLE      ((uint8_t)0x01)     /*!< LCDE=Enable                */
#define DLCDEN_LCDE_DISABLE     ((uint8_t)0x00)     /*!< LCDE=Disable                */
/**
 *  @}
 */ /* End of name DLCDEN Macro Definition */

/** 
 *  @name  DLCDCR1 Macro Definition.
 *  @brief DLCDCR1 Register Macro Definition.
 *  @{
 */
#define DLCDCR1_LCDF_STOP       ((uint8_t)0x00)     /*!< LCDF Stop */
#define DLCDCR1_LCDF_RUNNING    ((uint8_t)0x10)     /*!< LCDF Running */
#define DLCDCR1_EDSP_DISABLE    ((uint8_t)0x00)     /*!< EDSP Disable */
#define DLCDCR1_EDSP_ENABLE_10  ((uint8_t)0x02)     /*!< EDSP Enable  */
#define DLCDCR1_EDSP_ENABLE_11  ((uint8_t)0x03)     /*!< EDSP Enable  */
/**
 *  @}
 */ /* End of name DLCDCR1 Macro Definition */

/** 
 *  @name  DLCDCR2 Macro Definition.
 *  @brief DLCDCR2 Register Macro Definition.
 *  @{
 */
#define DLCDCR2_CONTSEL_FRAME_LENGTH    ((uint8_t)0x00)     /*!< CONTSEL Frame length control method               */
#define DLCDCR2_CONTSEL_TIME_DIVISION   ((uint8_t)0x08)     /*!< CONTSEL Time  division control method             */
#define DLCDCR2_CLKSEL_HOSC2            ((uint8_t)0x00)     /*!< CLKSEL HOSC2           */
#define DLCDCR2_CLKSEL_FS               ((uint8_t)0x04)     /*!< CLKSEL fs                  */
#define DLCDCR2_DUTY_4COM_1_6           ((uint8_t)0x00)     /*!< 4COM 1/6 Duty              */
#define DLCDCR2_DUTY_3COM_1_4           ((uint8_t)0x01)     /*!< 3COM 1/4 Duty              */

/**
 *  @}
 */ /* End of name DLCDCR2 Macro Definition */
 
/** 
 *  @name  DLCDCR3 Macro Definition.
 *  @brief DLCDCR3 Register Macro Definition.
 *  @{
 */
#define DLCDCR3_BFLG_L              ((uint8_t)0x00)     /*!< <SEGmL[3;0]> select  */
#define DLCDCR3_BFLG_H              ((uint8_t)0x80)     /*!< <SEGmH[3:0]> select  */
#define DLCDCR3_INVALID             ((uint8_t)0x00)     /*!< Invalid(initial inner counter)  */
#define DLCDCR3_EXTERNAL_TRIGGER    ((uint8_t)0x04)     /*!< Toggle buffer screen for each external trigger   */
#define DLCDCR3_TOGGLE_2HZ          ((uint8_t)0x08)     /*!< Toggle buffer screen for 2Hz   */
#define DLCDCR3_TOGGLE_4HZ          ((uint8_t)0x0C)     /*!< Toggle buffer screen for 4Hz   */
#define DLCDCR3_BSEL_NONE           ((uint8_t)0x00)     /*!< Buf no change  */
#define DLCDCR3_BSEL_LOW            ((uint8_t)0x01)     /*!< <SEGmL[3;0]> select  */
#define DLCDCR3_BSEL_HIGH           ((uint8_t)0x02)     /*!< <SEGmH[3:0]> select  */
#define DLCDCR3_BSEL_TOGGLE         ((uint8_t)0x03)     /*!< Buf toggle  */
/**
 *  @}
 */ /* End of name DLCDCR3 Macro Definition */
 
/** 
 *  @name  DLCDCR4 Macro Definition.
 *  @brief DLCDCR4 Register Macro Definition.
 *  @{
 */
#define DLCDCR4_RVDPIN_000  ((uint8_t)0x00)     /*!< RVDPIN 000 */
#define DLCDCR4_RVDPIN_001  ((uint8_t)0x01)     /*!< RVDPIN 001 */
#define DLCDCR4_RVDPIN_010  ((uint8_t)0x02)     /*!< RVDPIN 010 */
#define DLCDCR4_RVDPIN_011  ((uint8_t)0x03)     /*!< RVDPIN 011 */
#define DLCDCR4_RVHPIN_100  ((uint8_t)0x04)     /*!< RVDPIN 100 */
#define DLCDCR4_RVHPIN_101  ((uint8_t)0x05)     /*!< RVDPIN 101 */
#define DLCDCR4_RVHPIN_110  ((uint8_t)0x06)     /*!< RVDPIN 110 */
#define DLCDCR4_RVHPIN_111  ((uint8_t)0x07)     /*!< RVDPIN 111 */
/**
 *  @}
 */ /* End of name DLCDCR4 Macro Definition */
 
 /** 
 *  @name  DLREGBSY Macro Definition.
 *  @brief DLREGBSY Register Macro Definition.
 *  @{
 */
#define DLREGBSY_LREF_FREE      ((uint8_t)0x00)     /*!< [DLLERSCYC] Free       */
#define DLREGBSY_LREF_BUSY      ((uint8_t)0x10)     /*!< [DLLERSCYC] Busy       */
#define DLREGBSY_CONF_FREE      ((uint8_t)0x00)     /*!< [DLCONTCYC] Free       */
#define DLREGBSY_CONF_BUSY      ((uint8_t)0x08)     /*!< [DLCONTCYC] Busy       */
#define DLREGBSY_STCF_FREE      ((uint8_t)0x00)     /*!< [DLSTCLKCYC] Free      */
#define DLREGBSY_STCF_BUSY      ((uint8_t)0x04)     /*!< [DLSTCLKCYC] Busy      */
#define DLREGBSY_CR3F_FREE      ((uint8_t)0x00)     /*!< [DLCDCR3] Free         */
#define DLREGBSY_CR3F_BUSY      ((uint8_t)0x02)     /*!< [DLCDCR3] Busy         */
#define DLREGBSY_CR1F_FREE      ((uint8_t)0x00)     /*!< [DLCDCR1] Free         */
#define DLREGBSY_CR1F_BUSY      ((uint8_t)0x01)     /*!< [DLCDCR1] Busy         */
/**
 *  @}
 */ /* End of name DLREGBSY Macro Definition */

 /** 
 *  @name  AGPREG0 Macro Definition.
 *  @brief AGPREG0 Register Macro Definition.
 *  @{
 */
#define DLCD_AGP_HIZ            ((uint8_t)0x00)     /*!< Hi-z           */
#define DLCD_AGP_PULLDOWN       ((uint8_t)0x01)     /*!< Pulldown       */
/**
 *  @}
 */ /* End of name AGPREG0 Macro Definition */

 /** 
 *  @name  AGPREG1 Macro Definition.
 *  @brief AGPREG1 Register Macro Definition.
 *  @{
 */
#define DLCD_AGP_REG_ALL        ((uint8_t)0x7F)     /*!< LCD ALL        */
#define DLCD_AGP_REG_0          ((uint8_t)0x01)     /*!< LCD REG0       */
#define DLCD_AGP_REG_1          ((uint8_t)0x02)     /*!< LCD REG1       */
#define DLCD_AGP_REG_2          ((uint8_t)0x04)     /*!< LCD REG2       */
#define DLCD_AGP_REG_3          ((uint8_t)0x05)     /*!< LCD REG3       */
#define DLCD_AGP_REG_4          ((uint8_t)0x10)     /*!< LCD REG4       */
#define DLCD_AGP_REG_5          ((uint8_t)0x20)     /*!< LCD REG5       */
#define DLCD_AGP_REG_6          ((uint8_t)0x40)     /*!< LCD REG6       */
/**
 *  @}
 */ /* End of name AGPREG1 Macro Definition */

 /** 
 *  @name  BUF Macro Definition.
 *  @brief BUF Register Macro Definition.
 *  @{
 */
#define DLCD_BUF00              ((uint32_t)0)   /*!< LCD BUF00        */
#define DLCD_BUF01              ((uint32_t)1)   /*!< LCD BUF01        */
#define DLCD_BUF02              ((uint32_t)2)   /*!< LCD BUF02        */
#define DLCD_BUF03              ((uint32_t)3)   /*!< LCD BUF03        */
#define DLCD_BUF04              ((uint32_t)4)   /*!< LCD BUF04        */
#define DLCD_BUF05              ((uint32_t)5)   /*!< LCD BUF05        */
#define DLCD_BUF06              ((uint32_t)6)   /*!< LCD BUF06        */
#define DLCD_BUF07              ((uint32_t)7)   /*!< LCD BUF07        */
#define DLCD_BUF08              ((uint32_t)8)   /*!< LCD BUF08        */
#define DLCD_BUF09              ((uint32_t)9)   /*!< LCD BUF09        */
#define DLCD_BUF10              ((uint32_t)10)  /*!< LCD BUF10        */
#define DLCD_BUF11              ((uint32_t)11)  /*!< LCD BUF11        */
#define DLCD_BUF12              ((uint32_t)12)  /*!< LCD BUF12        */
#define DLCD_BUF13              ((uint32_t)13)  /*!< LCD BUF13        */
#define DLCD_BUF14              ((uint32_t)14)  /*!< LCD BUF14        */
#define DLCD_BUF15              ((uint32_t)15)  /*!< LCD BUF15        */
#define DLCD_BUF16              ((uint32_t)16)  /*!< LCD BUF16        */
#define DLCD_BUF17              ((uint32_t)17)  /*!< LCD BUF17        */
#define DLCD_BUF18              ((uint32_t)18)  /*!< LCD BUF18        */
#define DLCD_BUF19              ((uint32_t)19)  /*!< LCD BUF19        */
#define DLCD_BUF20              ((uint32_t)20)  /*!< LCD BUF20        */
#define DLCD_BUF21              ((uint32_t)21)  /*!< LCD BUF21        */
#define DLCD_BUF22              ((uint32_t)22)  /*!< LCD BUF22        */
#define DLCD_BUF23              ((uint32_t)23)  /*!< LCD BUF23        */
#define DLCD_BUF24              ((uint32_t)24)  /*!< LCD BUF24        */
#define DLCD_BUF25              ((uint32_t)25)  /*!< LCD BUF25        */
#define DLCD_BUF26              ((uint32_t)26)  /*!< LCD BUF26        */
#define DLCD_BUF27              ((uint32_t)27)  /*!< LCD BUF27        */
#define DLCD_BUF28              ((uint32_t)28)  /*!< LCD BUF28        */
#define DLCD_BUF29              ((uint32_t)29)  /*!< LCD BUF29        */
#define DLCD_BUF30              ((uint32_t)30)  /*!< LCD BUF30        */
#define DLCD_BUF31              ((uint32_t)31)  /*!< LCD BUF31        */
#define DLCD_BUF32              ((uint32_t)32)  /*!< LCD BUF32        */
#define DLCD_BUF33              ((uint32_t)33)  /*!< LCD BUF33        */
#define DLCD_BUF34              ((uint32_t)34)  /*!< LCD BUF34        */
#define DLCD_BUF35              ((uint32_t)35)  /*!< LCD BUF35        */
#define DLCD_BUF36              ((uint32_t)36)  /*!< LCD BUF36        */
#define DLCD_BUF37              ((uint32_t)37)  /*!< LCD BUF37        */
#define DLCD_BUF38              ((uint32_t)38)  /*!< LCD BUF38        */
#define DLCD_BUF39              ((uint32_t)39)  /*!< LCD BUF39        */

#define DLCD_SEGL_COM0          ((uint8_t)0x01) /*!< LCD SEGL COM0  */
#define DLCD_SEGL_COM1          ((uint8_t)0x02) /*!< LCD SEGL COM1  */
#define DLCD_SEGL_COM2          ((uint8_t)0x04) /*!< LCD SEGL COM2  */
#define DLCD_SEGL_COM3          ((uint8_t)0x08) /*!< LCD SEGL COM3  */
#define DLCD_SEGH_COM0          ((uint8_t)0x10) /*!< LCD SEGH COM0  */
#define DLCD_SEGH_COM1          ((uint8_t)0x20) /*!< LCD SEGH COM1  */
#define DLCD_SEGH_COM2          ((uint8_t)0x40) /*!< LCD SEGH COM2  */
#define DLCD_SEGH_COM3          ((uint8_t)0x80) /*!< LCD SEGH COM3  */
/**
 *  @}
 */ /* End of name BUF Macro Definition */
/** 
 *  @}
 */ /* End of group DLCD_Private_define */


/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DLCD_Private_define
 *  @{
 */

/** 
 *  @}
 */ /* End of group DLCD_Private_define */

/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup DLCD_Exported_typedef
 *  @{
 */

/*----------------------------------*/
/** 
 * @brief  DLCD structure definenition.
*/
/*----------------------------------*/
typedef struct
{
    TSB_DLCD_TypeDef         *p_instance1;    /*!< Registers base address.           */
    TSB_AGP_TypeDef          *p_instance2;    /*!< Registers base address.           */
} dlcd_t;

/*----------------------------------*/
/** 
 * @brief  DLCD data structure definenition.
*/
/*----------------------------------*/
typedef struct
{
    uint8_t     DLCDCR1_data;
    uint8_t     DLCDCR2_data;
    uint8_t     DLCDCR3_data;
    uint8_t     DLCDCR4_data;
    uint8_t     DLSTCLKCYC_data;
    uint8_t     DLCONTCYC_data;
    uint8_t     AGPREG0_data;
    uint8_t     AGPREG1_data;
} dlcd_dip_t;

/**
 *  @}
 */ /* End of group DLCD_Exported_typedef */

/*------------------------------------------------------------------------------*/
/*  Inline Functions                                                             */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DLCD_Private_functions
 *  @{
 */

/**
 *  @}
 */ /* End of group DLCD_Private_functions */

/*------------------------------------------------------------------------------*/
/*  Functions                                                                   */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DLCD_Private_functions
 *  @{
 */
TXZ_Result DLCD_reg_set(dlcd_t *p_obj, uint32_t buf, uint8_t data);
uint8_t DLCD_reg_get(dlcd_t *p_obj, uint32_t buf);
void DLCD_Buffer_ALL_Clear(dlcd_t *p_obj);
void DLCD_Display_Start(dlcd_t *p_obj, dlcd_dip_t p_disp);
void DLCD_Hidden(dlcd_t *p_obj);
void DLCD_Stop(dlcd_t *p_obj);
void DLCD_Display_Change(dlcd_t *p_obj, dlcd_dip_t p_disp);
void DLCD_Output_Change(dlcd_t *p_obj, dlcd_dip_t p_disp);
void DLCD_Terminal_Change(dlcd_t *p_obj, dlcd_dip_t p_disp);
/** 
 *  @}
 */ /* End of group DLCD_Private_functions */

/**
 *  @}
 */ /* End of group DLCD */

/**
 *  @} 
 */ /* End of group Periph_Driver */

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __DLCD_H */


