/** 
 *******************************************************************************
 * @file    dnf_a.h
 * @brief   This file provides all the functions prototypes for A-DNF.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */
/*------------------------------------------------------------------------------*/
/*  Define to prevent recursive inclusion                                       */
/*------------------------------------------------------------------------------*/
#ifndef __DNF_A_H
#define __DNF_A_H

#ifdef __cplusplus
extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "bsp_com.h"

/**
 *  @addtogroup Periph_Driver Peripheral Driver
 *  @{
 */

/** 
 *  @defgroup DNF DNF
 *  @brief    DNF Driver.
 *  @{
 */
/*------------------------------------------------------------------------------*/
/*  Macro Function                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DNF_Exported_macro
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group DNF_Exported_macro */


/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DNF_Exported_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group DNF_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DNF_Exported_define
 *  @{
 */

/** ---------------------------------------
 *  @defgroup NFCKCR NFCKCR
 *  @brief    DNF Noise Filter Register.
 *  @{
 */

/** 
 *  @defgroup NFCKCR_NFCKS NFCKS
 *  @brief    [Bit2-0]: Noise Filter Clock Select.
 *  @{
 */
#define REG_DNF_NFCKCR_NFCKS_STOP           ((uint32_t)0x00000000)        /*!< Clock Control circuit stop.                                       */
#define REG_DNF_NFCKCR_NFCKS_CLOCK_2        ((uint32_t)0x00000001)        /*!< fc/2   fc=20MHz: 0.7us 40MHz: 0.35us 80MHz: 0.175us 100MHz:0.14us */
#define REG_DNF_NFCKCR_NFCKS_CLOCK_4        ((uint32_t)0x00000002)        /*!< fc/4   fc=20MHz: 1.4us 40MHz: 0.7us  80MHz: 0.35us  100MHz:0.28us */
#define REG_DNF_NFCKCR_NFCKS_CLOCK_8        ((uint32_t)0x00000003)        /*!< fc/8   fc=20MHz: 2.8us 40MHz: 1.4us  80MHz: 0.7us   100MHz:0.56us */
#define REG_DNF_NFCKCR_NFCKS_CLOCK_16       ((uint32_t)0x00000004)        /*!< fc/16  fc=20MHz: 5.6us 40MHz: 2.8us  80MHz: 1.4us   100MHz:1.12us */
#define REG_DNF_NFCKCR_NFCKS_CLOCK_32       ((uint32_t)0x00000005)        /*!< fc/32  fc=20MHz:11.2us 40MHz: 5.6us  80MHz: 2.8us   100MHz:2.24us */
#define REG_DNF_NFCKCR_NFCKS_CLOCK_64       ((uint32_t)0x00000006)        /*!< fc/64  fc=20MHz:22.4us 40MHz:11.2us  80MHz: 5.6us   100MHz:4.48us */
#define REG_DNF_NFCKCR_NFCKS_CLOCK_128      ((uint32_t)0x00000007)        /*!< fc/128 fc=20MHz:44.8us 40MHz:22.4us  80MHz:11.2us   100MHz:8.96us */
/**
 *  @}
 */ /* End of group NFCKCR_NFCKS */

/**
 *  @}
 */ /* End of group NFCKCR */


/** ---------------------------------------
 *  @defgroup NFENCR NFENCR
 *  @brief    DNF Noise Filter Enable Register.
 *  @{
 */

/** 
 *  @defgroup NFENCR_NFEN10 NFEN10
 *  @brief    [Bit10]: INT10 Noise Filter Enable.
 *  @{
 */
#define REG_DNF_NFENCR_NFEN10_MASK          ((uint32_t)0x00000400)        /*!< for Bit Mask.  */
#define REG_DNF_NFENCR_NFEN10_DISABLE       ((uint32_t)0x00000000)        /*!< INT10 Noise Filter Disable.  */
#define REG_DNF_NFENCR_NFEN10_ENABLE        ((uint32_t)0x00000400)        /*!< INT10 Noise Filter Enable.   */
/**
 *  @}
 */ /* End of group NFENCR_NFEN10 */

/** 
 *  @defgroup NFENCR_NFEN9 NFEN9
 *  @brief    [Bit9]: INT9 Noise Filter Enable.
 *  @{
 */
#define REG_DNF_NFENCR_NFEN9_MASK           ((uint32_t)0x00000200)        /*!< for Bit Mask.  */
#define REG_DNF_NFENCR_NFEN9_DISABLE        ((uint32_t)0x00000000)        /*!< INT9 Noise Filter Disable.   */
#define REG_DNF_NFENCR_NFEN9_ENABLE         ((uint32_t)0x00000200)        /*!< INT9 Noise Filter Enable.    */
/**
 *  @}
 */ /* End of group NFENCR_NFEN9 */

/** 
 *  @defgroup NFENCR_NFEN8 NFEN8
 *  @brief    [Bit8]: INT8 Noise Filter Enable.
 *  @{
 */
#define REG_DNF_NFENCR_NFEN8_MASK           ((uint32_t)0x00000100)        /*!< for Bit Mask.  */
#define REG_DNF_NFENCR_NFEN8_DISABLE        ((uint32_t)0x00000000)        /*!< INT8 Noise Filter Disable.   */
#define REG_DNF_NFENCR_NFEN8_ENABLE         ((uint32_t)0x00000100)        /*!< INT8 Noise Filter Enable.    */
/**
 *  @}
 */ /* End of group NFENCR_NFEN8 */

/** 
 *  @defgroup NFENCR_NFEN7 NFEN7
 *  @brief    [Bit7]: INT7 Noise Filter Enable.
 *  @{
 */
#define REG_DNF_NFENCR_NFEN7_MASK           ((uint32_t)0x00000080)        /*!< for Bit Mask.  */
#define REG_DNF_NFENCR_NFEN7_DISABLE        ((uint32_t)0x00000000)        /*!< INT7 Noise Filter Disable.   */
#define REG_DNF_NFENCR_NFEN7_ENABLE         ((uint32_t)0x00000080)        /*!< INT7 Noise Filter Enable.    */
/**
 *  @}
 */ /* End of group NFENCR_NFEN7 */

/** 
 *  @defgroup NFENCR_NFEN6 NFEN6
 *  @brief    [Bit6]: INT6 Noise Filter Enable.
 *  @{
 */
#define REG_DNF_NFENCR_NFEN6_MASK           ((uint32_t)0x00000040)        /*!< for Bit Mask.  */
#define REG_DNF_NFENCR_NFEN6_DISABLE        ((uint32_t)0x00000000)        /*!< INT6 Noise Filter Disable.   */
#define REG_DNF_NFENCR_NFEN6_ENABLE         ((uint32_t)0x00000040)        /*!< INT6 Noise Filter Enable.    */
/**
 *  @}
 */ /* End of group NFENCR_NFEN6 */

/** 
 *  @defgroup NFENCR_NFEN5 NFEN5
 *  @brief    [Bit5]: INT5 Noise Filter Enable.
 *  @{
 */
#define REG_DNF_NFENCR_NFEN5_MASK           ((uint32_t)0x00000020)        /*!< for Bit Mask.  */
#define REG_DNF_NFENCR_NFEN5_DISABLE        ((uint32_t)0x00000000)        /*!< INT5 Noise Filter Disable.   */
#define REG_DNF_NFENCR_NFEN5_ENABLE         ((uint32_t)0x00000020)        /*!< INT5 Noise Filter Enable.    */
/**
 *  @}
 */ /* End of group NFENCR_NFEN5 */

/** 
 *  @defgroup NFENCR_NFEN4 NFEN4
 *  @brief    [Bit4]: INT4 Noise Filter Enable.
 *  @{
 */
#define REG_DNF_NFENCR_NFEN4_MASK           ((uint32_t)0x00000010)        /*!< for Bit Mask.  */
#define REG_DNF_NFENCR_NFEN4_DISABLE        ((uint32_t)0x00000000)        /*!< INT4 Noise Filter Disable.   */
#define REG_DNF_NFENCR_NFEN4_ENABLE         ((uint32_t)0x00000010)        /*!< INT4 Noise Filter Enable.    */
/**
 *  @}
 */ /* End of group NFENCR_NFEN4 */

/** 
 *  @defgroup NFENCR_NFEN3 NFEN3
 *  @brief    [Bit3]: INT3 Noise Filter Enable.
 *  @{
 */
#define REG_DNF_NFENCR_NFEN3_MASK           ((uint32_t)0x00000008)        /*!< for Bit Mask.  */
#define REG_DNF_NFENCR_NFEN3_DISABLE        ((uint32_t)0x00000000)        /*!< INT3 Noise Filter Disable.   */
#define REG_DNF_NFENCR_NFEN3_ENABLE         ((uint32_t)0x00000008)        /*!< INT3 Noise Filter Enable.    */
/**
 *  @}
 */ /* End of group NFENCR_NFEN3 */

/** 
 *  @defgroup NFENCR_NFEN2 NFEN2
 *  @brief    [Bit2]: INT2 Noise Filter Enable.
 *  @{
 */
#define REG_DNF_NFENCR_NFEN2_MASK           ((uint32_t)0x00000004)        /*!< for Bit Mask.  */
#define REG_DNF_NFENCR_NFEN2_DISABLE        ((uint32_t)0x00000000)        /*!< INT2 Noise Filter Disable.   */
#define REG_DNF_NFENCR_NFEN2_ENABLE         ((uint32_t)0x00000004)        /*!< INT2 Noise Filter Enable.    */
/**
 *  @}
 */ /* End of group NFENCR_NFEN2 */

/** 
 *  @defgroup NFENCR_NFEN1 NFEN1
 *  @brief    [Bit1]: INT1 Noise Filter Enable.
 *  @{
 */
#define REG_DNF_NFENCR_NFEN1_MASK           ((uint32_t)0x00000002)        /*!< for Bit Mask.  */
#define REG_DNF_NFENCR_NFEN1_DISABLE        ((uint32_t)0x00000000)        /*!< INT1 Noise Filter Disable.   */
#define REG_DNF_NFENCR_NFEN1_ENABLE         ((uint32_t)0x00000002)        /*!< INT1 Noise Filter Enable.    */
/**
 *  @}
 */ /* End of group NFENCR_NFEN1 */

/** 
 *  @defgroup NFENCR_NFEN0 NFEN0
 *  @brief    [Bit0]: INT0 Noise Filter Enable.
 *  @{
 */
#define REG_DNF_NFENCR_NFEN0_MASK           ((uint32_t)0x00000001)        /*!< for Bit Mask.  */
#define REG_DNF_NFENCR_NFEN0_DISABLE        ((uint32_t)0x00000000)        /*!< INT0 Noise Filter Disable.   */
#define REG_DNF_NFENCR_NFEN0_ENABLE         ((uint32_t)0x00000001)        /*!< INT0 Noise Filter Enable.    */
/**
 *  @}
 */ /* End of group NFENCR_NFEN0 */

/**
 *  @}
 */ /* End of group NFENCR */

/** 
 *  @}
 */ /* End of group DNF_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DNF_Exported_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group DNF_Exported_define */

/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DNF_Exported_typedef
 *  @{
 */
/*----------------------------------*/
/** 
 * @brief Input control structure definition.
 */
/*----------------------------------*/
typedef struct {
    uint32_t nfcks;         /*!< FUNCTION   :Noise Filter Clock Select.  
                                 VALUE      :Use @ref NFCKCR_NFCKS.     */
    uint32_t nfencr;        /*!< FUNCTION   :Noise Filter Enable/Disable.  
                                 VALUE      :Use @ref REG_DNF_NFENCR_NFEN0_MASK
                                 VALUE      :Use @ref REG_DNF_NFENCR_NFEN1_MASK
                                 VALUE      :Use @ref REG_DNF_NFENCR_NFEN2_MASK
                                 VALUE      :Use @ref REG_DNF_NFENCR_NFEN3_MASK
                                 VALUE      :Use @ref REG_DNF_NFENCR_NFEN4_MASK
                                 VALUE      :Use @ref REG_DNF_NFENCR_NFEN5_MASK
                                 VALUE      :Use @ref REG_DNF_NFENCR_NFEN6_MASK
                                 VALUE      :Use @ref REG_DNF_NFENCR_NFEN7_MASK
                                 VALUE      :Use @ref REG_DNF_NFENCR_NFEN8_MASK
                                 VALUE      :Use @ref REG_DNF_NFENCR_NFEN9_MASK
                                 VALUE      :Use @ref REG_DNF_NFENCR_NFEN10_MASK */
} REG_DNF_t;


/**
 *  @}
 */ /* End of group DNF_Exported_typedef */


/*------------------------------------------------------------------------------*/
/*  Functions                                                                   */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup DNF_Exported_functions
 *  @{
 */
/* DNFCKCR */
void REG_DNFCKCR_set(TSB_DNF_TypeDef *p_reg, uint32_t clock);
uint32_t REG_DNFCKCR_get(TSB_DNF_TypeDef *p_reg);
/* DNFENCR */
void REG_DNFENCR_enable(TSB_DNF_TypeDef *p_reg, uint32_t bit);
void REG_DNFENCR_disable(TSB_DNF_TypeDef *p_reg, uint32_t bit);
uint32_t REG_DNFENCR_get(TSB_DNF_TypeDef *p_reg);
/** 
 *  @}
 */ /* End of group DNF_Exported_functions */

/**
 *  @}
 */ /* End of group DNF */

/**
 *  @} 
 */ /* End of group Periph_Driver */

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __DNF_A_H */


