/** 
 *******************************************************************************
 * @file    except_m3h1.h
 * @brief   This file provides all the functions prototypes for EXCEPT driver.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */
/*------------------------------------------------------------------------------*/
/*  Define to prevent recursive inclusion                                       */
/*------------------------------------------------------------------------------*/
#ifndef __EXCEPT_M3H1_H
#define __EXCEPT_M3H1_H

#ifdef __cplusplus
extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "driver_com.h"
#include "configration.h"
/**
 *  @addtogroup Periph_Driver
 *  @{
 */

/** 
 *  @defgroup EXCEPT EXCEPT
 *  @brief    EXCEPT Driver.
 *  @{
 */

/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup EXCEPT_Exported_define EXCEPT Exported Define
 *  @{
 */
#define EXCEPT_LVD                  ((uint32_t)0x00000000)          /*!< Interrupt LVD                                                              */
#define EXCEPT_WDT                  ((uint32_t)0x00000001)          /*!< Interrupt WDT                                                              */
#define EXCEPT_INT00                ((uint32_t)0x00000002)          /*!< Interrupt Pin 00                                                           */
#define EXCEPT_INT01                ((uint32_t)0x00000003)          /*!< Interrupt Pin 01                                                           */
#define EXCEPT_INT02                ((uint32_t)0x00000004)          /*!< Interrupt Pin 02                                                           */
#define EXCEPT_INT13                ((uint32_t)0x00000005)          /*!< Interrupt Pin 13                                                           */
#define EXCEPT_I2CWUP               ((uint32_t)0x00000006)          /*!< Serial bus interface (WakeUp) interrupt (channel 0)                        */
#define EXCEPT_RTC                  ((uint32_t)0x00000007)          /*!< Real time clock interrupt                                                  */
#define EXCEPT_INT03                ((uint32_t)0x00000008)          /*!< Interrupt Pin 03                                                           */
#define EXCEPT_INT04                ((uint32_t)0x00000009)          /*!< Interrupt Pin 04                                                           */
#define EXCEPT_INT05                ((uint32_t)0x0000000A)          /*!< Interrupt Pin 05                                                           */
#define EXCEPT_INT06                ((uint32_t)0x0000000B)          /*!< Interrupt Pin 06                                                           */
#define EXCEPT_INT07                ((uint32_t)0x0000000C)          /*!< Interrupt Pin 07                                                           */
#define EXCEPT_INT08                ((uint32_t)0x0000000D)          /*!< Interrupt Pin 08                                                           */
#define EXCEPT_INT09                ((uint32_t)0x0000000E)          /*!< Interrupt Pin 09                                                           */
#define EXCEPT_INT10                ((uint32_t)0x0000000F)          /*!< Interrupt Pin 10                                                           */
#define EXCEPT_INT11                ((uint32_t)0x00000010)          /*!< Interrupt Pin 11                                                           */
#define EXCEPT_INT12                ((uint32_t)0x00000011)          /*!< Interrupt Pin 12                                                           */
#define EXCEPT_INT14                ((uint32_t)0x00000012)          /*!< Interrupt Pin 14                                                           */
#define EXCEPT_INT15                ((uint32_t)0x00000013)          /*!< Interrupt Pin 15                                                           */
#define EXCEPT_INT16                ((uint32_t)0x00000014)          /*!< Interrupt Pin 16                                                           */
#define EXCEPT_INT17                ((uint32_t)0x00000015)          /*!< Interrupt Pin 17                                                           */
#define EXCEPT_INT18                ((uint32_t)0x00000016)          /*!< Interrupt Pin 18                                                           */
#define EXCEPT_INT32                ((uint32_t)0x00000017)          /*!< Interrupt Pin 32                                                           */
#define EXCEPT_INT33                ((uint32_t)0x00000018)          /*!< Interrupt Pin 33                                                           */
#define EXCEPT_INT19                ((uint32_t)0x00000019)          /*!< Interrupt Pin 19                                                           */
#define EXCEPT_INT20                ((uint32_t)0x0000001A)          /*!< Interrupt Pin 20                                                           */
#define EXCEPT_INT21                ((uint32_t)0x0000001B)          /*!< Interrupt Pin 21                                                           */
#define EXCEPT_INT22                ((uint32_t)0x0000001C)          /*!< Interrupt Pin 22                                                           */
#define EXCEPT_INT23                ((uint32_t)0x0000001D)          /*!< Interrupt Pin 23                                                           */
#define EXCEPT_INT24                ((uint32_t)0x0000001E)          /*!< Interrupt Pin 24                                                           */
#define EXCEPT_INT25                ((uint32_t)0x0000001F)          /*!< Interrupt Pin 25                                                           */
#define EXCEPT_INT26                ((uint32_t)0x00000020)          /*!< Interrupt Pin 26                                                           */
#define EXCEPT_INT27                ((uint32_t)0x00000021)          /*!< Interrupt Pin 27                                                           */
#define EXCEPT_INT28                ((uint32_t)0x00000022)          /*!< Interrupt Pin 28                                                           */
#define EXCEPT_INT29                ((uint32_t)0x00000023)          /*!< Interrupt Pin 29                                                           */
#define EXCEPT_INT30                ((uint32_t)0x00000024)          /*!< Interrupt Pin 30                                                           */
#define EXCEPT_INT31                ((uint32_t)0x00000025)          /*!< Interrupt Pin 31                                                           */
#define EXCEPT_INTDMAATC00          ((uint32_t)0x00000026)          /*!< DMAA end of transfer 00                                                    */
#define EXCEPT_INTDMAATC01          ((uint32_t)0x00000027)          /*!< DMAA end of transfer 01                                                    */
#define EXCEPT_INTDMAATC02          ((uint32_t)0x00000028)          /*!< DMAA end of transfer 02                                                    */
#define EXCEPT_INTDMAATC03          ((uint32_t)0x00000029)          /*!< DMAA end of transfer 03                                                    */
#define EXCEPT_INTDMAATC04          ((uint32_t)0x0000002A)          /*!< DMAA end of transfer 04                                                    */
#define EXCEPT_INTDMAATC05          ((uint32_t)0x0000002B)          /*!< DMAA end of transfer 05                                                    */
#define EXCEPT_INTDMAATC06          ((uint32_t)0x0000002C)          /*!< DMAA end of transfer 06                                                    */
#define EXCEPT_INTDMAATC07          ((uint32_t)0x0000002D)          /*!< DMAA end of transfer 07                                                    */
#define EXCEPT_INTDMAATC08          ((uint32_t)0x0000002E)          /*!< DMAA end of transfer 08                                                    */
#define EXCEPT_INTDMAATC09          ((uint32_t)0x0000002F)          /*!< DMAA end of transfer 09                                                    */
#define EXCEPT_INTDMAATC10          ((uint32_t)0x00000030)          /*!< DMAA end of transfer 10                                                    */
#define EXCEPT_INTDMAATC11          ((uint32_t)0x00000031)          /*!< DMAA end of transfer 11                                                    */
#define EXCEPT_INTDMAATC12          ((uint32_t)0x00000032)          /*!< DMAA end of transfer 12                                                    */
#define EXCEPT_INTDMAATC13          ((uint32_t)0x00000033)          /*!< DMAA end of transfer 13                                                    */
#define EXCEPT_INTDMAATC14          ((uint32_t)0x00000034)          /*!< DMAA end of transfer 14                                                    */
#define EXCEPT_INTDMAATC15          ((uint32_t)0x00000035)          /*!< DMAA end of transfer 15                                                    */
#define EXCEPT_INTDMAATC16          ((uint32_t)0x00000036)          /*!< DMAA end of transfer 16                                                    */
#define EXCEPT_INTDMAATC17          ((uint32_t)0x00000037)          /*!< DMAA end of transfer 17                                                    */
#define EXCEPT_INTDMAATC18          ((uint32_t)0x00000038)          /*!< DMAA end of transfer 18                                                    */
#define EXCEPT_INTDMAATC19          ((uint32_t)0x00000039)          /*!< DMAA end of transfer 19                                                    */
#define EXCEPT_INTDMAATC20          ((uint32_t)0x0000003A)          /*!< DMAA end of transfer 20                                                    */
#define EXCEPT_INTDMAATC21          ((uint32_t)0x0000003B)          /*!< DMAA end of transfer 21                                                    */
#define EXCEPT_INTDMAATC22          ((uint32_t)0x0000003C)          /*!< DMAA end of transfer 22                                                    */
#define EXCEPT_INTDMAATC23          ((uint32_t)0x0000003D)          /*!< DMAA end of transfer 23                                                    */
#define EXCEPT_INTDMAATC24          ((uint32_t)0x0000003E)          /*!< DMAA end of transfer 24                                                    */
#define EXCEPT_INTDMAATC25          ((uint32_t)0x0000003F)          /*!< DMAA end of transfer 25                                                    */
#define EXCEPT_INTDMAATC26          ((uint32_t)0x00000040)          /*!< DMAA end of transfer 26                                                    */
#define EXCEPT_INTDMAATC27          ((uint32_t)0x00000041)          /*!< DMAA end of transfer 27                                                    */
#define EXCEPT_INTDMAATC28          ((uint32_t)0x00000042)          /*!< DMAA end of transfer 28                                                    */
#define EXCEPT_INTDMAATC29          ((uint32_t)0x00000043)          /*!< DMAA end of transfer 29                                                    */
#define EXCEPT_INTDMAATC30          ((uint32_t)0x00000044)          /*!< DMAA end of transfer 30                                                    */
#define EXCEPT_INTDMAATC31          ((uint32_t)0x00000045)          /*!< DMAA end of transfer 31                                                    */
#define EXCEPT_INTDMAAERR           ((uint32_t)0x00000046)          /*!< DMAA transfer error                                                        */
#define EXCEPT_INTDMABTC00          ((uint32_t)0x00000047)          /*!< DMAB end of transfer 00                                                    */
#define EXCEPT_INTDMABTC01          ((uint32_t)0x00000048)          /*!< DMAB end of transfer 01                                                    */
#define EXCEPT_INTDMABTC02          ((uint32_t)0x00000049)          /*!< DMAB end of transfer 02                                                    */
#define EXCEPT_INTDMABTC03          ((uint32_t)0x0000004A)          /*!< DMAB end of transfer 03                                                    */
#define EXCEPT_INTDMABTC04          ((uint32_t)0x0000004B)          /*!< DMAB end of transfer 04                                                    */
#define EXCEPT_INTDMABTC05          ((uint32_t)0x0000004C)          /*!< DMAB end of transfer 05                                                    */
#define EXCEPT_INTDMABTC06          ((uint32_t)0x0000004D)          /*!< DMAB end of transfer 06                                                    */
#define EXCEPT_INTDMABTC07          ((uint32_t)0x0000004E)          /*!< DMAB end of transfer 07                                                    */
#define EXCEPT_INTDMABTC08          ((uint32_t)0x0000004F)          /*!< DMAB end of transfer 08                                                    */
#define EXCEPT_INTDMABTC09          ((uint32_t)0x00000050)          /*!< DMAB end of transfer 09                                                    */
#define EXCEPT_INTDMABTC10          ((uint32_t)0x00000051)          /*!< DMAB end of transfer 10                                                    */
#define EXCEPT_INTDMABTC11          ((uint32_t)0x00000052)          /*!< DMAB end of transfer 11                                                    */
#define EXCEPT_INTDMABTC12          ((uint32_t)0x00000053)          /*!< DMAB end of transfer 12                                                    */
#define EXCEPT_INTDMABTC13          ((uint32_t)0x00000054)          /*!< DMAB end of transfer 13                                                    */
#define EXCEPT_INTDMABTC14          ((uint32_t)0x00000055)          /*!< DMAB end of transfer 14                                                    */
#define EXCEPT_INTDMABTC15          ((uint32_t)0x00000056)          /*!< DMAB end of transfer 15                                                    */
#define EXCEPT_INTDMABTC16          ((uint32_t)0x00000057)          /*!< DMAB end of transfer 16                                                    */
#define EXCEPT_INTDMABTC17          ((uint32_t)0x00000058)          /*!< DMAB end of transfer 17                                                    */
#define EXCEPT_INTDMABTC18          ((uint32_t)0x00000059)          /*!< DMAB end of transfer 18                                                    */
#define EXCEPT_INTDMABTC19          ((uint32_t)0x0000005A)          /*!< DMAB end of transfer 19                                                    */
#define EXCEPT_INTDMABTC20          ((uint32_t)0x0000005B)          /*!< DMAB end of transfer 20                                                    */
#define EXCEPT_INTDMABTC21          ((uint32_t)0x0000005C)          /*!< DMAB end of transfer 21                                                    */
#define EXCEPT_INTDMABTC22          ((uint32_t)0x0000005D)          /*!< DMAB end of transfer 22                                                    */
#define EXCEPT_INTDMABTC23          ((uint32_t)0x0000005E)          /*!< DMAB end of transfer 23                                                    */
#define EXCEPT_INTDMABTC24          ((uint32_t)0x0000005F)          /*!< DMAB end of transfer 24                                                    */
#define EXCEPT_INTDMABTC25          ((uint32_t)0x00000060)          /*!< DMAB end of transfer 25                                                    */
#define EXCEPT_INTDMABTC26          ((uint32_t)0x00000061)          /*!< DMAB end of transfer 26                                                    */
#define EXCEPT_INTDMABTC27          ((uint32_t)0x00000062)          /*!< DMAB end of transfer 27                                                    */
#define EXCEPT_INTDMABTC28          ((uint32_t)0x00000063)          /*!< DMAB end of transfer 28                                                    */
#define EXCEPT_INTDMABTC29          ((uint32_t)0x00000064)          /*!< DMAB end of transfer 29                                                    */
#define EXCEPT_INTDMABTC30          ((uint32_t)0x00000065)          /*!< DMAB end of transfer 30                                                    */
#define EXCEPT_INTDMABTC31          ((uint32_t)0x00000066)          /*!< DMAB end of transfer 31                                                    */
#define EXCEPT_INTDMABERR           ((uint32_t)0x00000067)          /*!< DMAB transfer error                                                        */
#define EXCEPT_INTRMC0              ((uint32_t)0x00000068)          /*!< Remote control reception interrupt                                         */

#define EXCEPT_EDGE_MASK            ((uint32_t)0x0000000E)          /*!< INTMODE mask */

#define EXCEPT_INTMODE_LOW          ((uint8_t)0x00)                 /*!< INTMODE low */
#define EXCEPT_INTMODE_HIGH         ((uint8_t)0x02)                 /*!< INTMODE high */
#define EXCEPT_INTMODE_FALLING      ((uint8_t)0x04)                 /*!< INTMODE falling */
#define EXCEPT_INTMODE_RISING       ((uint8_t)0x06)                 /*!< INTMODE rising */
#define EXCEPT_INTMODE_BOTH         ((uint8_t)0x08)                 /*!< INTMODE both */

#define EXCEPT_INTPFLG_DETECT       ((uint8_t)0x10)                 /*!< INTPFLG detected */
#define EXCEPT_INTPFLG_UNDETECT     ((uint8_t)0x00)                 /*!< INTPFLG undetected */

#define EXCEPT_INTNFLG_DETECT       ((uint8_t)0x20)                 /*!< INTNFLG detected */
#define EXCEPT_INTNFLG_UNDETECT     ((uint8_t)0x00)                 /*!< INTNFLG undetected */

#define EXCEPT_INT000FLG_DETECT     ((uint32_t)0x00000001)          /*!< Interrupt LVD                                                              */
#define EXCEPT_INT016FLG_DETECT     ((uint32_t)0x00010000)          /*!< Interrupt WDT                                                              */
#define EXCEPT_INT032FLG_DETECT     ((uint32_t)0x00000001)          /*!< Interrupt Pin 00                                                           */
#define EXCEPT_INT033FLG_DETECT     ((uint32_t)0x00000002)          /*!< Interrupt Pin 01                                                           */
#define EXCEPT_INT034FLG_DETECT     ((uint32_t)0x00000004)          /*!< Interrupt Pin 02                                                           */
#define EXCEPT_INT035FLG_DETECT     ((uint32_t)0x00000008)          /*!< Interrupt Pin 13                                                           */
#define EXCEPT_INT048FLG_DETECT     ((uint32_t)0x00010000)          /*!< Serial bus interface (WakeUp) interrupt (channel 0)                        */
#define EXCEPT_INT049FLG_DETECT     ((uint32_t)0x00020000)          /*!< Real time clock interrupt                                                  */
#define EXCEPT_INT096FLG_DETECT     ((uint32_t)0x00000001)          /*!< DMAA end of transfer 00                                                    */
#define EXCEPT_INT097FLG_DETECT     ((uint32_t)0x00000002)          /*!< DMAA end of transfer 01                                                    */
#define EXCEPT_INT098FLG_DETECT     ((uint32_t)0x00000004)          /*!< DMAA end of transfer 02                                                    */
#define EXCEPT_INT099FLG_DETECT     ((uint32_t)0x00000008)          /*!< DMAA end of transfer 03                                                    */
#define EXCEPT_INT100FLG_DETECT     ((uint32_t)0x00000010)          /*!< DMAA end of transfer 04                                                    */
#define EXCEPT_INT101FLG_DETECT     ((uint32_t)0x00000020)          /*!< DMAA end of transfer 05                                                    */
#define EXCEPT_INT102FLG_DETECT     ((uint32_t)0x00000040)          /*!< DMAA end of transfer 06                                                    */
#define EXCEPT_INT103FLG_DETECT     ((uint32_t)0x00000080)          /*!< DMAA end of transfer 07                                                    */
#define EXCEPT_INT104FLG_DETECT     ((uint32_t)0x00000100)          /*!< DMAA end of transfer 08                                                    */
#define EXCEPT_INT105FLG_DETECT     ((uint32_t)0x00000200)          /*!< DMAA end of transfer 09                                                    */
#define EXCEPT_INT106FLG_DETECT     ((uint32_t)0x00000400)          /*!< DMAA end of transfer 10                                                    */
#define EXCEPT_INT107FLG_DETECT     ((uint32_t)0x00000800)          /*!< DMAA end of transfer 11                                                    */
#define EXCEPT_INT108FLG_DETECT     ((uint32_t)0x00001000)          /*!< DMAA end of transfer 12                                                    */
#define EXCEPT_INT109FLG_DETECT     ((uint32_t)0x00002000)          /*!< DMAA end of transfer 13                                                    */
#define EXCEPT_INT110FLG_DETECT     ((uint32_t)0x00004000)          /*!< DMAA end of transfer 14                                                    */
#define EXCEPT_INT111FLG_DETECT     ((uint32_t)0x00008000)          /*!< DMAA end of transfer 15                                                    */
#define EXCEPT_INT112FLG_DETECT     ((uint32_t)0x00010000)          /*!< DMAA end of transfer 16                                                    */
#define EXCEPT_INT113FLG_DETECT     ((uint32_t)0x00020000)          /*!< DMAA end of transfer 17                                                    */
#define EXCEPT_INT114FLG_DETECT     ((uint32_t)0x00040000)          /*!< DMAA end of transfer 18                                                    */
#define EXCEPT_INT115FLG_DETECT     ((uint32_t)0x00080000)          /*!< DMAA end of transfer 19                                                    */
#define EXCEPT_INT116FLG_DETECT     ((uint32_t)0x00100000)          /*!< DMAA end of transfer 20                                                    */
#define EXCEPT_INT117FLG_DETECT     ((uint32_t)0x00200000)          /*!< DMAA end of transfer 21                                                    */
#define EXCEPT_INT118FLG_DETECT     ((uint32_t)0x00400000)          /*!< DMAA end of transfer 22                                                    */
#define EXCEPT_INT119FLG_DETECT     ((uint32_t)0x00800000)          /*!< DMAA end of transfer 23                                                    */
#define EXCEPT_INT120FLG_DETECT     ((uint32_t)0x01000000)          /*!< DMAA end of transfer 24                                                    */
#define EXCEPT_INT121FLG_DETECT     ((uint32_t)0x02000000)          /*!< DMAA end of transfer 25                                                    */
#define EXCEPT_INT122FLG_DETECT     ((uint32_t)0x04000000)          /*!< DMAA end of transfer 26                                                    */
#define EXCEPT_INT123FLG_DETECT     ((uint32_t)0x08000000)          /*!< DMAA end of transfer 27                                                    */
#define EXCEPT_INT124FLG_DETECT     ((uint32_t)0x10000000)          /*!< DMAA end of transfer 28                                                    */
#define EXCEPT_INT125FLG_DETECT     ((uint32_t)0x20000000)          /*!< DMAA end of transfer 29                                                    */
#define EXCEPT_INT126FLG_DETECT     ((uint32_t)0x40000000)          /*!< DMAA end of transfer 30                                                    */
#define EXCEPT_INT127FLG_DETECT     ((uint32_t)0x80000000)          /*!< DMAA end of transfer 31                                                    */
#define EXCEPT_INT128FLG_DETECT     ((uint32_t)0x00000001)          /*!< DMAA transfer error                                                        */
#define EXCEPT_INT129FLG_DETECT     ((uint32_t)0x00000002)          /*!< DMAB end of transfer 00                                                    */
#define EXCEPT_INT130FLG_DETECT     ((uint32_t)0x00000004)          /*!< DMAB end of transfer 01                                                    */
#define EXCEPT_INT131FLG_DETECT     ((uint32_t)0x00000008)          /*!< DMAB end of transfer 02                                                    */
#define EXCEPT_INT132FLG_DETECT     ((uint32_t)0x00000010)          /*!< DMAB end of transfer 03                                                    */
#define EXCEPT_INT133FLG_DETECT     ((uint32_t)0x00000020)          /*!< DMAB end of transfer 04                                                    */
#define EXCEPT_INT134FLG_DETECT     ((uint32_t)0x00000040)          /*!< DMAB end of transfer 05                                                    */
#define EXCEPT_INT135FLG_DETECT     ((uint32_t)0x00000080)          /*!< DMAB end of transfer 06                                                    */
#define EXCEPT_INT136FLG_DETECT     ((uint32_t)0x00000100)          /*!< DMAB end of transfer 07                                                    */
#define EXCEPT_INT137FLG_DETECT     ((uint32_t)0x00000200)          /*!< DMAB end of transfer 08                                                    */
#define EXCEPT_INT138FLG_DETECT     ((uint32_t)0x00000400)          /*!< DMAB end of transfer 09                                                    */
#define EXCEPT_INT139FLG_DETECT     ((uint32_t)0x00000800)          /*!< DMAB end of transfer 10                                                    */
#define EXCEPT_INT140FLG_DETECT     ((uint32_t)0x00001000)          /*!< DMAB end of transfer 11                                                    */
#define EXCEPT_INT141FLG_DETECT     ((uint32_t)0x00002000)          /*!< DMAB end of transfer 12                                                    */
#define EXCEPT_INT142FLG_DETECT     ((uint32_t)0x00004000)          /*!< DMAB end of transfer 13                                                    */
#define EXCEPT_INT143FLG_DETECT     ((uint32_t)0x00008000)          /*!< DMAB end of transfer 14                                                    */
#define EXCEPT_INT144FLG_DETECT     ((uint32_t)0x00010000)          /*!< DMAB end of transfer 15                                                    */
#define EXCEPT_INT145FLG_DETECT     ((uint32_t)0x00020000)          /*!< DMAB end of transfer 16                                                    */
#define EXCEPT_INT146FLG_DETECT     ((uint32_t)0x00040000)          /*!< DMAB end of transfer 17                                                    */
#define EXCEPT_INT147FLG_DETECT     ((uint32_t)0x00080000)          /*!< DMAB end of transfer 18                                                    */
#define EXCEPT_INT148FLG_DETECT     ((uint32_t)0x00100000)          /*!< DMAB end of transfer 19                                                    */
#define EXCEPT_INT149FLG_DETECT     ((uint32_t)0x00200000)          /*!< DMAB end of transfer 20                                                    */
#define EXCEPT_INT150FLG_DETECT     ((uint32_t)0x00400000)          /*!< DMAB end of transfer 21                                                    */
#define EXCEPT_INT151FLG_DETECT     ((uint32_t)0x00800000)          /*!< DMAB end of transfer 22                                                    */
#define EXCEPT_INT152FLG_DETECT     ((uint32_t)0x01000000)          /*!< DMAB end of transfer 23                                                    */
#define EXCEPT_INT153FLG_DETECT     ((uint32_t)0x02000000)          /*!< DMAB end of transfer 24                                                    */
#define EXCEPT_INT154FLG_DETECT     ((uint32_t)0x04000000)          /*!< DMAB end of transfer 25                                                    */
#define EXCEPT_INT155FLG_DETECT     ((uint32_t)0x08000000)          /*!< DMAB end of transfer 26                                                    */
#define EXCEPT_INT156FLG_DETECT     ((uint32_t)0x10000000)          /*!< DMAB end of transfer 27                                                    */
#define EXCEPT_INT157FLG_DETECT     ((uint32_t)0x20000000)          /*!< DMAB end of transfer 28                                                    */
#define EXCEPT_INT158FLG_DETECT     ((uint32_t)0x40000000)          /*!< DMAB end of transfer 29                                                    */
#define EXCEPT_INT159FLG_DETECT     ((uint32_t)0x80000000)          /*!< DMAB end of transfer 30                                                    */
#define EXCEPT_INT160FLG_DETECT     ((uint32_t)0x00000001)          /*!< DMAB end of transfer 31                                                    */
#define EXCEPT_INT161FLG_DETECT     ((uint32_t)0x00000002)          /*!< DMAB transfer error                                                        */
#define EXCEPT_INT162FLG_DETECT     ((uint32_t)0x00000004)          /*!< Interrupt Pin 03                                                           */
#define EXCEPT_INT163FLG_DETECT     ((uint32_t)0x00000008)          /*!< Interrupt Pin 04                                                           */
#define EXCEPT_INT164FLG_DETECT     ((uint32_t)0x00000010)          /*!< Interrupt Pin 05                                                           */
#define EXCEPT_INT165FLG_DETECT     ((uint32_t)0x00000020)          /*!< Interrupt Pin 06                                                           */
#define EXCEPT_INT166FLG_DETECT     ((uint32_t)0x00000040)          /*!< Interrupt Pin 07                                                           */
#define EXCEPT_INT167FLG_DETECT     ((uint32_t)0x00000080)          /*!< Interrupt Pin 08                                                           */
#define EXCEPT_INT168FLG_DETECT     ((uint32_t)0x00000100)          /*!< Interrupt Pin 09                                                           */
#define EXCEPT_INT169FLG_DETECT     ((uint32_t)0x00000200)          /*!< Interrupt Pin 10                                                           */
#define EXCEPT_INT170FLG_DETECT     ((uint32_t)0x00000400)          /*!< Interrupt Pin 11                                                           */
#define EXCEPT_INT171FLG_DETECT     ((uint32_t)0x00000800)          /*!< Interrupt Pin 12                                                           */
#define EXCEPT_INT172FLG_DETECT     ((uint32_t)0x00001000)          /*!< Interrupt Pin 14                                                           */
#define EXCEPT_INT173FLG_DETECT     ((uint32_t)0x00002000)          /*!< Interrupt Pin 15                                                           */
#define EXCEPT_INT174FLG_DETECT     ((uint32_t)0x00004000)          /*!< Interrupt Pin 16                                                           */
#define EXCEPT_INT175FLG_DETECT     ((uint32_t)0x00008000)          /*!< Interrupt Pin 17                                                           */
#define EXCEPT_INT176FLG_DETECT     ((uint32_t)0x00010000)          /*!< Interrupt Pin 18                                                           */
#define EXCEPT_INT177FLG_DETECT     ((uint32_t)0x00020000)          /*!< Interrupt Pin 19                                                           */
#define EXCEPT_INT178FLG_DETECT     ((uint32_t)0x00040000)          /*!< Interrupt Pin 20                                                           */
#define EXCEPT_INT179FLG_DETECT     ((uint32_t)0x00080000)          /*!< Interrupt Pin 21                                                           */
#define EXCEPT_INT180FLG_DETECT     ((uint32_t)0x00100000)          /*!< Interrupt Pin 22                                                           */
#define EXCEPT_INT181FLG_DETECT     ((uint32_t)0x00200000)          /*!< Interrupt Pin 23                                                           */
#define EXCEPT_INT182FLG_DETECT     ((uint32_t)0x00400000)          /*!< Interrupt Pin 24                                                           */
#define EXCEPT_INT183FLG_DETECT     ((uint32_t)0x00800000)          /*!< Interrupt Pin 25                                                           */
#define EXCEPT_INT184FLG_DETECT     ((uint32_t)0x01000000)          /*!< Interrupt Pin 26                                                           */
#define EXCEPT_INT185FLG_DETECT     ((uint32_t)0x02000000)          /*!< Interrupt Pin 27                                                           */
#define EXCEPT_INT186FLG_DETECT     ((uint32_t)0x04000000)          /*!< Interrupt Pin 28                                                           */
#define EXCEPT_INT187FLG_DETECT     ((uint32_t)0x08000000)          /*!< Interrupt Pin 29                                                           */
#define EXCEPT_INT188FLG_DETECT     ((uint32_t)0x10000000)          /*!< Interrupt Pin 30                                                           */
#define EXCEPT_INT189FLG_DETECT     ((uint32_t)0x20000000)          /*!< Interrupt Pin 31                                                           */
#define EXCEPT_INT190FLG_DETECT     ((uint32_t)0x40000000)          /*!< Remote control reception interrupt                                         */
#define EXCEPT_INT191FLG_DETECT     ((uint32_t)0x80000000)          /*!< Interrupt Pin 32                                                           */
#define EXCEPT_INT192FLG_DETECT     ((uint32_t)0x00000001)          /*!< Interrupt Pin 33                                                           */

#define EXCEPT_INT000FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt LVD                                                              */
#define EXCEPT_INT016FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt WDT                                                              */
#define EXCEPT_INT032FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 00                                                           */
#define EXCEPT_INT033FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 01                                                           */
#define EXCEPT_INT034FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 02                                                           */
#define EXCEPT_INT035FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 13                                                           */
#define EXCEPT_INT048FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Serial bus interface (WakeUp) interrupt (channel 0)                        */
#define EXCEPT_INT049FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Real time clock interrupt                                                  */
#define EXCEPT_INT096FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 00                                                    */
#define EXCEPT_INT097FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 01                                                    */
#define EXCEPT_INT098FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 02                                                    */
#define EXCEPT_INT099FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 03                                                    */
#define EXCEPT_INT100FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 04                                                    */
#define EXCEPT_INT101FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 05                                                    */
#define EXCEPT_INT102FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 06                                                    */
#define EXCEPT_INT103FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 07                                                    */
#define EXCEPT_INT104FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 08                                                    */
#define EXCEPT_INT105FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 09                                                    */
#define EXCEPT_INT106FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 10                                                    */
#define EXCEPT_INT107FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 11                                                    */
#define EXCEPT_INT108FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 12                                                    */
#define EXCEPT_INT109FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 13                                                    */
#define EXCEPT_INT110FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 14                                                    */
#define EXCEPT_INT111FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 15                                                    */
#define EXCEPT_INT112FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 16                                                    */
#define EXCEPT_INT113FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 17                                                    */
#define EXCEPT_INT114FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 18                                                    */
#define EXCEPT_INT115FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 19                                                    */
#define EXCEPT_INT116FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 20                                                    */
#define EXCEPT_INT117FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 21                                                    */
#define EXCEPT_INT118FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 22                                                    */
#define EXCEPT_INT119FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 23                                                    */
#define EXCEPT_INT120FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 24                                                    */
#define EXCEPT_INT121FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 25                                                    */
#define EXCEPT_INT122FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 26                                                    */
#define EXCEPT_INT123FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 27                                                    */
#define EXCEPT_INT124FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 28                                                    */
#define EXCEPT_INT125FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 29                                                    */
#define EXCEPT_INT126FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 30                                                    */
#define EXCEPT_INT127FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA end of transfer 31                                                    */
#define EXCEPT_INT128FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAA transfer error                                                        */
#define EXCEPT_INT129FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 00                                                    */
#define EXCEPT_INT130FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 01                                                    */
#define EXCEPT_INT131FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 02                                                    */
#define EXCEPT_INT132FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 03                                                    */
#define EXCEPT_INT133FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 04                                                    */
#define EXCEPT_INT134FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 05                                                    */
#define EXCEPT_INT135FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 06                                                    */
#define EXCEPT_INT136FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 07                                                    */
#define EXCEPT_INT137FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 08                                                    */
#define EXCEPT_INT138FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 09                                                    */
#define EXCEPT_INT139FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 10                                                    */
#define EXCEPT_INT140FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 11                                                    */
#define EXCEPT_INT141FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 12                                                    */
#define EXCEPT_INT142FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 13                                                    */
#define EXCEPT_INT143FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 14                                                    */
#define EXCEPT_INT144FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 15                                                    */
#define EXCEPT_INT145FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 16                                                    */
#define EXCEPT_INT146FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 17                                                    */
#define EXCEPT_INT147FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 18                                                    */
#define EXCEPT_INT148FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 19                                                    */
#define EXCEPT_INT149FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 20                                                    */
#define EXCEPT_INT150FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 21                                                    */
#define EXCEPT_INT151FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 22                                                    */
#define EXCEPT_INT152FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 23                                                    */
#define EXCEPT_INT153FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 24                                                    */
#define EXCEPT_INT154FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 25                                                    */
#define EXCEPT_INT155FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 26                                                    */
#define EXCEPT_INT156FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 27                                                    */
#define EXCEPT_INT157FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 28                                                    */
#define EXCEPT_INT158FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 29                                                    */
#define EXCEPT_INT159FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 30                                                    */
#define EXCEPT_INT160FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB end of transfer 31                                                    */
#define EXCEPT_INT161FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< DMAB transfer error                                                        */
#define EXCEPT_INT162FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 03                                                           */
#define EXCEPT_INT163FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 04                                                           */
#define EXCEPT_INT164FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 05                                                           */
#define EXCEPT_INT165FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 06                                                           */
#define EXCEPT_INT166FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 07                                                           */
#define EXCEPT_INT167FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 08                                                           */
#define EXCEPT_INT168FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 09                                                           */
#define EXCEPT_INT169FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 10                                                           */
#define EXCEPT_INT170FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 11                                                           */
#define EXCEPT_INT171FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 12                                                           */
#define EXCEPT_INT172FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 14                                                           */
#define EXCEPT_INT173FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 15                                                           */
#define EXCEPT_INT174FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 16                                                           */
#define EXCEPT_INT175FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 17                                                           */
#define EXCEPT_INT176FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 18                                                           */
#define EXCEPT_INT177FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 19                                                           */
#define EXCEPT_INT178FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 20                                                           */
#define EXCEPT_INT179FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 21                                                           */
#define EXCEPT_INT180FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 22                                                           */
#define EXCEPT_INT181FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 23                                                           */
#define EXCEPT_INT182FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 24                                                           */
#define EXCEPT_INT183FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 25                                                           */
#define EXCEPT_INT184FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 26                                                           */
#define EXCEPT_INT185FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 27                                                           */
#define EXCEPT_INT186FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 28                                                           */
#define EXCEPT_INT187FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 29                                                           */
#define EXCEPT_INT188FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 30                                                           */
#define EXCEPT_INT189FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 31                                                           */
#define EXCEPT_INT190FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Remote control reception interrupt                                         */
#define EXCEPT_INT191FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 32                                                           */
#define EXCEPT_INT192FLG_UNDETECT   ((uint32_t)0x00000000)          /*!< Interrupt Pin 33                                                           */

#define RESET_LVD                   ((uint8_t)0x00)                 /*!< RESET LVD */
#define RESET_STOP2                 ((uint8_t)0x01)                 /*!< RESET STOP2 */
#define RESET_PINR                  ((uint8_t)0x02)                 /*!< RESET PINR */
#define RESET_POR                   ((uint8_t)0x03)                 /*!< RESET POR */
#define RESET_OFD                   ((uint8_t)0x04)                 /*!< RESET OFD */
#define RESET_WDT                   ((uint8_t)0x05)                 /*!< RESET WDT */
#define RESET_LOCK                  ((uint8_t)0x06)                 /*!< RESET LOCK */
#define RESET_SYS                   ((uint8_t)0x07)                 /*!< RESET SYS */

#define RESET_LVD_FLG               ((uint8_t)0x20)                 /*!< RESET LVD */
#define RESET_STOP2_FLG             ((uint8_t)0x10)                 /*!< RESET STOP2 */
#define RESET_PINR_FLG              ((uint8_t)0x08)                 /*!< RESET PINR */
#define RESET_POR_FLG               ((uint8_t)0x01)                 /*!< RESET POR */
#define RESET_OFD_FLG               ((uint8_t)0x08)                 /*!< RESET OFD */
#define RESET_WDT_FLG               ((uint8_t)0x04)                 /*!< RESET WDT */
#define RESET_LOCK_FLG              ((uint8_t)0x02)                 /*!< RESET LOCK */
#define RESET_SYS_FLG               ((uint8_t)0x01)                 /*!< RESET SYS */
/**
 *  @}
 */ /* End of group EXCEPT_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup EXCEPT_Exported_define EXCEPT Exported Define
 *  @{
 */
/* no define */
/**
 *  @}
 */ /* End of group EXCEPT_Exported_define */

/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup EXCEPT_Exported_typedef EXCEPT Exported Typedef
 *  @{
 */
/** 
 * @brief  EXCEPT member.
*/
/*----------------------------------*/
typedef struct
{
    TSB_RLM_TypeDef       *p_instance;     /*!< Registers base address.           */
} reset_t;

/** 
 * @brief  RLM member.
*/
/*----------------------------------*/
typedef struct
{
    TSB_IA_TypeDef       *p_instance1;     /*!< Registers base address.           */
    TSB_IB_TypeDef       *p_instance2;     /*!< Registers base address.           */
    TSB_IMN_TypeDef      *p_instance3;     /*!< Registers base address.           */
} except_t;
/**
 *  @}
 */ /* End of group EXCEPT_Exported_typedef */

/*------------------------------------------------------------------------------*/
/*  Functions                                                                   */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup EXCEPT_Exported_functions EXCEPT Exported Functions
 *  @{
 */
void except_set_int(except_t *p_obj, uint32_t interrupt, TXZ_FunctionalState state, uint32_t level);
void except_clear_int(except_t *p_obj, uint32_t interrupt);
uint8_t except_get_edge(except_t *p_obj, uint32_t interrupt);
uint8_t reset_get_flag(reset_t *p_obj, uint32_t reset);
void reset_clear_flag(reset_t *p_obj, uint32_t reset);
uint32_t except_get_int(except_t *p_obj, uint32_t interrupt);
/**
 *  @}
 */ /* End of group EXCEPT_Exported_functions */

/**
 *  @}
 */ /* End of group EXCEPT */

/**
 *  @}
 */ /* End of group Periph_Driver */

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __EXCEPT_M3H1_H */


