/**
 *******************************************************************************
 * @file    lvd_d.c
 * @brief   This file provides API functions for LVD.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */

#ifdef __cplusplus
 extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include <stdio.h>
#include "driver_com.h"
#include "lvd.h"
#include "sys_timer.h"

#if defined(__LVD_D_H)

/**
 *  @addtogroup Periph_Driver
 *  @{
 */

/** 
 *  @addtogroup LVD
 *  @brief      LVD Driver.
 *  @{
 */
/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup LVD_Private_define LVD Private Define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group LVD_Private_define */


/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup LVD_Private_define LVD Private Define
 *  @{
 */
#define LVD_UPPER           ((uint32_t)0x00000000)          /*!< LVD UPPER                */
#define LVD_LOWER           ((uint32_t)0x00000001)          /*!< LVD LOWER                */

#define LVD_VOLTAGE_265     ((uint32_t)0x00000000)          /*!< LVD voltage 2.65+-0.1V   */
#define LVD_VOLTAGE_27      ((uint32_t)0x00000010)          /*!< LVD voltage 2.7+-0.1V    */
#define LVD_VOLTAGE_28      ((uint32_t)0x00000020)          /*!< LVD voltage 2.8+-0.1V    */
#define LVD_VOLTAGE_29      ((uint32_t)0x00000030)          /*!< LVD voltage 2.9+-0.1V    */
#define LVD_VOLTAGE_40      ((uint32_t)0x00000040)          /*!< LVD voltage 4.0+-0.1V    */
#define LVD_VOLTAGE_42      ((uint32_t)0x00000050)          /*!< LVD voltage 4.2+-0.1V    */
#define LVD_VOLTAGE_44      ((uint32_t)0x00000060)          /*!< LVD voltage 4.4+-0.1V    */
#define LVD_VOLTAGE_46      ((uint32_t)0x00000070)          /*!< LVD voltage 4.6+-0.1V    */

#define LVD_SEL_INT         ((uint32_t)0x00000004)          /*!< LVD INTLVD               */
#define LVD_SEL_RESET       ((uint32_t)0x00000000)          /*!< LVD reset                */
#define LVD_OUT_ENABLE      ((uint32_t)0x00000002)          /*!< LVD output enable        */
#define LVD_OUT_DISABLE     ((uint32_t)0xFFFFFFFD)          /*!< LVD output disable       */
#define LVD_ENABLE          ((uint32_t)0x00000001)          /*!< LVD enable               */
#define LVD_DISABLE         ((uint32_t)0xFFFFFFFE)          /*!< LVD disable              */
/** 
 *  @}
 */ /* End of group LVD_Private_define */


/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup LVD_Private_define LVD Private Define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group LVD_Private_define */


/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup LVD_Private_typedef LVD Private Typedef
 *  @{
 */

/* no define */

/**
 *  @}
 */ /* End of group LVD_Private_typedef */


/*------------------------------------------------------------------------------*/
/*  Private Function                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup LVD_Private_fuctions LVD Private Fuctions
 *  @{
 */


/**
 *  @}
 */ /* End of group LVD_Private_fuctions */

/*------------------------------------------------------------------------------*/
/*  Public Function                                                             */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup LVD_Exported_functions
 *  @{
 */
/*--------------------------------------------------*/
/**
  * @brief     Initialize the LVD object.
  * @param     -
  * @retval    -
  * @note      -
  * @attention This function is not available in interrupt.
  */
/*--------------------------------------------------*/
void init_LVD(void)
{
    TSB_LVD->CR &= (uint8_t)LVD_DISABLE;                 /* LVD Disable */
    TSB_LVD->CR |= (uint8_t)LVD_VOLTAGE_40;              /* 4.0V */
    TSB_LVD->CR |= (uint8_t)LVD_SEL_RESET;               /* RESET */
    TSB_LVD->CR &= (uint8_t)LVD_OUT_DISABLE;             /* Output Disable */
    wait(100);
}

/*--------------------------------------------------*/
/**
  * @brief     Start the LVD object.
  * @param     -
  * @retval    -
  * @note      -
  * @attention This function is not available in interrupt.
  */
/*--------------------------------------------------*/
void start_LVD(void)
{
    TSB_LVD->CR |= (uint8_t)LVD_ENABLE;                  /* LVD Enable */
    wait(1000);
}

/**
 *  @} 
 */ /* End of group LVD_Exported_functions */
 
/**
 *  @} 
 */ /* End of group LVD */
 
/**
 *  @} 
 */ /* End of group Periph_Driver */
 
#endif /* defined(__LVD_D_H)  */

#ifdef __cplusplus
}
#endif /* __cplusplus */

