/** 
 *******************************************************************************
 * @file    lvd_d.h
 * @brief   This file provides all the functions prototypes for LVD.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */
/*------------------------------------------------------------------------------*/
/*  Define to prevent recursive inclusion                                       */
/*------------------------------------------------------------------------------*/
#ifndef __LVD_D_H
#define __LVD_D_H

#ifdef __cplusplus
extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "driver_com.h"

/**
 *  @addtogroup Periph_Driver
 *  @{
 */

/** 
 *  @defgroup LVD LVD
 *  @brief    LVD Driver.
 *  @{
 */
/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup LVD_Exported_define LVD Exported Define
 *  @{
 */
/* no define */
/**
 *  @}
 */ /* End of group LVD_Exported_define */

/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup LVD_Exported_define LVD Exported Define
 *  @{
 */

/* no define */

/**
 *  @}
 */ /* End of group LVD_Exported_define */

/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup LVD_Exported_typedef LVD Exported Typedef
 *  @{
 */

/* no define */

/**
 *  @}
 */ /* End of group LVD_Exported_typedef */

/*------------------------------------------------------------------------------*/
/*  Functions                                                                   */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup LVD_Exported_functions LVD Exported Functions
 *  @{
 */
void init_LVD(void);
void start_LVD(void);
TXZ_Result GetStatus_LVD(void);

/**
 *  @}
 */ /* End of group LVD_Exported_functions */

/**
 *  @}
 */ /* End of group LVD */

/**
 *  @}
 */ /* End of group Periph_Driver */

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __LVD_D_H */


