/**
 *******************************************************************************
 * @file    ofd_a.c
 * @brief   This file provides API functions for A-OFD.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */

#ifdef __cplusplus
 extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "ofd.h"

#if defined(__OFD_A_H)
/**
 *  @addtogroup Periph_Driver Peripheral Driver
 *  @{
 */

/** 
 *  @addtogroup OFD
 *  @brief      OFD Driver.
 *  @{
 */
/*------------------------------------------------------------------------------*/
/*  Macro Function                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup OFD_Private_macro
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group OFD_Private_macro */


/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup OFD_Private_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group OFD_Private_define */

/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup OFD_Private_define
 *  @{
 */

/** 
 *  @defgroup Null Null Pointer
 *  @brief    Null Pointer.
 *  @{
 */
#define REG_OFD_NULL                  ((void *)0)
/**
 *  @}
 */ /* End of group Null */

/** 
 *  @defgroup CheckParamResult Parameter Check Result
 *  @brief    Whether the parameter is specified or not.
 *  @{
 */
#define REG_OFD_PARAM_OK              ((int32_t)1)              /*!< Parameter is valid(specified).         */
#define REG_OFD_PARAM_NG              ((int32_t)0)              /*!< Parameter is invalid(not specified).   */
/**
 *  @}
 */ /* End of name Parameter CheckParamResult */


/** 
 *  @}
 */ /* End of group OFD_Private_define */


/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup OFD_Private_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group OFD_Private_define */


/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup OFD_Private_typedef
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group OFD_Private_typedef */

/*------------------------------------------------------------------------------*/
/*  Private Member                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup OFD_Private_variables
 *  @{
 */

/* no define */

/**
 *  @}
 */ /* End of group OFD_Private_variables */


/*------------------------------------------------------------------------------*/
/*  Private Function                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup OFD_Private_fuctions
 *  @{
 */
#ifdef DEBUG
    __STATIC_INLINE int32_t check_param_OFDMON_ST(uint32_t param);
#endif /* #ifdef DEBUG */
#ifdef DEBUG
/*--------------------------------------------------*/
/** 
  * @brief  @ref OFDCR_ST Paramter Check.
  * @param  clock  :@ref OFDCR_ST
  * @return Result.
  * @retval REG_OFD_PARAM_OK :Valid
  * @retval REG_OFD_PARAM_NG :Invalid
  * @note   -
  */
/*--------------------------------------------------*/
__STATIC_INLINE int32_t check_param_OFDMON_ST(uint32_t param)
{
    int32_t result = REG_OFD_PARAM_NG;

    switch (param) 
    {
    case REG_OFD_OFDMON_OFDMON_EHOSC:
    case REG_OFD_OFDMON_OFDMON_FC:
        result = REG_OFD_PARAM_OK;
        break;
    default:
        /* no process */
        break;
    }

    return (result);
}
#endif /* #ifdef DEBUG */
/**
 *  @}
 */ /* End of group OFD_Private_fuctions */


/*------------------------------------------------------------------------------*/
/*  Public Function                                                             */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup OFD_Exported_functions
 *  @{
 */


/*--------------------------------------------------*/
/**
  * @brief  Register Write Disable.
  * @param  p_reg   :Register Base Address.
  * @param  -
  * @return -
  * @retval -
  * @note   The used register.
  * | Register  | Bit Symbol |
  * | :---      | :---       |
  * | OFDCR1    | :---       |
  * |           | OFDWEN     |
  */
/*--------------------------------------------------*/
void REG_OFDWEN_disable(TSB_OFD_TypeDef *p_reg)
{
    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
#ifdef DEBUG
    /* Check the REG_OFD_NULL of address. */
    assert_param(IS_POINTER_NOT_NULL(p_reg));
#endif /* #ifdef DEBUG */
    /*--- [OFDCR]<OUTEN> ---*/
    /*------------------------------*/
    /*  Register Set                */
    /*------------------------------*/
    p_reg->CR1 = REG_OFD_OFDCR1_OFDWEN_DISABLE;
}
/*--------------------------------------------------*/
/**
  * @brief  Register Write Enable.
  * @param  p_reg   :Register Base Address.
  * @param  -
  * @return -
  * @retval -
  * @note   The used register.
  * | Register  | Bit Symbol |
  * | :---      | :---       |
  * | OFDCR1    | :---       |
  * |           | OFDWEN     |
  */
/*--------------------------------------------------*/
void REG_OFDWEN_enable(TSB_OFD_TypeDef *p_reg)
{
    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
#ifdef DEBUG
    /* Check the REG_OFD_NULL of address. */
    assert_param(IS_POINTER_NOT_NULL(p_reg));
#endif /* #ifdef DEBUG */
    /*--- [OFDCR]<OUTEN> ---*/
    /*------------------------------*/
    /*  Register Set                */
    /*------------------------------*/
    p_reg->CR1 = REG_OFD_OFDCR1_OFDWEN_ENABLE;
}
 
/*--------------------------------------------------*/
/**
  * @brief  OFD Detection Disable.
  * @param  p_reg   :Register Base Address.
  * @param  -
  * @return -
  * @retval -
  * @note   The used register.
  * | Register  | Bit Symbol |
  * | :---      | :---       |
  * | OFDCR2    | :---       |
  * |           | OFDEN      |
  */
/*--------------------------------------------------*/
void REG_OFDEN_disable(TSB_OFD_TypeDef *p_reg)
{
    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
#ifdef DEBUG
    /* Check the REG_OFD_NULL of address. */
    assert_param(IS_POINTER_NOT_NULL(p_reg));
#endif /* #ifdef DEBUG */
    /*--- [OFDCR]<OUTEN> ---*/
    /*------------------------------*/
    /*  Register Set                */
    /*------------------------------*/
    p_reg->CR2 = REG_OFD_OFDCR2_OFDEN_DISABLE;
}
/*--------------------------------------------------*/
/**
  * @brief  OFD Detection Enablel.
  * @param  p_reg   :Register Base Address.
  * @param  -
  * @return -
  * @retval -
  * @note   The used register.
  * | Register  | Bit Symbol |
  * | :---      | :---       |
  * | OFDCR2    | :---       |
  * |           | OFDEN      |
  */
/*--------------------------------------------------*/
void REG_OFDEN_enable(TSB_OFD_TypeDef *p_reg)
{
    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
#ifdef DEBUG
    /* Check the REG_OFD_NULL of address. */
    assert_param(IS_POINTER_NOT_NULL(p_reg));
#endif /* #ifdef DEBUG */
    /*--- [OFDCR]<OUTEN> ---*/
    /*------------------------------*/
    /*  Register Set                */
    /*------------------------------*/
    p_reg->CR2 = REG_OFD_OFDCR2_OFDEN_ENABLE;
}

/*--------------------------------------------------*/
/**
  * @brief  Set Value Detect Minimum Frequency for EHOSC.
  * @param  p_reg   :Register Base Address.
  * @param  param   :Set Value
  * @return -
  * @retval -
  * @note   The used register.
  * | Register  | Bit Symbol |
  * | :---      | :---       |
  * | OFDMN0    | :---       |
  * |           | OFDMN0     |
  */
/*--------------------------------------------------*/
void REG_OFDMN0_set(TSB_OFD_TypeDef *p_reg, uint32_t param)
{
    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
#ifdef DEBUG
    /* Check the REG_OFD_NULL of address. */
    assert_param(IS_POINTER_NOT_NULL(p_reg));
#endif /* #ifdef DEBUG */
    /*--- [OFDMN0] ---*/
    /*------------------------------*/
    /*  Register Set                */
    /*------------------------------*/
    p_reg->MN0 = param;
}

/*--------------------------------------------------*/
/**
  * @brief  Set Value Detect Minimum Frequency for fc.
  * @param  p_reg   :Register Base Address.
  * @param  param   :Set Value
  * @return -
  * @retval -
  * @note   The used register.
  * | Register  | Bit Symbol |
  * | :---      | :---       |
  * | OFDM1     | :---       |
  * |           | OFDMN1     |
  */
/*--------------------------------------------------*/
void REG_OFDMN1_set(TSB_OFD_TypeDef *p_reg, uint32_t param)
{
    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
#ifdef DEBUG
    /* Check the REG_OFD_NULL of address. */
    assert_param(IS_POINTER_NOT_NULL(p_reg));
#endif /* #ifdef DEBUG */
    /*--- [OFDMN0] ---*/
    /*------------------------------*/
    /*  Register Set                */
    /*------------------------------*/
    p_reg->MN1 = param;
}

/*--------------------------------------------------*/
/**
  * @brief  Set Value Detect Maxmun Frequency for EHOSC.
  * @param  p_reg   :Register Base Address.
  * @param  param   :Set Value
  * @return -
  * @retval -
  * @note   The used register.
  * | Register  | Bit Symbol |
  * | :---      | :---       |
  * | OFDMN0    | :---       |
  * |           | OFDMN0     |
  */
/*--------------------------------------------------*/
void REG_OFDMX0_set(TSB_OFD_TypeDef *p_reg, uint32_t param)
{
    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
#ifdef DEBUG
    /* Check the REG_OFD_NULL of address. */
    assert_param(IS_POINTER_NOT_NULL(p_reg));
#endif /* #ifdef DEBUG */
    /*--- [OFDMN0] ---*/
    /*------------------------------*/
    /*  Register Set                */
    /*------------------------------*/
    p_reg->MX0 = param;
}

/*--------------------------------------------------*/
/**
  * @brief  Set Value Detect Maxmun Frequency for fc.
  * @param  p_reg   :Register Base Address.
  * @param  param   :Set Value
  * @return -
  * @retval -
  * @note   The used register.
  * | Register  | Bit Symbol |
  * | :---      | :---       |
  * | OFDM1     | :---       |
  * |           | OFDMN1     |
  */
/*--------------------------------------------------*/
void REG_OFDMX1_set(TSB_OFD_TypeDef *p_reg, uint32_t param)
{
    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
#ifdef DEBUG
    /* Check the REG_OFD_NULL of address. */
    assert_param(IS_POINTER_NOT_NULL(p_reg));
#endif /* #ifdef DEBUG */
    /*--- [OFDMN0] ---*/
    /*------------------------------*/
    /*  Register Set                */
    /*------------------------------*/
    p_reg->MX1 = param;
}

/*--------------------------------------------------*/
/**
  * @brief  OFD RESET Disable.
  * @param  p_reg   :Register Base Address.
  * @param  -
  * @return -
  * @retval -
  * @note   The used register.
  * | Register  | Bit Symbol |
  * | :---      | :---       |
  * | OFDRST    | :---       |
  * |           | OFDRSTEN   |
  */
/*--------------------------------------------------*/
void REG_OFDRST_disable(TSB_OFD_TypeDef *p_reg)
{
    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
#ifdef DEBUG
    /* Check the REG_OFD_NULL of address. */
    assert_param(IS_POINTER_NOT_NULL(p_reg));
#endif /* #ifdef DEBUG */
    /*--- [OFDCR]<OUTEN> ---*/
    /*------------------------------*/
    /*  Register Set                */
    /*------------------------------*/
    p_reg->RST = REG_OFD_OFDRST_OFDRSTEN_DISABLE;
}
/*--------------------------------------------------*/
/**
  * @brief  OFD RESET Enable.
  * @param  p_reg   :Register Base Address.
  * @param  -
  * @return -
  * @retval -
  * @note   The used register.
  * | Register  | Bit Symbol |
  * | :---      | :---       |
  * | OFDRST    | :---       |
  * |           | OFDRSTEN   |
  */
/*--------------------------------------------------*/
void REG_OFDRST_enable(TSB_OFD_TypeDef *p_reg)
{
    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
#ifdef DEBUG
    /* Check the REG_OFD_NULL of address. */
    assert_param(IS_POINTER_NOT_NULL(p_reg));
#endif /* #ifdef DEBUG */
    /*--- [OFDCR]<OUTEN> ---*/
    /*------------------------------*/
    /*  Register Set                */
    /*------------------------------*/
    p_reg->RST = REG_OFD_OFDRST_OFDRSTEN_ENABLE;
}


/*--------------------------------------------------*/
/**
  * @brief  Get Value OFD Status Register.
  * @param  p_reg   :Register Base Address.
  * @param  status   : status value store address
  * @return -
  * @retval -
  * @note   The used register.
  * | Register  | Bit Symbol |
  * | :---      | :---       |
  * | OFDSTAT   | :---       |
  * |           | OFDBUSY    |
  * |           | FRQERR     |
  */
/*--------------------------------------------------*/
void REG_OFDSTAT_get(TSB_OFD_TypeDef *p_reg, uint32_t *status)
{
    uint32_t value = 0U;
    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
#ifdef DEBUG
    /* Check the REG_OFD_NULL of address. */
    assert_param(IS_POINTER_NOT_NULL(p_reg));
#endif /* #ifdef DEBUG */
    /*--- [NFCKCR]<NFCKS> ---*/
    /*------------------------------*/
    /*  Register Set                */
    /*------------------------------*/
    value = p_reg->STAT;
    *status = value;
}

/*--------------------------------------------------*/
/**
  * @brief  Set Value Detect Clock.
  * @param  p_reg   :Register Base Address.
  * @param  param   :@ref OFDMON_OFDMON.
  * @return -
  * @retval -
  * @note   The used register.
  * | Register  | Bit Symbol |
  * | :---      | :---       |
  * | OFDMON    | :---       |
  * |           | OFDMON     |
  */
/*--------------------------------------------------*/
void REG_OFDMON_set(TSB_OFD_TypeDef *p_reg, uint32_t param)
{
    /*------------------------------*/
    /*  Parameter Check             */
    /*------------------------------*/
#ifdef DEBUG
    /* Check the REG_OFD_NULL of address. */
    assert_param(IS_POINTER_NOT_NULL(p_reg));
    assert_param(check_param_OFDMON_ST(param));
#endif /* #ifdef DEBUG */
    /*--- [OFDMON] ---*/
    /*------------------------------*/
    /*  Register Set                */
    /*------------------------------*/
    p_reg->MON = param;
}
/**
 *  @}
 */ /* End of group OFD_Exported_functions */

/**
 *  @}
 */ /* End of group OFD */

/**
 *  @} 
 */ /* End of group Periph_Driver */

#endif /* defined(__OFD_A_H)  */
#ifdef __cplusplus
}
#endif /* __cplusplus */


