/** 
 *******************************************************************************
 * @file    ofd_a.h
 * @brief   This file provides all the functions prototypes for A-OFD.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */
/*------------------------------------------------------------------------------*/
/*  Define to prevent recursive inclusion                                       */
/*------------------------------------------------------------------------------*/
#ifndef __OFD_A_H
#define __OFD_A_H

#ifdef __cplusplus
extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "bsp_com.h"

/**
 *  @addtogroup Periph_Driver Peripheral Driver
 *  @{
 */

/** 
 *  @addtogroup OFD
 *  @brief      OFD Driver.
 *  @{
 */
/*------------------------------------------------------------------------------*/
/*  Macro Function                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup OFD_Exported_macro
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group OFD_Exported_macro */


/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup OFD_Exported_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group OFD_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup OFD_Exported_define
 *  @{
 */

/** ---------------------------------------
 *  @defgroup OFDCR1 OFDCR1
 *  @brief    OFD Control Register 1.
 *  @{
 */

/** 
 *  @defgroup OFDCR1_OFDWEN OFDWEN
 *  @brief    [Bit7:0]: Register Write Enable/Disable Control.
 *  @{
 */
#define REG_OFD_OFDCR1_OFDWEN_DISABLE        ((uint32_t)0x00000006)        /*!< Register Write Disable.     */
#define REG_OFD_OFDCR1_OFDWEN_ENABLE         ((uint32_t)0x000000F9)        /*!< Register Write Enable.      */
/**
 *  @}
 */ /* End of group OFDCR1_OFDWEN */

/**
 *  @}
 */ /* End of group OFDCR1 */
/** ---------------------------------------
 *  @defgroup OFDCR2 OFDCR2
 *  @brief    OFD Control Register 2.
 *  @{
 */

/** 
 *  @defgroup OFDCR2_OFDEN OFDEN
 *  @brief    [Bit7:0]: Frequency Detection Enable/Disable Control.
 *  @{
 */
#define REG_OFD_OFDCR2_OFDEN_DISABLE         ((uint32_t)0x00000000)        /*!< Frequency Detection Disable.  */
#define REG_OFD_OFDCR2_OFDEN_ENABLE          ((uint32_t)0x000000E4)        /*!< Frequency Detection Enable.   */
/**
 *  @}
 */ /* End of group OFDCR2_OFDEN */
/**
 *  @}
 */ /* End of group OFDCR2 */
/** ---------------------------------------
 *  @defgroup OFDRST OFDRST
 *  @brief    OFD RESET Control Register.
 *  @{
 */

/** 
 *  @defgroup OFDRST_OFDRSTEN OFDRSTEN
 *  @brief    [Bit0]: RESET Enable/Disable Control.
 *  @{
 */
#define REG_OFD_OFDRST_OFDRSTEN_DISABLE      ((uint32_t)0x00000000)        /*!< RESET Disable.              */
#define REG_OFD_OFDRST_OFDRSTEN_ENABLE       ((uint32_t)0x00000001)        /*!< RESET Enable.               */
/**
 *  @}
 */ /* End of group OFDCR2_OFD2EN */
 /**
 *  @}
 */ /* End of group OFDRST */

/** ---------------------------------------
 *  @defgroup OFDSTAT OFDSTAT
 *  @brief    OFD Status Register.
 *  @{
 */

/** 
 *  @defgroup OFDSTAT_OFDBUSY OFDBUSY
 *  @brief    [Bit1]: ODD Running status.
 *  @{
 */
#define REG_OFD_OFDSTAT_OFDBUSY_MASK         ((uint32_t)0x00000002)        /*!< For bit MASK.                 */
#define REG_OFD_OFDSTAT_OFDBUSY_SUSPENDED    ((uint32_t)0x00000000)        /*!< OFD Susupended.               */
#define REG_OFD_OFDSTAT_OFDBUSY_RUNNING      ((uint32_t)0x00000002)        /*!< OFD Running.                  */
/**
 *  @}
 */ /* End of group OFDSTAT_OFDBUSY */
/** 
 *  @defgroup OFDSTAT_FRQERR FRQERR
 *  @brief    [Bit0]: ODD Error Detection Flag.
 *  @{
 */
#define REG_OFD_OFDSTAT_FRQERR_MASK          ((uint32_t)0x00000001)        /*!< For bit MASK.                 */
#define REG_OFD_OFDSTAT_FRQERR_NOERROR       ((uint32_t)0x00000000)        /*!< Not Error occurred.           */
#define REG_OFD_OFDSTAT_FRQERR_ERROR         ((uint32_t)0x00000001)        /*!< Error occurred.               */
/**
 *  @}
 */ /* End of group OFDSTAT_OFDBUSY */
 /**
 *  @}
 */ /* End of group OFDSTAT */
/** ---------------------------------------
 *  @defgroup OFDMON OFDMON
 *  @brief    OFD Detection Monitor Clock Setting.
 *  @{
 */

/** 
 *  @defgroup OFDMON_OFDMON OFDMON
 *  @brief    [Bit0]: Frequency Detection Enable/Disable Control.
 *  @{
 */
#define REG_OFD_OFDMON_OFDMON_EHOSC           ((uint32_t)0x00000000)        /*!< Monitor Clock for EHOSC.      */
#define REG_OFD_OFDMON_OFDMON_FC              ((uint32_t)0x00000001)        /*!< Monitor Clock for fc.         */
/**
 *  @}
 */ /* End of group OFDMON_OFDMON */
 /**
 *  @}
 */ /* End of group OFDMON */
/** 
 *  @}
 */ /* End of group OFD_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup OFD_Exported_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group OFD_Exported_define */

/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup OFD_Exported_typedef
 *  @{
 */
/*----------------------------------*/
/** 
 * @brief OFD Control structure definition.
 */
/*----------------------------------*/
typedef struct {
    uint32_t mn0;            /*!< FUNCTION  :Minimum Frequency Detection Set For EHOSC. */

    uint32_t mn1;            /*!< FUNCTION  :Minimum Frequency Detection Set For fc.    */

    uint32_t mx0;            /*!< FUNCTION  :Maxmum Frequency Detection Set For EHOSC.  */

    uint32_t mx1;            /*!< FUNCTION  :Maxmum Frequency Detection Set For fc.     */

} REG_OFD_t;


/**
 *  @}
 */ /* End of group OFD_Exported_typedef */


/*------------------------------------------------------------------------------*/
/*  Functions                                                                   */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup OFD_Exported_functions
 *  @{
 */
/* NFCKCR */
void REG_OFDWEN_enable(TSB_OFD_TypeDef *p_reg);
void REG_OFDWEN_disable(TSB_OFD_TypeDef *p_reg);
void REG_OFDEN_enable(TSB_OFD_TypeDef *p_reg);
void REG_OFDEN_disable(TSB_OFD_TypeDef *p_reg);
void REG_OFDMN0_set(TSB_OFD_TypeDef *p_reg, uint32_t param);
void REG_OFDMN1_set(TSB_OFD_TypeDef *p_reg, uint32_t param);
void REG_OFDMX0_set(TSB_OFD_TypeDef *p_reg, uint32_t param);
void REG_OFDMX1_set(TSB_OFD_TypeDef *p_reg, uint32_t param);
void REG_OFDRST_enable(TSB_OFD_TypeDef *p_reg);
void REG_OFDRST_disable(TSB_OFD_TypeDef *p_reg);
void REG_OFDSTAT_get(TSB_OFD_TypeDef *p_reg, uint32_t *status);
void REG_OFDMON_set(TSB_OFD_TypeDef *p_reg, uint32_t param);

/** 
 *  @}
 */ /* End of group OFD_Exported_functions */

/**
 *  @}
 */ /* End of group OFD */

/**
 *  @} 
 */ /* End of group Periph_Driver */

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __OFD_A_H */


