/** 
 *******************************************************************************
 * @file    ramp_a.h
 * @brief   This file provides all the functions prototypes for RAM PARITY.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */
/*------------------------------------------------------------------------------*/
/*  Define to prevent recursive inclusion                                       */
/*------------------------------------------------------------------------------*/
#ifndef __RAMP_A_H
#define __RAMP_A_H

#ifdef __cplusplus
extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "bsp_com.h"

/**
 *  @addtogroup Periph_Driver Peripheral Driver
 *  @{
 */

/** 
 *  @defgroup RAMP RAMP
 *  @brief    RAMP Driver.
 *  @{
 */
/*------------------------------------------------------------------------------*/
/*  Macro Function                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup RAMP_Exported_macro
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group RAMP_Exported_macro */


/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup RAMP_Exported_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group RAMP_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup RAMP_Exported_define
 *  @{
 */

/** ---------------------------------------
 *  @defgroup RPARCTL RPARCTL
 *  @brief    RAM PARITY Control Register.
 *  @{
 */

/** 
 *  @defgroup RPARCTL_RPARF RPARF
 *  @brief    [Bit:1]: PARITY Error Interrupt Control.
 *  @{
 */
#define REG_RPAR_RPARCTL_RPARF_MASK          ((uint32_t)0x00000002)        /*!< for Bit Mask.  */
#define REG_RPAR_RPARCTL_RPARF_DISABLE       ((uint32_t)0x00000000)        /*!< Error Interrupt Disable.       */
#define REG_RPAR_RPARCTL_RPARF_ENABLE        ((uint32_t)0x00000002)        /*!< Error Interrupt Enable.        */
/**
 *  @}
 */ /* End of group RPARCTL_RPARF */

/** 
 *  @defgroup RPARCTL_RPAREN RPAREN
 *  @brief    [Bit:1]: PARITY Error Detection Control.
 *  @{
 */
#define REG_RPAR_RPARCTL_RPAREN_MASK         ((uint32_t)0x00000001)        /*!< for Bit Mask.  */
#define REG_RPAR_RPARCTL_RPAREN_DISABLE      ((uint32_t)0x00000000)        /*!< Error Detection Disable.       */
#define REG_RPAR_RPARCTL_RPAREN_ENABLE       ((uint32_t)0x00000001)        /*!< Error Detection Enable.        */
/**
 *  @}
 */ /* End of group RPARCTL_RPAREN */

/**
 *  @}
 */ /* End of group RPARCTL */


/** ---------------------------------------
 *  @defgroup RPARST RPARST
 *  @brief    RAM PARITY Status Register.
 *  @{
 */

/** 
 *  @defgroup RPARST_RPARFGx RPARFGx
 *  @brief    [Bit7-0]: RAM Parity Error Status Flag.
 *  @{
 */
#define REG_RPAR_RPARST_RPARFG7_MASK         ((uint32_t)0x00000080)        /*!< RAM Area 7 Satus Flag for Bit MASK.  */
#define REG_RPAR_RPARST_RPARFG6_MASK         ((uint32_t)0x00000040)        /*!< RAM Area 6 Satus Flag for Bit MASK.  */
#define REG_RPAR_RPARST_RPARFG5_MASK         ((uint32_t)0x00000020)        /*!< RAM Area 5 Satus Flag for Bit MASK.  */
#define REG_RPAR_RPARST_RPARFG4_MASK         ((uint32_t)0x00000010)        /*!< RAM Area 4 Satus Flag for Bit MASK.  */
#define REG_RPAR_RPARST_RPARFG3_MASK         ((uint32_t)0x00000008)        /*!< RAM Area 3 Satus Flag for Bit MASK.  */
#define REG_RPAR_RPARST_RPARFG2_MASK         ((uint32_t)0x00000004)        /*!< RAM Area 2 Satus Flag for Bit MASK.  */
#define REG_RPAR_RPARST_RPARFG1_MASK         ((uint32_t)0x00000002)        /*!< RAM Area 1 Satus Flag for Bit MASK.  */
#define REG_RPAR_RPARST_RPARFG0_MASK         ((uint32_t)0x00000001)        /*!< RAM Area 0 Satus Flag for Bit MASK.  */
/**
 *  @}
 */ /* End of group RPARST_RPARFGx */


/** 
 *  @defgroup RPARCLR_RPARCLRx RPARCLRx
 *  @brief    [Bit7-0]: RAM Parity Error Status Flag.
 *  @{
 */
#define REG_RPAR_RPARST_RPARCLR7_CLR         ((uint32_t)0x00000080)        /*!< RAM Area 7 Satus Flag Clear.       */
#define REG_RPAR_RPARST_RPARCLR6_CLR         ((uint32_t)0x00000040)        /*!< RAM Area 6 Satus Flag Clear.       */
#define REG_RPAR_RPARST_RPARCLR5_CLR         ((uint32_t)0x00000020)        /*!< RAM Area 5 Satus Flag Clear.       */
#define REG_RPAR_RPARST_RPARCLR4_CLR         ((uint32_t)0x00000010)        /*!< RAM Area 4 Satus Flag Clear.       */
#define REG_RPAR_RPARST_RPARCLR3_CLR         ((uint32_t)0x00000008)        /*!< RAM Area 3 Satus Flag Clear.       */
#define REG_RPAR_RPARST_RPARCLR2_CLR         ((uint32_t)0x00000004)        /*!< RAM Area 2 Satus Flag Clear.       */
#define REG_RPAR_RPARST_RPARCLR1_CLR         ((uint32_t)0x00000002)        /*!< RAM Area 1 Satus Flag Clear.       */
#define REG_RPAR_RPARST_RPARCLR0_CLR         ((uint32_t)0x00000001)        /*!< RAM Area 0 Satus Flag Clear.       */
/**
 *  @}
 */ /* End of group RPARCLR_RPARCLRx */

/**
 *  @}
 */ /* End of group RPARST */

/** 
 *  @}
 */ /* End of group RAMP_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup RAMP_Exported_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group RAMP_Exported_define */

/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup RAMP_Exported_typedef
 *  @{
 */

/* no define */

/**
 *  @}
 */ /* End of group RAMP_Exported_typedef */


/*------------------------------------------------------------------------------*/
/*  Functions                                                                   */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup RAMP_Exported_functions
 *  @{
 */
/* RPARCTL */
void REG_RPARF_disable(TSB_RPAR_TypeDef *p_reg);
void REG_RPARF_enable(TSB_RPAR_TypeDef *p_reg);
void REG_RPAREN_disable(TSB_RPAR_TypeDef *p_reg);
void REG_RPAREN_enable(TSB_RPAR_TypeDef *p_reg);
/* RPARST */
uint32_t REG_RPARFGx_get(TSB_RPAR_TypeDef *p_reg);
/* RPARCLR */
void REG_RPARCLR_clear(TSB_RPAR_TypeDef *p_reg, uint32_t area);
/* RPAREADx */
uint32_t REG_RPAREADx_get(TSB_RPAR_TypeDef *p_reg, uint32_t area);
/** 
 *  @}
 */ /* End of group RAMP_Exported_functions */

/**
 *  @}
 */ /* End of group RAMP */

/**
 *  @} 
 */ /* End of group Periph_Driver */

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __RAMP_A_H */


