/**
 *******************************************************************************
 * @file    siwdt_a.c
 * @brief   This file provides API functions for SIWDT.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */

#ifdef __cplusplus
 extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "siwdt.h"

#if defined(__SIWDT_A_H)
/**
 *  @addtogroup Periph_Driver Peripheral Driver
 *  @{
 */

/** 
 *  @defgroup SIWDT SIWDT
 *  @brief    SIWDT Driver.
 *  @{
 */
/*------------------------------------------------------------------------------*/
/*  Macro Function                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup SIWDT_Private_macro
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group SIWDT_Private_macro */


/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup SIWDT_Private_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group SIWDT_Private_define */

/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup SIWDT_Private_define
 *  @{
 */

/** 
 *  @defgroup Null Null Pointer
 *  @brief    Null Pointer.
 *  @{
 */
#define REG_SIWDT_NULL                  ((void *)0)
/**
 *  @}
 */ /* End of group Null */

/** 
 *  @defgroup CheckParamResult Parameter Check Result
 *  @brief    Whether the parameter is specified or not.
 *  @{
 */
#define REG_SIWDT_PARAM_OK              ((int32_t)1)              /*!< Parameter is valid(specified).         */
#define REG_SIWDT_PARAM_NG              ((int32_t)0)              /*!< Parameter is invalid(not specified).   */
/**
 *  @}
 */ /* End of name Parameter CheckParamResult */


/** 
 *  @}
 */ /* End of group SIWDT_Private_define */


/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup SIWDT_Private_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group SIWDT_Private_define */


/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup SIWDT_Private_typedef
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group SIWDT_Private_typedef */

/*------------------------------------------------------------------------------*/
/*  Private Member                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup SIWDT_Private_variables
 *  @{
 */

/* no define */

/**
 *  @}
 */ /* End of group SIWDT_Private_variables */


/*------------------------------------------------------------------------------*/
/*  Private Function                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup SIWDT_Private_fuctions
 *  @{
 */

/* No define */

/**
 *  @}
 */ /* End of group SIWDT_Private_fuctions */


/*------------------------------------------------------------------------------*/
/*  Public Function                                                             */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup SIWDT_Exported_functions
 *  @{
 */

/*--------------------------------------------------*/
/** 
  * @brief  WDT_Configure
  * @param  p_reg   :Register Base Address.
  * @return -
  * @retval -
  * @note   -
  */
/*--------------------------------------------------*/
void wdt_config(TSB_SIWD_TypeDef *p_reg)
{
  p_reg->MOD = SIWDxMOD_INIT;
}


/*--------------------------------------------------*/
/** 
  * @brief  WDT Disable
  * @param  p_reg   :Register Base Address.
  * @return -
  * @retval -
  * @note   -
  */
/*--------------------------------------------------*/
void wdt_disable(TSB_SIWD_TypeDef *p_reg)
{
    p_reg->EN = SIWDxEN_WDTE_RW_DISABLE;
    p_reg->CR = SIWDxCR_WDCR_W_DISABLE;
}


/*--------------------------------------------------*/
/** 
  * @brief  WDT Enable
  * @param  p_reg   :Register Base Address.
  * @return -
  * @retval -
  * @note   -
  */
/*--------------------------------------------------*/
void wdt_enable(TSB_SIWD_TypeDef *p_reg)
{
    p_reg->EN = SIWDxEN_WDTE_RW_ENABLE;
}

/*--------------------------------------------------*/
/** 
  * @brief  WDT Clear
  * @param  p_reg   :Register Base Address.
  * @return -
  * @retval -
  * @note   -
  */
/*--------------------------------------------------*/
void wdt_clear(TSB_SIWD_TypeDef *p_reg)
{
    p_reg->CR = SIWDxCR_WDCR_W_CLEAR;
}


/**
 *  @}
 */ /* End of group SIWDT_Exported_functions */

/**
 *  @}
 */ /* End of group SIWDT */

/**
 *  @} 
 */ /* End of group Periph_Driver */

#endif /* defined(__SIWDT_A_H)  */
#ifdef __cplusplus
}
#endif /* __cplusplus */


