/** 
 *******************************************************************************
 * @file    siwdt_a.h
 * @brief   This file provides all the functions prototypes for SIWDT.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */
/*------------------------------------------------------------------------------*/
/*  Define to prevent recursive inclusion                                       */
/*------------------------------------------------------------------------------*/
#ifndef __SIWDT_A_H
#define __SIWDT_A_H

#ifdef __cplusplus
extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "bsp_com.h"

/**
 *  @addtogroup Periph_Driver Peripheral Driver
 *  @{
 */

/** 
 *  @defgroup SIWDT SIWDT
 *  @brief    SIWDT Driver.
 *  @{
 */
/*------------------------------------------------------------------------------*/
/*  Macro Function                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup SIWDT_Exported_macro
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group SIWDT_Exported_macro */


/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup SIWDT_Exported_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group SIWDT_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup SIWDT_Exported_define
 *  @{
 */


/** 
 *  @defgroup  SIWDxEN  SIWDxEN Register
 *  @brief     WD Enable Register.
 *  @{
 */
/* WDTE */
#define SIWDxEN_WDTE_RW_DISABLE         ((uint32_t)0x00000000)    /*!< WDTE  :[R/W] :Disable    */
#define SIWDxEN_WDTE_RW_ENABLE          ((uint32_t)0x00000001)    /*!< WDTE  :[R/W] :Enable     */
/* WDCR */
#define SIWDxCR_WDCR_W_DISABLE          ((uint32_t)0x000000B1)    /*!< WDCR  :[W] :Disable      */
#define SIWDxCR_WDCR_W_CLEAR            ((uint32_t)0x0000004E)    /*!< WDCR  :[W] :Clear        */
/** 
 *  @}
 */ /* End of group SIWDxEN */
 
/** 
 *  @defgroup  SIWDxMOD  SIWDxMOD Register
 *  @brief     WD Mode Register.
 *  @{
 */
/* WDTE */
#define SIWDxMOD_INIT                   ((uint32_t)0x00000500)    /*!< WDCLS=00,WDTP=101,WDCWD=00,INTF=0,RESCR=0    */
/** 
 *  @}
 */ /* End of group SIWDxMOD */


/** 
 *  @}
 */ /* End of group SIWDT_Exported_define */


/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup SIWDT_Exported_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group SIWDT_Exported_define */

/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup SIWDT_Exported_typedef
 *  @{
 */

/**
 *  @}
 */ /* End of group SIWDT_Exported_typedef */


/*------------------------------------------------------------------------------*/
/*  Functions                                                                   */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup SIWDT_Exported_functions
 *  @{
 */
void wdt_config(TSB_SIWD_TypeDef *p_reg);
void wdt_disable(TSB_SIWD_TypeDef *p_reg);
void wdt_enable(TSB_SIWD_TypeDef *p_reg);
void wdt_clear(TSB_SIWD_TypeDef *p_reg);


/** 
 *  @}
 */ /* End of group SIWDT_Exported_functions */

/**
 *  @}
 */ /* End of group SIWDT */

/**
 *  @} 
 */ /* End of group Periph_Driver */

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __SIWDT_A_H */


