/**
 *******************************************************************************
 * @file    trm_b.c
 * @brief   This file provides API functions for TRM.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */

#ifdef __cplusplus
 extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "trm.h"

#if defined(__TRM_B_H)
/**
 *  @addtogroup Periph_Driver Peripheral Driver
 *  @{
 */

/** 
 *  @addtogroup TRM
 *  @brief      TRM Driver.
 *  @{
 */
/*------------------------------------------------------------------------------*/
/*  Macro Function                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup TRM_Private_macro
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group TRM_Private_macro */


/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup TRM_Private_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group TRM_Private_define */

/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup TRM_Private_define
 *  @{
 */

#define TRMOSCPRO_ENABLE           (0x000000C1UL)      /* Writing register control enable. */
#define TRMOSCPRO_DISABLE          (0x00000000UL)      /* Writing register control disable. */
#define TRMOSCEN_MASK              (0x00000001UL)      /* Trimming Control enable. */
#define TRIM_MASK                  (0x000001FEUL)      /* Trimming value mask. */

/** 
 *  @}
 */ /* End of group TRM_Private_define */


/*------------------------------------------------------------------------------*/
/*  Private Function                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup TRM_Private_fuctions
 *  @{
 */

/* no define */

/**
 *  @}
 */ /* End of group TRM_Private_fuctions */

/*------------------------------------------------------------------------------*/
/*  Public Function                                                             */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup TRM_Exported_functions
 *  @{
 */

/*--------------------------------------------------*/
/** 
  * @brief  Set TRM register
  * @param  TRMOSC Control Structure
  * @retval -
  * @note   -
  */
/*--------------------------------------------------*/
void SetTrmOsc(TRM_ControlTypeDef *ControlStruct)
{
    uint32_t tmp = 0;

    TSB_TRM->OSCPRO = TRMOSCPRO_ENABLE;
    /* OSCEN disable change to enable set OSCET1,OSCET2 */
    if((TSB_TRM->OSCEN == TRMOSC_CONTROL_DISABLE)
    &&(ControlStruct->TrimmingControl == TRMOSC_CONTROL_ENABLE))
    {
        TSB_TRM->OSCSET1 = TSB_TRM->OSCINIT1;
        TSB_TRM->OSCSET2 = TSB_TRM->OSCINIT2;
    }
    TSB_TRM->OSCEN  = ControlStruct->TrimmingControl;
    tmp = (ControlStruct->TrimmingValue << 1) & TRIM_MASK;
    TSB_TRM->OSCSET0 = tmp;
    TSB_TRM->OSCPRO = TRMOSCPRO_DISABLE;
}

/*--------------------------------------------------*/
/** 
  * @brief  Get Trimming Control Value
  * @param  -
  * @retval Trimming Control value
  * @note   -
  */
/*--------------------------------------------------*/
uint32_t GetTrimmingControlValue(void)
{
    return (TSB_TRM->OSCEN & TRMOSCEN_MASK);
}

/*--------------------------------------------------*/
/** 
  * @brief  Get Initial Trimming Value
  * @param  -
  * @retval Initial Trimming value
  * @note   -
  */
/*--------------------------------------------------*/
uint32_t GetInitTrimValue(void)
{
    return ((TSB_TRM->OSCINIT0 & TRIM_MASK) >> 1);
}

/*--------------------------------------------------*/
/** 
  * @brief  Get Seting Trimming value 
  * @param  -
  * @retval setting Trimming value 
  * @note   -
  */
/*--------------------------------------------------*/
uint32_t GetSetTrimValue(void)
{
    return ((TSB_TRM->OSCSET0 & TRIM_MASK) >> 1);
}

/**
 *  @}
 */ /* End of group TRM_Exported_functions */

/**
 *  @}
 */ /* End of group TRM */

/**
 *  @} 
 */ /* End of group Periph_Driver */

#endif /* defined(__TRM_B_H)  */
#ifdef __cplusplus
}
#endif /* __cplusplus */


