/** 
 *******************************************************************************
 * @file    trm_b.h
 * @brief   This file provides all the functions prototypes for TRM.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */
/*------------------------------------------------------------------------------*/
/*  Define to prevent recursive inclusion                                       */
/*------------------------------------------------------------------------------*/
#ifndef __TRM_B_H
#define __TRM_B_H

#ifdef __cplusplus
extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "bsp_com.h"

/**
 *  @addtogroup Periph_Driver Peripheral Driver
 *  @{
 */

/** 
 *  @addtogroup TRM
 *  @brief      TRM Driver.
 *  @{
 */
/*------------------------------------------------------------------------------*/
/*  Macro Function                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup TRM_Private_macro
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group TRM_Private_macro */


/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup TRM_Private_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group TRM_Private_define */


/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup TRM_Private_define
 *  @{
 */

/** 
 *  @defgroup TRM_Control  Trimming Control
 *  @brief    Trimming Control.
 *  @{
 */
#define  TRMOSC_CONTROL_ENABLE      (0x00000001UL)      /*!< Trimming Control enable   */
#define  TRMOSC_CONTROL_DISABLE     (0x00000000UL)      /*!< Trimming Control disable  */
/**
 *  @}
 */ /* End of group TRM_Control */

/** 
 *  @}
 */ /* End of group TRM_Private_define */

/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup TRM_Private_define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group TRM_Private_define */

/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup TRM_Private_typedef
 *  @{
 */
/*----------------------------------*/
/** 
 * @brief  TRM handle structure definenition.
*/
/*----------------------------------*/
typedef struct {
    uint32_t TrimmingControl;       /*!< Value to TRIMEN */
    uint32_t TrimmingValue;         /*!< Value to TRIMSETC */
} TRM_ControlTypeDef;

/**
 *  @}
 */ /* End of group TRM_Private_typedef */

/*------------------------------------------------------------------------------*/
/*  Functions                                                                   */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup TRM_Private_functions
 *  @{
 */

void SetTrmOsc(TRM_ControlTypeDef *ControlStruct);
uint32_t GetTrimmingControlValue(void);
uint32_t GetInitTrimValue(void);
uint32_t GetSetTrimValue(void);

/** 
 *  @}
 */ /* End of group TRM_Private_functions */

/**
 *  @}
 */ /* End of group TRM */

/**
 *  @} 
 */ /* End of group Periph_Driver */

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __TRM_B_H */

