/**
 *******************************************************************************
 * @file    fc_copy.c
 * @brief   This file provides API functions for fc_copy.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */

#ifdef __cplusplus
 extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "fc_copy.h"

#if defined(__FC_COPY_H)
/**
 *  @addtogroup Utility Utility
 *  @{
 */

/** 
 *  @addtogroup fc_copy
 *  @brief    fc_copy utility
 *  @{
 */

/*------------------------------------------------------------------------------*/
/*  Macro Function                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup fc_copy_Private_macro fc_copy Private Macro
 *  @{
 */

#if defined ( __CC_ARM   )      /* RealView Compiler */
extern uint32_t Load$$FLASH_CODE_RAM$$Base;
extern uint32_t Image$$FLASH_CODE_RAM$$Base;
extern uint32_t Load$$FLASH_CODE_RAM$$Length;

#elif defined ( __ICCARM__ )    /* IAR Compiler */
#pragma section = "FLASH_CODE_RAM"
#pragma section = "FLASH_CODE_ROM"
#endif

#if defined ( __CC_ARM   )      /* RealView Compiler */
#define FLASH_API_ROM           (uint32_t *)&Load$$FLASH_CODE_RAM$$Base
#define FLASH_API_RAM           (uint32_t *)&Image$$FLASH_CODE_RAM$$Base
#define SIZE_FLASH_API          (uint32_t)&Load$$FLASH_CODE_RAM$$Length



#elif defined ( __ICCARM__ )    /* IAR Compiler */
#define FLASH_API_ROM           ((uint32_t *)__section_begin("FLASH_CODE_ROM"))
#define FLASH_API_RAM           ((uint32_t *)__section_begin("FLASH_CODE_RAM"))
#define SIZE_FLASH_API          ((uint32_t)__section_size("FLASH_CODE_ROM"))

#endif

/** 
 *  @}
 */ /* End of group fc_copy_Private_macro */


/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup fc_copy_Private_define fc_copy Private Define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group fc_copy_Private_define */


/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup fc_copy_Private_define fc_copy Private Define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group fc_copy_Private_define */


/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup fc_copy_Private_define fc_copy Private Define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group fc_copy_Private_define */


/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup fc_copy_Private_typedef fc_copy Private Typedef
 *  @{
 */

/* no define */

/**
 *  @}
 */ /* End of group fc_copy_Private_typedef */


/*------------------------------------------------------------------------------*/
/*  Private Function                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup fc_copy_Private_fuctions fc_copy Private Fuctions
 *  @{
 */

static void Copy_Routine(uint32_t * dest, uint32_t * source, uint32_t size);

/*--------------------------------------------------*/
/** 
  * @brief  copy 32-bit data from source to dest
  * @param  the address of source and dast, the data size
  * @retval none.
  * @note   -
  */
/*--------------------------------------------------*/
static void Copy_Routine(uint32_t * dest, uint32_t * source, uint32_t size)
{
    uint32_t *dest_addr, *source_addr, tmpsize;
    uint32_t i, tmps, tmpd, mask;

    dest_addr = dest;
    source_addr = source;

    tmpsize = size >> 2U;
    for (i = 0U; i < tmpsize; i++) {    /* 32bits copy */
        *dest_addr = *source_addr;
        dest_addr++;
        source_addr++;
    }
    if (size & 0x00000003U) {   /* if the last data size is not 0(maybe 1,2 or 3), copy the last data */
        mask = 0xFFFFFF00U;
        i = size & 0x00000003U;
        tmps = *source_addr;
        tmpd = *dest_addr;
        while (i - 1U) {
            mask = mask << 8U;
            i--;
        }
        tmps = tmps & (~mask);
        tmpd = tmpd & (mask);
        *dest_addr = tmps + tmpd;       /* 32bits copy, but only change the bytes need to be changed */
    } else {
        /* Do nothing */
    }
}
/**
 *  @}
 */ /* End of group fc_copy_Private_functions */

/*------------------------------------------------------------------------------*/
/*  Public Function                                                             */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup fc_copy_Exported_functions
 *  @{
 */
/*--------------------------------------------------*/
/** 
  * @brief  copy flash control functions.
  * @param  none.
  * @retval none.
  * @note   -
  */
/*--------------------------------------------------*/
void copy_fc_function(void)
{
    Copy_Routine(FLASH_API_RAM, FLASH_API_ROM, SIZE_FLASH_API);     /* copy flash API to RAM */
}

/**
 *  @}
 */ /* End of group fc_copy_Exported_functions */

/**
 *  @} 
 */ /* End of group fc_copy */

/**
 *  @} 
 */ /* End of group Utility */

#endif /* defined(__FC_COPY_H)  */

#ifdef __cplusplus
}
#endif /* __cplusplus */

