/**
 *******************************************************************************
 * @file    sys_timer.c
 * @brief   This file provides API functions for sys_timer.
 * @version V1.0.0
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */

#ifdef __cplusplus
 extern "C" {
#endif

/*------------------------------------------------------------------------------*/
/*  Includes                                                                    */
/*------------------------------------------------------------------------------*/
#include "sys_timer.h"

#if defined(__SYS_TIMER_H)
/**
 *  @addtogroup Utility Utility
 *  @{
 */

/** 
 *  @addtogroup sys_time
 *  @brief    sys_time utility
 *  @{
 */

/*------------------------------------------------------------------------------*/
/*  Macro Function                                                              */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup sys_time_Private_macro sys_time Private Macro
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group sys_time_Private_macro */


/*------------------------------------------------------------------------------*/
/*  Configuration                                                               */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup sys_time_Private_define sys_time Private Define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group sys_time_Private_define */


/*------------------------------------------------------------------------------*/
/*  Macro Definition                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup sys_time_Private_define sys_time Private Define
 *  @{
 */
/** 
 *  @defgroup wait Configuration
 *  @brief    wait Configuration.
 *  @{
 */
#define WAIT_UNIT_1US          ((uint32_t)(1000000))     /*!< 1S-1us transfor unit.   */
#define WAIT_FORLOOP_STEPS           ((uint32_t)(5))     /*!< for loop steps.         */
/** 
 *  @}
 */ /* End of group waitConfiguration */
 
/* no define */

/** 
 *  @}
 */ /* End of group sys_time_Private_define */


/*------------------------------------------------------------------------------*/
/*  Enumerated Type Definition                                                  */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup sys_time_Private_define sys_time Private Define
 *  @{
 */

/* no define */

/** 
 *  @}
 */ /* End of group sys_time_Private_define */


/*------------------------------------------------------------------------------*/
/*  Structure Definition                                                        */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup sys_time_Private_typedef sys_time Private Typedef
 *  @{
 */

/* no define */

/**
 *  @}
 */ /* End of group sys_time_Private_typedef */


/*------------------------------------------------------------------------------*/
/*  Private Function                                                            */
/*------------------------------------------------------------------------------*/
/** 
 *  @defgroup sys_time_Private_fuctions sys_time Private Fuctions
 *  @{
 */

static uint32_t tick;

/**
 *  @}
 */ /* End of group sys_time_Private_functions */

/*------------------------------------------------------------------------------*/
/*  Public Function                                                             */
/*------------------------------------------------------------------------------*/
/** 
 *  @addtogroup sys_time_Exported_functions
 *  @{
 */
/*--------------------------------------------------*/
/**
  * @brief     Increment a tick value.
  * @param     -
  * @retval    -
  * @note      Please call by user.
  * @note      In the sample, this variable is incremented each 1ms timer interrupt.
  */
/*--------------------------------------------------*/
void hal_inc_tick(void)
{
    tick++;
}

/*--------------------------------------------------*/
/** 
  * @brief  Provides a tick value.
  * @param  -
  * @return Tick value.
  * @retval -
  * @note   -
  */
/*--------------------------------------------------*/
uint32_t hal_get_tick(void)
{
    return(tick);
}

/*--------------------------------------------------*/
/** 
  * @brief  wait Function(us)
  * @param  uint32_t :count(unit:us).
  * @return void
  * @retval -
  * @note   -
  */
/*--------------------------------------------------*/
void wait(uint32_t count)
{
    uint32_t i,steps;

    /*-----------------------------------------*/
    /* step : 1000000us = fsys :1              */
    /* step = EOSC_SYS_CLOCK/1000000           */
    /*-----------------------------------------*/
    /* system core clock update */
    SystemCoreClockUpdate();
    steps = count*(SystemCoreClock/WAIT_UNIT_1US)/WAIT_FORLOOP_STEPS;

    for(i=0;i < steps; ++i){
        __NOP();
    }
}

/**
 *  @}
 */ /* End of group sys_time_Exported_functions */

/**
 *  @} 
 */ /* End of group sys_time */

/**
 *  @} 
 */ /* End of group Utility */

#endif /* defined(__SYS_TIMER_H)  */

#ifdef __cplusplus
}
#endif /* __cplusplus */

