// Grove-B（焦電型赤外線センサ）デモ用スケッチ（プログラム）
// Arduino IDE :ver 1.8.9 
// Date:2019.05.29    by M.T.
// ------------------------------------------------------
#include <MsTimer2.h>

#define ANALOG_PIN  A1
#define SAMPLING_RATE 100  // Hz
#define START_BYTE 0xFE
#define END_BYTE 0xFF
#define Ave 10

uint16_t data;        // raw data
uint8_t data_flag;

void getPulseWave() {
  data = 0;
  for(int i=0; i<Ave ;i++){
  data += analogRead(ANALOG_PIN);
  }
  data /= Ave;

  data_flag = 1;
}

void setup() {
  pinMode(13, OUTPUT);
  // set up serial communication
  Serial.begin(115200);
  
  // set up for sampling pulse wave
  data_flag = 0;
  // set function called every set interval ms
  MsTimer2::set(1000/SAMPLING_RATE, getPulseWave);
  // start timer interrupt  
  MsTimer2::start();          
}

void loop() {
  if(data_flag) {
    // transmit packets
    // START_BYTE | upper data 3 bits | lower data 7 bits | END_BYTE
    Serial.write(START_BYTE);
    Serial.write((data >> 7) & 0b00000111);
    Serial.write(data & 0b01111111);
    Serial.write(END_BYTE);
    //Serial.println(data);
    // clear flag
    data_flag = 0;
  }
}
