// Grove-D（Ultrasonic Sensor）Sketch for Demonstration
// Arduino IDE :ver 1.8.9 
// Date:2019.05.22    by M.T.
// ------------------------------------------------------

// 40kHz pulse period tuning NOP
#define NOP_A         \
    asm volatile(     \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
    );

#define NOP_B         \
    asm volatile(     \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \ 
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
    );

typedef union {
  unsigned int val;
  byte   binary[2];
} ad;

// SETUP -------------------------------
void setup() {
  pinMode(A3, OUTPUT);      // Pulse Output Pin(A3)
  Serial.begin(115200);     // Serial Open/baud rate(Max)
  delay(10);

  while(Serial.available() == 0) delay(10);   // Data waiting／synchronizing
  while(Serial.read() != '1') delay(10);

}


// Main --------------------------------
#define NUM 900       // Number of data samples／1 frame
void loop() {
  float temp, Vcc;
  unsigned long stime;
  ad  ad4[NUM];

  adcSetup(0x44);         // A/D setup

  noInterrupts();
  US_Pulse();             // 40kHz Pulses Output
  interrupts();

/*  
  temp = cpuTemp();                   // CPU temp. measuring
  Vcc  = cpuVcc();                    // Supply voltage measuring  
  Serial.print("CPU Temp= ");         // Output temp. to serial
  Serial.print(temp,1);
  Serial.print(", Vcc= ");            // Output supply voltage to serial
  Serial.println(Vcc,2);
*/

//stime = micros();
  for(int i=0; i<NUM; i++){           // A/D converting -- reflected wave taking in
    ad4[i].val = adc();
    delayMicroseconds(13);
  }
//Serial.println(micros()-stime);
  
  Serial.write(0xFF);                 // Data cueing sign
  Serial.write(0xFF);

//  if(Serial.available()>0){
    for(int i=0; i<NUM; i++){         // Data sending
      Serial.write(ad4[i].binary,2);
      delayMicroseconds(30);
    }
//  }
  delay(6);
}

// Below, fuction for measuring and cheking CPU temperature and supply voltage 

float cpuTemp(){                     // Function for measuring CPU temp.
  long sum=0;
  adcSetup(0xC8);                    // Vref=1.1V, input=ch8(Internal temp.)
  for(int n=0; n < 100; n++){
    sum += adc();                    // Read and integrate the value of adc
    delay(1);
  }
  return (sum /100.0 - 327.31)*0.82; // Calculate and return temperature. adjustment of offset value(-xxx.x) is required
}

float cpuVcc(){                      // Function for maesuring supply voltage(AVCC)
  long sum=0;
  adcSetup(0x4E);                    // Vref=AVcc, input=internal1.1V
  for(int n=0; n < 10; n++){
    sum += adc();                    // Read and integrate the value of adc
    delay(10);
  }
  return (1.08 * 10230.0)/sum;      // Calculate and return voltage
}

void adcSetup(byte data){           // Setup of AD converter
  ADMUX = data;                     // ADC Multiplexer Select /Vref & Input-Ch
  ADCSRA |= ( 1 << ADEN);           // ADC enable
  ADCSRA &= 0xf8;                   // Reset the AD converting clock
  ADCSRA |= 0x05;                   // Re-setup the AD converting clock　CK/32(26uS)
  delay(10);                        // Wait for stable operation
}

unsigned int adc(){                 // Read the value of ADC
  unsigned int dL, dH;
  ADCSRA |= ( 1 << ADSC);           // AD converting start
  while(ADCSRA & ( 1 << ADSC) ){    // Wait for converting finished
  }
  dL = ADCL;                        // Read out the LSB side 
  dH = ADCH;                        // MSB side
  return dL | (dH << 8);            // Return the value compounded to 10 bits
}

void US_Pulse() {                   // 40kHz pulse（10 waves）,Pin(A3)=PC3
    PORTC |= _BV(PC3);
    delayMicroseconds(13);
    NOP_A
    PORTC &= ~_BV(PC3);
    delayMicroseconds(13);
    NOP_B
    PORTC |= _BV(PC3);
    delayMicroseconds(13);
    NOP_A
    PORTC &= ~_BV(PC3);
    delayMicroseconds(13);
    NOP_B
    PORTC |= _BV(PC3);
    delayMicroseconds(13);
    NOP_A
    PORTC &= ~_BV(PC3);
    delayMicroseconds(13);
    NOP_B
    PORTC |= _BV(PC3);
    delayMicroseconds(13);
    NOP_A
    PORTC &= ~_BV(PC3);
    delayMicroseconds(13);
    NOP_B
    PORTC |= _BV(PC3);
    delayMicroseconds(13);
    NOP_A
    PORTC &= ~_BV(PC3);
    delayMicroseconds(13);
    NOP_B
    PORTC |= _BV(PC3);
    delayMicroseconds(13);
    NOP_A
    PORTC &= ~_BV(PC3);
    delayMicroseconds(13);
    NOP_B
    PORTC |= _BV(PC3);
    delayMicroseconds(13);
    NOP_A
    PORTC &= ~_BV(PC3);
    delayMicroseconds(13);
    NOP_B
    PORTC |= _BV(PC3);
    delayMicroseconds(13);
    NOP_A
    PORTC &= ~_BV(PC3);
    delayMicroseconds(13);
    NOP_B
    PORTC |= _BV(PC3);
    delayMicroseconds(13);
    NOP_A
    PORTC &= ~_BV(PC3);
    delayMicroseconds(13);
    NOP_B
    PORTC |= _BV(PC3);
    delayMicroseconds(13);
    NOP_A
    PORTC &= ~_BV(PC3);
}
