// Grove-D（超音波センサ）デモ用スケッチ（プログラム）
// Arduino IDE :ver 1.8.9 
// Date:2019.05.22    by M.T.
// ------------------------------------------------------

// 40kHzパルス周期調整用NOP
#define NOP_A         \
    asm volatile(     \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
    );

#define NOP_B         \
    asm volatile(     \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \ 
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
      "nop"   "\n\t"  \
    );

typedef union {
  unsigned int val;
  byte   binary[2];
} ad;

// SETUP -------------------------------
void setup() {
  pinMode(A3, OUTPUT);      // Pulse Output Pin(A3)
  Serial.begin(115200);     // Serial Open/baud rate(Max)
  delay(10);

  while(Serial.available() == 0) delay(10);   // データ通信開始待ち／同期
  while(Serial.read() != '1') delay(10);

}


// Main --------------------------------
#define NUM 900       // データサンプル数／1フレーム
void loop() {
  float temp, Vcc;
  unsigned long stime;
  ad  ad4[NUM];

  adcSetup(0x44);         // A/D setup

  noInterrupts();
  US_Pulse();             // 40kHz Pulses Output
  interrupts();

/*  
  temp = cpuTemp();                   // CPU温度測定
  Vcc  = cpuVcc();                    // 電源電圧測定  
  Serial.print("CPU Temp= ");         // シリアルに温度を出力
  Serial.print(temp,1);
  Serial.print(", Vcc= ");            // シリアルにVccを出力
  Serial.println(Vcc,2);
*/

//stime = micros();
  for(int i=0; i<NUM; i++){           // A/D変換 -- 反射波取込
    ad4[i].val = adc();
    delayMicroseconds(13);
  }
//Serial.println(micros()-stime);
  
  Serial.write(0xFF);                 // データの頭出し合図
  Serial.write(0xFF);

//  if(Serial.available()>0){
    for(int i=0; i<NUM; i++){         // データ送信
      Serial.write(ad4[i].binary,2);
      delayMicroseconds(30);
    }
//  }
  delay(6);
}

// 以下、CPU温度・電源電圧の測定・チェックに関する関数

float cpuTemp(){                     // CPU温度測定関数
  long sum=0;
  adcSetup(0xC8);                    // Vref=1.1V, input=ch8(内部温度)
  for(int n=0; n < 100; n++){
    sum += adc();                    // adcの値を読んで積分
    delay(1);
  }
  return (sum /100.0 - 327.31)*0.82; // 温度を計算して戻り値にする。オフセット値(-xxx.x)は要調整
}

float cpuVcc(){                      // 電源電圧(AVCC)測定関数
  long sum=0;
  adcSetup(0x4E);                    // Vref=AVcc, input=internal1.1V
  for(int n=0; n < 10; n++){
    sum += adc();                    // adcの値を読んで積分
    delay(10);
  }
  return (1.08 * 10230.0)/sum;      // 電圧を計算して戻り値にする
}

void adcSetup(byte data){           // ADコンバーターの設定
  ADMUX = data;                     // ADC Multiplexer Select /Vref & Input-Ch
  ADCSRA |= ( 1 << ADEN);           // ADC イネーブル
  ADCSRA &= 0xf8;                   // AD変換クロック・リセット
  ADCSRA |= 0x05;                   // AD変換クロック再設定　CK/32(26uS)
  delay(10);                        // 安定するまで待つ
}

unsigned int adc(){                 // ADCの値を読む
  unsigned int dL, dH;
  ADCSRA |= ( 1 << ADSC);           // AD変換開始
  while(ADCSRA & ( 1 << ADSC) ){    // 変換完了待ち
  }
  dL = ADCL;                        // LSB側読み出し 
  dH = ADCH;                        // MSB側
  return dL | (dH << 8);            // 10ビットに合成した値を返す
}

void US_Pulse() {                   // 40kHzパルス（10波分）,Pin(A3)=PC3
    PORTC |= _BV(PC3);
    delayMicroseconds(13);
    NOP_A
    PORTC &= ~_BV(PC3);
    delayMicroseconds(13);
    NOP_B
    PORTC |= _BV(PC3);
    delayMicroseconds(13);
    NOP_A
    PORTC &= ~_BV(PC3);
    delayMicroseconds(13);
    NOP_B
    PORTC |= _BV(PC3);
    delayMicroseconds(13);
    NOP_A
    PORTC &= ~_BV(PC3);
    delayMicroseconds(13);
    NOP_B
    PORTC |= _BV(PC3);
    delayMicroseconds(13);
    NOP_A
    PORTC &= ~_BV(PC3);
    delayMicroseconds(13);
    NOP_B
    PORTC |= _BV(PC3);
    delayMicroseconds(13);
    NOP_A
    PORTC &= ~_BV(PC3);
    delayMicroseconds(13);
    NOP_B
    PORTC |= _BV(PC3);
    delayMicroseconds(13);
    NOP_A
    PORTC &= ~_BV(PC3);
    delayMicroseconds(13);
    NOP_B
    PORTC |= _BV(PC3);
    delayMicroseconds(13);
    NOP_A
    PORTC &= ~_BV(PC3);
    delayMicroseconds(13);
    NOP_B
    PORTC |= _BV(PC3);
    delayMicroseconds(13);
    NOP_A
    PORTC &= ~_BV(PC3);
    delayMicroseconds(13);
    NOP_B
    PORTC |= _BV(PC3);
    delayMicroseconds(13);
    NOP_A
    PORTC &= ~_BV(PC3);
    delayMicroseconds(13);
    NOP_B
    PORTC |= _BV(PC3);
    delayMicroseconds(13);
    NOP_A
    PORTC &= ~_BV(PC3);
}
