// Grove-D（超音波センサ）デモ表示用スケッチ（プログラム）
// Processing:ver 3.5.3 
// Date:2019.05.22    by M.T.
// ------------------------------------------------------

import processing.serial.*;

//Serialクラスのインスタンス
Serial myPort;

//アナログ入力の数（１フレーム分）
int NUM = 900;

//Serialより読み込んだデータを格納する配列
int[] val = new int[NUM];
int  Detect;

//現在Serial信号を受信しているか
boolean running = false;

// 距離スケール算出
float  Tmp = 25.0;                // 温度・気温(℃)設定
float  Spd = 20.055 * pow(Tmp + 273.15, 0.5);  // 音速(m/sec)計算
float  Rft = 1000.0/Spd*2;        // 距離:1mでの反射時間(msec)
float  D1m = Rft*1000.0/40.1;     // 1mスケール=反射時間(1m)/データ周期:40.1uS

void setup() {
  //画面を生成
  size(900, 600);
  //フレームレート
  //frameRate(30);
  //ポート名を取得
  printArray(Serial.list());
  println("Select PortNumber :"); 
  //ポート名を指定 -- Arduinoの通信ポート名と合せる
  //コンソールに表示されたリストから、適合する番号を下行の配列インデックス[ ]に設定
  String portName = Serial.list()[0];
  // Serial start
  myPort = new Serial(this, portName, 115200);
  //myPort.clear();
  println("Speed of sound = " + Spd + "m/s");  
}

void draw() {
  //現在、データを受信中なら
  if (running) {
    for (int i=0; i<NUM; i++) { 
      //入力値から目標とする値をマッピング
      float targetVal = map(val[i], 0, 850, height, 0);

      //白い線で前の値を消す
      stroke(255);
      line(i, 0, i, height);
      //入力波形を表示
      stroke(63, 127, 255);
      line(i, height, i, targetVal);
    }
    
    stroke(0);
    fill(0);
    textSize(18);
    text("Distance >>",10,20);
    for (int i=1; i<7; i++) { 
      line(i*D1m, 25, i*D1m, height);
      text(i+"m", i*D1m-10, 20);
      for (int m = 5; m < height; m++){
        point((i-0.5)*D1m, m*5);
      }
    }

    fill(240);
    rect(580,40,280,40,10);
    fill(255,0,0);
    //ellipse(Detect, 30, 12, 7);
    rect(0,28,Detect,7);
    textSize(30);
    text( "Distance = " + nf(Detect/D1m, 1, 2) + "m",590,71);
  } else {
    //まだデータを受信していなかったら
    //画面をクリックするようにメッセージを出す
    background(255);
    fill(0);
    text("<< click on screen >>", 10, 20);
  }
}
int  index = 0;
//シリアル入力を検出した際に発生するイベント
void serialEvent(Serial myPort) {
  //シリアルバッファーにデータ入力（2byte,16bitデータ）があれば
  if (myPort.available() > 1) {
    //上位8bitを取得
    int  val_low = myPort.read();
    //print(val_low  + "\t");
    //下位8bitを取得
    int  val_high = myPort.read();
    //print(val_high  + "\t");
    val[index] = (val_high << 8) | val_low;

    if (index == NUM-1) {                // 全ての入力(1フレーム分)を処理したら
      //読み込み完了の合図を送る
      //myPort.write('1');
      Detect = findMaxPos(val);          // ピーク検知
      index = 0;
    } else if (val[index] == 0xFFFF) {   // データの頭出し
      index = 0;
    } else {
      index++;
    }

  }
}

// 反射波のピークを検知
int findMaxPos(int[] x) {
  int  tentativePos = 57;              // 直接音の回り込み区間（約40cm）を無効とする
  for(int i = 57; i<x.length; i++){
    if(x[tentativePos] < x[i]){
      tentativePos = i;
    }
  }
  return tentativePos;
}

//マウスが押されたら通信開始
void mousePressed() {
  //バッファ領域を空にする
  myPort.clear();
  //合図用データを送る
  myPort.write('1');

  background(255);
  running = true;
}
