//
// IH Cooker Sample Program
//


#ifndef _IIC_H_
#define _IIC_H_

#define sda_c	_pac0
#define sda		_pa0

#define scl_c   _pbc4
#define scl   	_pb4
#define DatHi()		sda_c=1
#define DatLo()		sda_c=0,sda=0

#define I2CSP				320    //16MHz
#define	I2CFAIL_CNT			10
#define	FRAME_END			0X7B
#define	DEVICE_ID			0X72
#define	COMMEND_INIT_ID		0X01
#define	COMMEND_WORK_ID		0X11

#define IIC_TIMEOUT			1000

typedef enum {

	ERROR_NO			= (u8)0x00,	
	ERROR_IGBT_OVER_OVP = (u8)0x01,
	ERROR_CIRCUIT		= (u8)0x02,
	ERROR_IGBT_OVER_TMP	= (u8)0x03,
	ERROR_IGBT_NTC		= (u8)0x04,
	ERROR_PAN_OVER_TMP	= (u8)0x05,
	ERROR_PAN_NTC		= (u8)0x06,
	ERROR_OCP			= (u8)0x07,
	ERROR_OVP			= (u8)0x08,
	ERROR_UVP			= (u8)0x09,
	ERROR_I2C 			= (u8)0x10,

} ErrorCode_TypeDef;

typedef enum{
	NO_PAN			= (bit)1,
	HAVE_PAN		= (bit)0
	
}CheckPan_TypeDef;

extern volatile u8 u8_I2c_WrRd_1ms;
extern volatile u8 u8_PowerStep_buf;
extern volatile u8 u8_ModeSet;
extern IH_Status_FLAG IH_Status_App;
extern ControlSet_Flag  ControlSet_App;

void IIC_Init();
void IIC();
u8 DataParity(u8 data);
void I2c_Cnt();

#endif
