//
// IH Cooker Sample Program
//

#include"Include.h"

void PPG_CONFIG()
{
	_ppgpc = 0B01010101;  //PPG output is active low
	_ppgc0 = 0B00100000;
	_ppgc1 = 0B10000000|(0x3f&C_PPG_DL);  // Select C0VO as INT00 source,Select trigger delay for PPG 
	_ppgc2 = 0b00001111;
	
	_ppgtex= 0B01010101;
	_ppgta = 150;
	_ppgtb = 150;
	_ppgtc = 150;
	_ppgtd = 150;
	_ppgsaen = 0;
	_pwlt = PWL_SET;
	_tmr1c = 0x00;
	_tmr1 = 256-30;

	_ppgatc0=0B11000000;
	_ppgatc1=0B10000010;
	_ppgatc2=0B00001010;
	_ppgtmc =0B00000010;

	_ppgtmr1=PPGTMR1;
	_ppgtmr2=PPGTMR2;
	_ppgtmr3=PPGTMR3;

	_ppghtmd=1;
	_ppgton=0;
	
}

void IGBT_PowerOn(void)
{
	volatile u16 PPGTB_Temp;
	PPG_CONFIG();
	PPGTA_copy=c_InitPPGT;
	while(_pst == 1) {}     //Wait PST bit low
	if(PPGTA_copy>255)
	{
		_ppgta8=1;
	}
	else
	{
		_ppgta8=0;
	}
	_ppgta=PPGTA_copy& 0XFF;
	
	PPGTB_Temp=PPGTA_copy+32;
	if(PPGTB_Temp>255)
	{
		_ppgtb8=1;
	}
	else
	{
		_ppgtb8=0;
	}
	_ppgtb=PPGTB_Temp& 0xff;
	bPowerState = 1;
	bStartPPG = 1;
}

void PowerOnProc()
{
	if (bErrPowerOff==1) return;
	bMachineOnState=ON;
	PanMoveInDet=PAN_DET_TIMER_100MS;
	NoPanDetectedCnt=0;
	IGBT_Off();

	StartPanDetect();
	PPGTA_copy=c_InitPPGT;
	CookMode=0;
}

void PowerOffProc()
{
	IGBT_Off();
	bMachineOnState=OFF;
}

void AdjPower()
{
	volatile u16 PPGTC_Temp;
	volatile u16 PPGTD_Temp;

	if (bPowerAdjStart==1)
	{
		bPowerAdjStart=0;

		if(1==HW_State_type1.bits.HW_Approach_Disable)
		{
			HW_State_type1.bits.HW_Approach_Disable=0;
			PPGTA_copy=PPGTA_copy+40;
		}

		if (PPGTA_copy>c_MaxPPGT)
		{	
			PPGTA_copy=c_MaxPPGT;
		}
		else if (PPGTA_copy<c_MinPPGT)
		{
			PPGTA_copy=c_MinPPGT;
		}	
		while(_pst == 1);	//Wait PST bit low
		if(PPGTA_copy>255)
		{
			_ppgta8=1;
		}
		else
		{
			_ppgta8=0;	
		}
		_ppgta=PPGTA_copy& 0XFF;

		if(HW_State_type1.bits.HW_Approach)
		{		
			PPGTC_Temp=PPGTA_copy+ SHAKE_FRQ;
			if (PPGTC_Temp>c_MaxPPGT)
			{	
				PPGTC_Temp=c_MaxPPGT;
			}
			else if (PPGTC_Temp<c_MinPPGT)
			{
				PPGTC_Temp=c_MinPPGT;
			}

			if(PPGTC_Temp>255)
			{
				_ppgtc8=1;
			}
			else
			{
				_ppgtc8=0;
			}
			_ppgtc=PPGTC_Temp&0xFF;

			PPGTD_Temp=PPGTA_copy;

			if (PPGTD_Temp>c_MaxPPGT)  
			{	
				PPGTD_Temp=c_MaxPPGT;
			}
			else if (PPGTD_Temp<c_MinPPGT)
			{
				PPGTD_Temp=c_MinPPGT;
			}	  

			if(PPGTD_Temp>255)
			{
				_ppgtd8=1;
			}
			else
			{
				_ppgtd8=0;
			}
			_ppgtd=PPGTD_Temp&0xFF;

			_ppghtmd=0;
			_ppgsamd=1;
		}
		else
		{
			_ppghtmd=1;
			_ppgton=OFF;
		}
	}
}
