//
// IH Cooker Sample Program
//

#include "Include.h"
#ifdef UART_ASCII

void uart_put_char(u8 d_tx)
{
	u8  t_loop;
	bit Fg_Emi_Temp;
	Fg_Emi_Temp=_emi;
	_emi=0;
	TX_OUTPUT();

	TX_CLR();       //start bit
	B232Delay(BAUD_RATE);

	for(t_loop=0;t_loop<8;t_loop++)  //data
	{
	if(d_tx & 0x01)
	  TX_SET();
	else
	  TX_CLR();

	B232Delay(BAUD_RATE);
	d_tx>>=1;
	}

	TX_SET();
	B232Delay(BAUD_RATE);
	_emi=Fg_Emi_Temp;
	B232Delay(10);

}

void uart_print_uint(unsigned int value)
{	
	volatile u8 k,a[4];
	a[3]=value%10;
	value=value/10;
	a[2]=value%10;
	value=value/10;
	a[1]=value%10;
	value=value/10;
	a[0]=value%10;

	for(k=0;k<4;k++)
	{
		uart_put_char(a[k]+'0');
	}
}

void uart_print_uinthex(unsigned int value)
{	
	volatile u8 k,a[4];
	a[3]=value%0x10;
	value=value/0x10;
	a[2]=value%0x10;
	value=value/0x10;
	a[1]=value%0x10;
	value=value/0x10;
	a[0]=value%0x10;

	for(k=0;k<4;k++)
	{
		if( ( a[k] >= 0 ) && ( a[k] <= 9 ) )
		{
			uart_put_char(a[k]+'0');
		}
		else
		{
			uart_put_char(a[k]-10+'A');
		}
	}
}

#endif
