//
// IH Cooker Sample Program
//


#include"Include.h"

extern volatile u8 IsrOvp;
extern volatile u8 IsrCmp1;
extern volatile u8 IsrCmp2;
extern volatile u8 IsrCmp3;


u8 ucRamTest1=0x55;
u8 ucRamTest2=0x55;
u8 ucRamTest3=0x55;
u8 ucRamTest4=0x55;
u8 ucRamTest5=0x55;

void main()
{
	GCC_DELAY(50000);
    ClearMemory();	
    System_Init();

    GCC_DELAY(1000);

	_ppgtme=1;
	
    _emi = ENABLE;

	while(1)
	{ 
		GCC_CLRWDT();
		Test_Detect(); //Test RAM, Wait WDT

		ADC_Task();
		ProtectWithAD_Task();
		Ad_Deal();
		if (T1S_event==1)
		{
		   b1s_Updata=~b1s_Updata;

#ifdef UART_ASCII
			uart_print_uint(PPGTA_copy);
			uart_put_char(',');

			uart_print_uint(AD_Vac);
			uart_put_char(',');

			uart_print_uint(AD_Iac);
			uart_put_char(',');

			uart_print_uint(AD_TempPad);
			uart_put_char(',');

			uart_print_uint(AD_TempIGBT);

			uart_put_char(',');
			uart_print_uint(maxAD_Vac);
			uart_put_char(',');
			uart_print_uint(maxAD_Iac);
			uart_put_char(',');
			uart_print_uint(maxAD_TempPad);
			uart_put_char(',');
			uart_print_uint(maxAD_TempIGBT);
			maxAD_Vac = 0;
			maxAD_Iac = 0;
			maxAD_TempPad = 0;
			maxAD_TempIGBT = 0;

			uart_put_char(',');
			uart_print_uint(IsrOvp);
			uart_put_char(',');
			uart_print_uint(IsrCmp1);
			uart_put_char(',');
			uart_print_uint(IsrCmp2);
			uart_put_char(',');
			uart_print_uint(IsrCmp3);

			uart_put_char(0x0d);
			uart_put_char(0x0A);
#endif	
		   OverCurrentHW_Cnt();
		   OverTEMP_PowerDrop();
		   Ntc_Detect();
		   bPower1s=1;
		   Ichanged=0;
		   ProtRecoverySlow();
		   PowerCalculation1(); //Voltage related, every  1 Sec
		   PowerCalculation2(); //Current related
		   T1S_event = 0;
		}
		if (T500mS_event==1)
		{
		   T500mS_event=0;
		   PanDetTrigger();
		}

		//----- 100mS routine task ------
		if (T100mS_event==1)
		{
			T100mS_event=0;	
			IIC();
			if ((bMachineOnState==ON)&&(CookMode!=0)) 
			{
			    PanMoveOutDetect();
			    PanMoveInDetect();
			    //--------- Fix Power control --------
				if (bPowerStepChanged==1)
				{	
				    bPowerStepChanged=0;
				    TartgetPowerInit();	
				}
				if (bPowerState==1)
				{
					if (StartWorkCount<200) 
					{
						StartWorkCount++; 
					}

					if ((StartWorkCount>5) && (PowerIV>0))
					{
						PowerCalculation2();
						PowerControl();
					}
				}
				else
				{
						StartWorkCount=0;
						PowerIV=0;
				}
			}
		}

		//----- 20mS routine task ------
		if (T20mS_event==1)
		{
			T20mS_event=0;
			UI_Task();
			ADC_Start();
			SurgeCurrent_Protect();
		}
	    if(1==T1mS_event)
		{
			T1mS_event=0;
			TimeBase();
		}
	}
}
void  ClearMemory()
{
	_mp0=0x80;
	for(_tblp=0;_tblp<128;_tblp++)
	{
		_iar0=0;
		_mp0++;
	}
    _mp1h = 0x01;
    _mp1l = 0x80;
	for(_tblp=0;_tblp<128;_tblp++)
	{
		_iar1=0;
		_mp1l++;
	}
}

void System_Init()
{
	_scc = 0x00;  //System clock 16MHz
	IO_Init();
	RamTest_Init();
	Timer0Initial();
	Timer2Initial();
	IGBT_Off();
	ADC_Init();
	CMP_OPA_Init();
	ISR_CP2CP3_INIT();
	PowerCalculation_Init();
	Beep_Fan_Dcf_Init();
	IIC_Init();
	PPG_CONFIG();
	VarInit();
}

void IO_Init()
{
	_pas07 = 0;  //select PA3 as CPOP
	_pas06 = 1;
	_pas05 = 1;  //select PA2 as AN2
	_pas04 = 0;
	_pas03 = 0;  //select PA1 as OPOUT
	_pas02 = 1;

	_pas17 = 1;  //select PA7 as  AN5
	_pas16 = 0;
	_pas15 = 0;  //select PA6 as  CP2N
	_pas14 = 1;
	_pas13 = 0;  //select PA5 as  IO
	_pas12 = 0;
	_pas11 = 1;  //select PA4 as  AN4
	_pas10 = 0;

	_pbs07 = 0;  //select PB3 as  CP0N
	_pbs06 = 1;
	_pbs05 = 1;  //OVP0I1&AN1
	_pbs04 = 1;
	_pbs03 = 0;  //select PB1 as  PCK
	_pbs02 = 1;
	_pbs01 = 0;  //select PB0 as  OP0INN
	_pbs00 = 1;
	_pbs11 = 0;  //select PB4 as  IO
	_pbs10 = 0;
}

void VarInit()
{
  
	PanMoveInDet=1;
	AD_Vac=c_AD_215V;

	bPowerStepChanged=1;
	PowerStep=c_PowStep_OFF;
	PPGTA_copy=c_InitPPGT;

    PanDetPulseCnt=250;
    PowerIV=0;
}

void RamTest_Init()
{
	ucRamTest1=0x55;
	ucRamTest2=0x55;
	ucRamTest3=0x55;
	ucRamTest4=0x55;
	ucRamTest5=0x55;
}

void Test_Detect()
{
	if(0x55!=ucRamTest1 || 0x55!=ucRamTest2||\
	   0x55!=ucRamTest3 || 0x55!=ucRamTest4||\
	   0x55!=ucRamTest5)
	{
		while(1)
		GCC_NOP();
	}
}
