//
// IH Cooker Sample Program
//

#include"Include.h"

volatile bit DeviceACK_Flag;
volatile bit Fg_I2c_WrRd;
volatile u8 u8_I2c_WrRd_1ms;
volatile u8 u8_PowerStep_buf;
volatile u8 u8_ModeSet;
IH_Status_FLAG IH_Status_App;
ControlSet_Flag  ControlSet_App;

void IIC_Init()
{
	DeviceACK_Flag=0;
	Fg_I2c_WrRd=0;
}

void IIC_Start()
{
	scl=0;	scl_c=0;
	DatHi();
	GCC_DELAY(I2CSP);
	scl=1;		GCC_DELAY(I2CSP);
	DatLo();	GCC_DELAY(I2CSP);
	scl=0;		GCC_DELAY(I2CSP);
}

void IIC_Stop()
{
	scl=0;
	DatLo();
	GCC_DELAY(I2CSP);
	scl=1;	GCC_DELAY(I2CSP);
	DatHi();GCC_DELAY(I2CSP);
}

void Wr_Byte(unsigned short I2CData)
{
	unsigned short temp=0b10000000;
	scl=0;
	do
	{
		if(I2CData&temp)	DatHi();
		else	DatLo();
			GCC_DELAY(I2CSP/2);
		scl=1;	GCC_DELAY(I2CSP);
		scl=0;	GCC_DELAY(I2CSP/2);
		temp>>=1;	
	}while(temp!=0);
}

unsigned short Rd_Byte(void)
{
	unsigned short I2CData=0,temp=0b10000000;
	sda_c=1;
	do
	{
		scl=1;	GCC_DELAY(I2CSP);
		if(sda)	I2CData|=temp;
		scl=0;	GCC_DELAY(I2CSP);
		temp>>=1;
	}while(temp!=0);
	return I2CData;
}

void CheckACK()
{
	unsigned char i=20;
	sda_c=1;	GCC_DELAY(I2CSP);
	scl=1;	GCC_DELAY(I2CSP);
	while(i--)
	{
		if(!sda)
		{
			DeviceACK_Flag=1;
			break;
		}
		GCC_DELAY(I2CSP);
	}
	scl=0;
	GCC_DELAY(I2CSP);
}

volatile u8 Rx_Buff[4];
void IIC()
{
	u8 Wr_check_sum;
	volatile u8  Check_Sum=0;
	volatile u8 i,IIC_temp;
	scl=1;
	sda=1;
	if(0==Fg_I2c_WrRd)
	{
		Fg_I2c_WrRd=1;	
		DeviceACK_Flag=0;
		IIC_Start();
		Wr_Byte(DEVICE_ID|0);
		CheckACK();
	
		Wr_Byte(AD_TempIGBT);
		CheckACK();
		Wr_Byte(AD_TempPad);
		CheckACK();
		IIC_temp=0;
		IIC_temp=IH_Status_App.m_data <<5;
		IIC_temp=( (~IIC_temp)&0b11100000 );
		IIC_temp=IIC_temp+(IH_Status_App.m_data &0b00011111);
		Wr_Byte(IIC_temp);
		CheckACK();
		Wr_check_sum=AD_TempIGBT+AD_TempPad+IIC_temp;
		Wr_Byte(Wr_check_sum);
		CheckACK();
		
		IIC_Stop();
		GCC_DELAY(200);
		u8_I2c_WrRd_1ms=0;
	}
	else if(u8_I2c_WrRd_1ms>=1)
	{
		Fg_I2c_WrRd=0;
		u8_I2c_WrRd_1ms=0;

		IIC_Start();
		Wr_Byte(DEVICE_ID|1);
		CheckACK();
		
		for(i=0;i<4;i++)
		{
			GCC_CLRWDT();
			Rx_Buff[i]=Rd_Byte();
			sda_c=0;
			if(i>=(4-1) )
			{
				sda=1;
			}
			else
			{
				sda=0;
			}	
			sda_c=0;	GCC_DELAY(I2CSP);
			scl=1; 		GCC_DELAY(I2CSP);
			scl=0;		GCC_DELAY(I2CSP);
		
		}
		IIC_Stop();
		Check_Sum=Rx_Buff[0]+Rx_Buff[1]+Rx_Buff[2];
		if( (Check_Sum==Rx_Buff[3]))
		{
			//analysis the data and clear buffer
			u8_PowerStep_buf=Rx_Buff[1];
			u8_ModeSet=Rx_Buff[2];	
			IIC_temp=0;
			IIC_temp=(Rx_Buff[0] &0xf0)>>4;
			IIC_temp=( (~IIC_temp)&0X0F );
			if( IIC_temp==(Rx_Buff[0] &0x0f) )
			{  
				ControlSet_App.m_data=Rx_Buff[0];
			}
		}
		else
		{
			GCC_NOP();
		}
		
	}
}
