/**
 ****************************************************************************
 * @file     usercon.h
 * @brief    User control
 * @version  V1.0
 *
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2021
 *****************************************************************************
 */
#ifndef _USERCON_H
#define _USERCON_H

#undef EXTERN
#ifdef DEFINE_APP
#define EXTERN
#else
#define EXTERN  extern
#endif

/*****************************************************************
	Define for Software & Hardware setting
******************************************************************/

#define LED_VE					(TSB_PF_DATA_PF3)

#define	LED_VE_ON				LED_VE = 1
#define	LED_VE_OFF				LED_VE = 0


/*===================================================================*
	Define Typedef
*===================================================================*/
typedef union
{
	struct
	{
		uint8_t	sw8	: 1;
		uint8_t	sw7	: 1;
		uint8_t	sw6	: 1;
		uint8_t	sw5	: 1;
		uint8_t	sw4	: 1;
		uint8_t	sw3	: 1;
		uint8_t	sw2	: 1;
		uint8_t	sw1	: 1;
	} bit;
	uint8_t	all;
} sw_t;


typedef struct
{
	ADC_Result		rawdat;
	uint8_t			avecnt;
	uint16_t		maxdat;
	uint16_t		mindat;
	uint32_t		sumdat;
	uint16_t		avedat;
} addat_t;


typedef struct
{
	uint8_t	reserve			: 7;			/* reserve */
	uint8_t	timeout			: 1;			/* 2sec Time out flag */
} timer_t;


typedef struct
{
	uint8_t	reserve			: 7;			/* reserve */
	uint8_t	keydata_set		: 1;			/* Switch input confirmation information */
} key_t;


typedef struct
{
	uint8_t	reserve			: 7;			/* reserve */
	uint8_t	ad_update		: 1;			/* ADC complete flag */
} adc_t;


typedef struct
{
	uint8_t	reserve			: 4;			/* reserve */
	uint8_t	data_receive	: 1;			/* receive end */
	uint8_t	emg_bit			: 1;			/* EMG bit */
	uint8_t	na_bit			: 1;			/* N/A bit */
	uint8_t	ack_bit			: 1;			/* ACK bit */
} uart_t;


typedef struct
{
	timer_t		timer;
	key_t		key;
	adc_t		adc;
	uart_t		uart;
} usercon_flg;

/*===================================================================*
      Proto Type Definition
 *===================================================================*/

EXTERN	void	init_user_control(void);
EXTERN	void	user_control(void);
EXTERN	void	UikeyInitscan(void);
EXTERN	void	uart_control(void);
EXTERN	void	INT_uart0rx(void);
EXTERN	void	INT_uart0tx(void);


EXTERN	void	UiOutDataStartByVE(uint8_t	_intch);

/*===================================================================*
	Variable Definition
 *===================================================================*/

EXTERN	sw_t		keydata;						/* Key data */
EXTERN	usercon_flg	flg;							/* User control flag */

#undef EXTERN
#endif

/******************************** END OF FILE *********************************/
