/**
 ****************************************************************************
 * @file     system_int.c
 * @brief    System Interrupt Functions for TOSHIBA 'TMPM374' Device Series
 * @version  V1.0
 *
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2021
 *****************************************************************************
 */
#include "ipdefine.h"
#include "mcuip_drv.h"
#include "interrupt.h"

#include "B_User.h"
#include "dac_drv.h"
#include "usercon.h"
#include "system_int.h"


#if defined(__MOTOR_DBGOUT_VECTOR_TIME_INT)
#define	DBO_VE_HIGH			LED_VE_ON
#define	DBO_VE_LOW			LED_VE_OFF
#else  /* defined(__MOTOR_DBGOUT_VECTOR_TIME_INT) */
#define	DBO_VE_HIGH			/*  */
#define	DBO_VE_LOW			/*  */
#endif /* defined(__MOTOR_DBGOUT_VECTOR_TIME_INT) */


void NMI_Handler(void)
{}

void HardFault_Handler(void)
{}

void MemManage_Handler(void)
{}

void BusFault_Handler(void)
{}

void UsageFault_Handler(void)
{}

void SVC_Handler(void)
{}

void DebugMon_Handler(void)
{}

void PendSV_Handler(void)
{}

void SysTick_Handler(void)
{}

void INT5_IRQHandler(void)
{}

void INTRX0_IRQHandler(void)
{
	INT_uart0rx();
	__DSB();				/* for ARM processor errata 838469 */
}

void INTTX0_IRQHandler(void)
{
	INT_uart0tx();
	__DSB();				/* for ARM processor errata 838469 */
}

void INTRX1_IRQHandler(void)
{}

void INTTX1_IRQHandler(void)
{
#if defined(__USE_DAC)
	DacWriteContinue(DAC_SIO_CH);
	__DSB();				/* for ARM processor errata 838469 */
#endif /* __USE_DAC */
}

void INTVCN1_IRQHandler(void)
{
	DBO_VE_HIGH;
	INT_VectorControlByVE_CH1(&Motor_ch1, &Motor_ch1_IP);
	DBO_VE_LOW;
	__DSB();				/* for ARM processor errata 838469 */
}

void INTEMG1_IRQHandler(void)
{}

void INTOVV1_IRQHandler(void)
{}

void INTADBPDB_IRQHandler(void)
{}

void INTTB00_IRQHandler(void)
{
	INT_interval_4kHz();
	__DSB();				/* for ARM processor errata 838469 */
}

void INTTB01_IRQHandler(void)
{}

void INTTB10_IRQHandler(void)
{}

void INTTB11_IRQHandler(void)
{}

void INTTB40_IRQHandler(void)
{}

void INTTB41_IRQHandler(void)
{}

void INTTB50_IRQHandler(void)
{}

void INTTB51_IRQHandler(void)
{}

void INTPMD1_IRQHandler(void)
{
	INT_PWM1(&Motor_ch1_IP);
	__DSB();				/* for ARM processor errata 838469 */
}

void INTCAP00_IRQHandler(void)
{}

void INTCAP10_IRQHandler(void)
{}

void INTCAP40_IRQHandler(void)
{}

void INTCAP50_IRQHandler(void)
{}

void INT6_IRQHandler(void)
{}

void INT7_IRQHandler(void)
{}

void INTADBCPA_IRQHandler(void)
{}

void INTADBCPB_IRQHandler(void)
{}

void INTTB20_IRQHandler(void)
{}

void INTTB21_IRQHandler(void)
{}

void INTTB30_IRQHandler(void)
{}

void INTTB31_IRQHandler(void)
{}

void INTCAP20_IRQHandler(void)
{}

void INTCAP21_IRQHandler(void)
{}

void INTCAP30_IRQHandler(void)
{}

void INTCAP31_IRQHandler(void)
{}

void INTADBSFT_IRQHandler(void)
{}

void INTADBTMR_IRQHandler(void)
{}

void INTENC01_IRQHandler(void)
{}

void INTRX3_IRQHandler(void)
{}

void INTTX3_IRQHandler(void)
{}

void INTTB60_IRQHandler(void)
{}

void INTTB61_IRQHandler(void)
{}

void INTTB70_IRQHandler(void)
{}

void INTTB71_IRQHandler(void)
{}

void INTCAP60_IRQHandler(void)
{}

void INTCAP61_IRQHandler(void)
{}

void INTCAP70_IRQHandler(void)
{}

void INTCAP71_IRQHandler(void)
{}

void INTC_IRQHandler(void)
{}

void INTD_IRQHandler(void)
{}

void INTE_IRQHandler(void)
{}

void INTF_IRQHandler(void)
{}

/*********************************** END OF FILE ******************************/
