/**
 ****************************************************************************
 * @file     E_Sub.h
 * @brief    Sub Routine Functions
 * @version  V1.0
 *
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2021
 *****************************************************************************
 */
#ifndef _E_SUB_H_INCLUDED
#define _E_SUB_H_INCLUDED

#undef EXTERN
#ifdef DEFINE_APP
#define EXTERN
#else
#define EXTERN  extern
#endif

/*===================================================================*
      Proto Type Definition
 *===================================================================*/
EXTERN	short	E_Sine(short theta);
EXTERN	short	E_Cosine(short theta);
EXTERN	void	E_Clarke(q15_t _iu, q15_t _iv, q15_t _iw, q15_t* _ialpha, q15_t* _ibeta);
EXTERN	void	E_Park(q15_t _ialpha, q15_t _ibeta, uint16_t _theta, q15_t* _id, q15_t* _iq);
EXTERN	void	E_InvPark(q31_t _d, q31_t _q, uint16_t _theta, q31_t* _alpha, q31_t* _beta);
EXTERN	int32_t	E_Max3(int32_t _a, int32_t _b, int32_t _c);
EXTERN	int32_t	E_Med3(int32_t _a, int32_t _b, int32_t _c);
EXTERN	int32_t	E_Min3(int32_t _a, int32_t _b, int32_t _c);
EXTERN	void	E_Sort3(int32_t* _n1, int32_t* _n2, int32_t* _n3);

#undef	EXTERN
#endif /* _E_SUB_H_INCLUDED */

/*********************************** END OF FILE ******************************/
