// *************** USER FUNCTIONS ***********************
// void   displayMessageBoxInformation(String title, String label)
// void   displayMessageBoxError(String title, String label)
// String displayMessageBoxSelection(String title, String label, String[] selectionChoices)
  
////////////////////////////////////////////////////////////////////////////////////////////////  
import javax.swing.*;       // used for creating dialogbox
import java.awt.Color;    // used for setting color in UImanager for dialogbox
import java.awt.Font;    // used for setting font in UImanager for dialogbox

// ********************************* Message Box ***********************************************
void displayMessageBoxInformation(String title, String label){
  JOptionPane.showConfirmDialog(null,
             label,                             // Label
             title,                             // Title
             JOptionPane.DEFAULT_OPTION,        // Buttons   DEFAULT_OPTION OK_CANCEL_OPTION YES_NO_CANCEL_OPTION YES_NO_OPTION 
             JOptionPane.INFORMATION_MESSAGE);  // Icon Type ERROR_MESSAGE INFORMATION_MESSAGE QUESTION_MESSAGE WARNING_MESSAGE PLAIN_MESSAGE 
}
void displayMessageBoxError(String title, String label){
  JOptionPane.showConfirmDialog(null,
             label,                             // Label
             title,                             // Title
             JOptionPane.DEFAULT_OPTION,        // Buttons   DEFAULT_OPTION OK_CANCEL_OPTION YES_NO_CANCEL_OPTION YES_NO_OPTION 
             JOptionPane.ERROR_MESSAGE);        // Icon Type ERROR_MESSAGE INFORMATION_MESSAGE QUESTION_MESSAGE WARNING_MESSAGE PLAIN_MESSAGE 
}
String displayMessageBoxSelection(String title, String label, String[] selectionChoices){
    String input = (String) JOptionPane.showInputDialog(null,
            label,                              // Label
            title,                              // Title
            JOptionPane.QUESTION_MESSAGE,       // Icon Type ERROR_MESSAGE INFORMATION_MESSAGE QUESTION_MESSAGE WARNING_MESSAGE PLAIN_MESSAGE
            null,
            selectionChoices,                   // Arrary of strings for selection choices
            selectionChoices[0]);
    return input;
}
String displayMessageBoxInputString(String title, String label){
    String input = (String) JOptionPane.showInputDialog(null,
            label,                              // Label
            title,                              // Title
            JOptionPane.QUESTION_MESSAGE);       // Icon Type ERROR_MESSAGE INFORMATION_MESSAGE QUESTION_MESSAGE WARNING_MESSAGE PLAIN_MESSAGE
    return input;
}

void messageBoxInitialization() {  //adjustLookAndFeel
  UIManager.put("OptionPane.cancelButtonText", "Cancel");
  UIManager.put("OptionPane.noButtonText", "No");
  UIManager.put("OptionPane.okButtonText", "Ok");
  UIManager.put("OptionPane.yesButtonText", "Yes");
  UIManager.put("Button.background", new Color(0,45,90));
  UIManager.put("Button.foreground", Color.white);
  UIManager.put("OptionPane.font",new Font(mainFontStyle,Font.BOLD,guiBaseFontSize));
  UIManager.put("OptionPane.messageFont",new Font(mainFontStyle,Font.BOLD,guiBaseFontSize));
  UIManager.put("OptionPane.buttonFont",new Font(mainFontStyle,Font.BOLD,guiBaseFontSize));
}
