// Call drawGraph() function from the draw() function.  // It requires few sliders to get input, for details check code below 

// --- Global variables (Following are updated in drawGraph function)
float slopeData  =1;
float slope2Data =1;
boolean threePointProfile=false;
boolean openLoopFlag=false;


void drawGraph(){
  final int gPositionX = 812; //Graph position Coordinate //tab area is 800 wide
  final int gPositionY = 35;
  final int gWidth = 380;     //Graph size Coordinate
  final int gHeight = 270;
  final int axisGap = 50;     //Graph axis distance from graph borders
  threePointProfile = (cp5.getController("toggle_ChangePoint").getValue()==1); // SpeedProfile is 3 point (true) or 2 point (false) 
  openLoopFlag = (cp5.getController("toggle_OpenCloseLoop").getValue()==1);
  pushMatrix();
    translate(gPositionX, gPositionY); //translating coordinates to draw graph 
    //Graph background
    noStroke();
    fill(250);      //Text & Shape fill color
    rect(0, 0, gWidth, gHeight); //x,y,with,height
    pushMatrix();
      translate(axisGap, gHeight-axisGap); //translating coordinates to Graph Origin point
      int xAxisMax = gWidth-axisGap-10; // 100% point on x axis (End of xAxis)
      int yAxisMax = -gHeight+axisGap+10; // 100% point on x axis (End of xAxis)
      //Graph Label
      fill(10);      //Text & Shape fill color
      textSize(graphFontSize+5); //Size for Title of Graph
      if(cp5.getController("toggle_OpenCloseLoop").getValue()==1){ //1:Open loop, 0:Close Loop
      text("Speed Curve (Open Loop)", 50, -230);    
      } else {
      text("Speed Curve (Closed Loop)", 50, -230);    
      }
      //x-Axis & Label
      strokeWeight(2); //Shape Outline Weight
      stroke(200);      // Shape Outline Color
      strokeCap(ROUND);
      line(-axisGap+10, 0, xAxisMax, 0); // x1,y1, x2,y2
      textSize(graphFontSize+3); //Size for title of axis
      text("Speed Input (%)", 100, 43 );
      //y-Axis & Label
      line(0, yAxisMax, 0, axisGap-10); // x1,y1, x2,y2
      pushMatrix();
        rotate(-HALF_PI);
        if(openLoopFlag==true){
          text("Speed Output (%)",30,-35);
        }else{
          text("Speed Output (rpm)",30,-35);
        }
      popMatrix();
      //Speed Profile Drawing
      
      //Reading data from slider
      final float startDutyData = cp5.getController("slider_StartDuty").getValue();
      final float stopDutyData = cp5.getController("slider_StopDuty").getValue();
      final float maxDutyData = cp5.getController("slider_MaxDuty").getValue();
      final float hysteresisWidthData = cp5.getController("slider_MaxDutyHysteresis").getValue();
      float minOutputData=20;
      float maxOutputData = 80;
      float changeDutyData=50;
      float changeOutputData=50;
      if(openLoopFlag==true){
        minOutputData= cp5.getController("slider_MinOutputOL").getValue();
        maxOutputData= cp5.getController("slider_MaxOutputOL").getValue();
        if(threePointProfile == true){
          changeDutyData = cp5.getController("slider_ChangeDuty").getValue();
          changeOutputData = cp5.getController("slider_ChangeOutputOL").getValue();
        }
      }else{
        minOutputData= cp5.getController("slider_MinOutputCL").getValue();
        maxOutputData= cp5.getController("slider_MaxOutputCL").getValue();
        if(threePointProfile == true){
          changeDutyData = cp5.getController("slider_ChangeDuty").getValue();
          changeOutputData = cp5.getController("slider_ChangeOutputCL").getValue();
        }
      }
      //Mapping Speed Profile Data to Graph Area
      //x-axis data
      final float startDuty = map(startDutyData, 0,100, 0,xAxisMax);
      final float stopDuty =  map(stopDutyData,  0,100, 0,xAxisMax);
      final float maxDuty =  map(maxDutyData,   0,100, 0,xAxisMax);
      final float hysteresisWidth = map(hysteresisWidthData, 0,100, 0,xAxisMax); 
      //y-axis data (Max value of yaxis is 100 in OpenLoop and MaxCloseLoopMotorRPM in ClosedLoop
      float minOutput=20;
      float maxOutput=80;
      float maxPossibleOutput = yAxisMax;
      float changeDuty =50;
      float changeOutput =50;
      float slope=1;
      float slope2=1;
      if(openLoopFlag==true){ //Open Loop      
          minOutput = map(minOutputData, 0,100, 0,yAxisMax);
          maxOutput = map(maxOutputData, 0,100, 0,yAxisMax);
          if(threePointProfile == false){
              slope = (maxOutput-minOutput)/(maxDuty-startDuty);  //slope between startDuty and maxDuty //Slope for graph (different from actual because graph is skewed)
              slopeData = (maxOutputData-minOutputData)/(maxDutyData-startDutyData);  //slope between startDuty and maxDuty //Actual slope
          }else{
              changeDuty =  map(changeDutyData,   0,100, 0,xAxisMax);
              changeOutput = map(changeOutputData, 0,100, 0,yAxisMax);
              slope = (changeOutput-minOutput)/(changeDuty-startDuty);  //slope between startDuty and changeDuty //Slope for graph (different from actual because graph is skewed)
              slope2 = (maxOutput-changeOutput)/(maxDuty-changeDuty);  //slope2 between changeDuty and maxDuty //Slope for graph (different from actual because graph is skewed)
              slopeData = (changeOutputData-minOutputData)/(changeDutyData-startDutyData);  //slope between startDuty and changeDuty //Actual slope
              slope2Data = (maxOutputData-changeOutputData)/(maxDutyData-changeDutyData);  //slope2 between changeDuty and maxDuty //Actual slope
          }
      }else{ //Closed Loop
          minOutput = map(minOutputData, 0,MaxCloseLoopMotorRPM, 0,yAxisMax);
          maxOutput = map(maxOutputData, 0,MaxCloseLoopMotorRPM, 0,yAxisMax);
          if(threePointProfile == false){
              slope = (maxOutput-minOutput)/(maxDuty-startDuty);  //slope between startDuty and maxDuty //Slope for graph (different from actual because graph is skewed)
              slopeData = (maxOutputData-minOutputData)/(maxDutyData-startDutyData);  //slope between startDuty and maxDuty //Actual slope
          }else{
              changeDuty =  map(changeDutyData,   0,100, 0,xAxisMax);
              changeOutput = map(changeOutputData, 0,MaxCloseLoopMotorRPM, 0,yAxisMax);
              slope = (changeOutput-minOutput)/(changeDuty-startDuty);  //slope between startDuty and changeDuty //Slope for graph (different from actual because graph is skewed)
              slope2 = (maxOutput-changeOutput)/(maxDuty-changeDuty);  //slope2 between changeDuty and maxDuty //Slope for graph (different from actual because graph is skewed)
              slopeData = (changeOutputData-minOutputData)/(changeDutyData-startDutyData);  //slope between startDuty and changeDuty //Actual slope
              slope2Data = (maxOutputData-changeOutputData)/(maxDutyData-changeDutyData);  //slope2 between changeDuty and maxDuty //Actual slope
          }
      }
      
      //Graph Reference Lines
      stroke(230); // Outline Color : light color
      line(stopDuty,0,stopDuty,minOutput); //stopDuty ref line
      line(startDuty,0,startDuty,minOutput); //startDuty ref line
      line(0,minOutput,stopDuty,minOutput); //minOutput ref line
      line(0,maxOutput,maxDuty,maxOutput); //maxOutput ref line
      line(maxDuty,0,maxDuty,maxOutput); //maxDuty ref line
      if(threePointProfile == true){
        line(changeDuty,0,changeDuty,changeOutput); //changeDuty ref line      
        line(0,changeOutput,changeDuty,changeOutput); //changeOutput ref line
      }

      
      //Graph Main lines
      stroke(graphColor); // Graph Line Color : same as tab color
      //Drawing Graph beyond maxDuty
      if(cp5.getController("toggle_MaxOpen").getValue() == 0){
        maxPossibleOutput = maxOutput;
        //Line at maxOutput beyond maxDuty
        line(maxDuty,maxOutput,xAxisMax,maxOutput);
      }else{
        // maxPossibleOutput is set to 100%(yAxisMax) in initialization
        final float hysteresisOutput = map(maxDuty,0,xAxisMax,0,yAxisMax);
        //Reference lines for MaxOpen=1
        stroke(230); // line Color : light color
        line(0,0,xAxisMax,yAxisMax); //slope=1 ref line
        line(0,yAxisMax,xAxisMax,yAxisMax); //100%Output ref line
        line(xAxisMax,0,xAxisMax,yAxisMax); //100%Duty ref line
        // Graph Line Color 
        stroke(tabActiveColor); // Graph Line Color : same as tab color
        //slope line beyond maxDuty
        line(maxDuty-hysteresisWidth,map(maxDuty-hysteresisWidth,0,xAxisMax,0,yAxisMax),xAxisMax,yAxisMax);
        //hysteresis at maxDuty
        ////hysteresis arrow (vertical) at maxDuty coordinates
        final float arrow1x =maxDuty; //x coordinate
        final float arrow1ys =maxOutput; //y start coordinate
        final float arrow1ye =hysteresisOutput; //y end coordinate (with arrow)
        ////hysteresis arrow on the left of above arrow
        final float arrow2x =maxDuty-hysteresisWidth; //x coordinate
        final float arrow2ys =map(arrow2x,0,xAxisMax,0,yAxisMax); //y start coordinate
        float arrow2ye = minOutput + slope*(arrow2x-startDuty); //y end coordinate (with arrow)
        if(threePointProfile == true && arrow2x > changeDuty){  // for three point profile and hysteresis arrow2 is on slope2
          arrow2ye =changeOutput + slope2*(arrow2x-changeDuty); //arrow 2 end point(with arrow) is calculated base on speed slope2 
        }
        //hysteresis arrow body (line) 
        line(arrow1x,arrow1ys,arrow1x,arrow1ye); //arrow1 @ maxDuty
        line(arrow2x,arrow2ys,arrow2x,arrow2ye); //arrow2 
        //hyysteresis arrow head (triangle)
        //arrow1 @maxDuty
        if(arrow1ye > arrow1ys){ //(y coordinates are negative so : it means arrow1end is lower than arrow1start so downward arrow)
        triangle(arrow1x,arrow1ye,arrow1x-3,arrow1ye-5,arrow1x+3,arrow1ye-5); // Down
        }else{
        triangle(arrow1x,arrow1ye,arrow1x-3,arrow1ye+5,arrow1x+3,arrow1ye+5); // Up
        }
        //arrow2
        if(arrow2ye > arrow2ys){ //(y coordinates are negative so : it means arrow2end is lower than arrow1start so downward arrow)
        triangle(arrow2x,arrow2ye,arrow2x-3,arrow2ye-5,arrow2x+3,arrow2ye-5); // Down
        }else{
        triangle(arrow2x,arrow2ye,arrow2x-3,arrow2ye+5,arrow2x+3,arrow2ye+5); // Up
        }
      }
      if(cp5.getController("toggle_NoStop").getValue() == 0){
        if(cp5.getController("toggle_MaxOff").getValue() == 1){
          line(0,0,0,maxPossibleOutput);
        }
        //horizontal line to start at 0 height
        line(0,0,startDuty,0);
        //Start Line
        line(startDuty,0,startDuty,minOutput);
        triangle(startDuty,minOutput,startDuty-3,minOutput+5,startDuty+3,minOutput+5);
        //Stop Line
        line(stopDuty,0,stopDuty,minOutput);
        triangle(stopDuty,0,stopDuty-3,-5,stopDuty+3,-5);
      }else{
        if(cp5.getController("toggle_MaxOff").getValue() == 0){
          //horizontal line before stopDuty @ minOutput
          line(0,minOutput,stopDuty,minOutput);
        }else{
          //horizontal line before stopDuty @ maxPossibleOutput
          line(0,maxPossibleOutput,stopDuty,maxPossibleOutput);
          //vertical line at stopDuty
          line(stopDuty,maxPossibleOutput,stopDuty,minOutput);
        }
      }
      //horizontal line between Start-Stop
      if(startDuty>stopDuty){  //Valid Setting so drawing normal line
        line(stopDuty,minOutput,startDuty,minOutput);
      }else{ //Invalid setting so drawing line in RED. 
        stroke(250,0,0);
        line(stopDuty,minOutput,startDuty,minOutput);
        stroke(graphColor);
      }
      float maxSlope=16; //16 in Openloop    1280 in CloseLoop
      if(openLoopFlag==false){ //CloseLoop
        maxSlope=1280;
      }
      //Slope line
      if(threePointProfile == false){  //for 2 point speed profile
        //Slope line
        if(slopeData>=0 && slopeData<=maxSlope){ //Valid setting
          line(startDuty,minOutput,maxDuty,maxOutput);
        }else{ // Invalid setting so drawing slope line in RED
          stroke(250,0,0);
          line(startDuty,minOutput,maxDuty,maxOutput);
          stroke(graphColor);
        }
      }else{                           //for 3 point speed profile
        //Slope line
        if(slopeData>=0 && slopeData<=maxSlope){ //Valid setting
         
          line(startDuty,minOutput,changeDuty,changeOutput);
        }else{ // Invalid setting so drawing slope line in RED
          stroke(250,0,0);
          line(startDuty,minOutput,changeDuty,changeOutput);
          stroke(graphColor);
        }
        //Slope2 line
        if(slope2Data>=0 && slope2Data<=maxSlope){ //Valid setting
          line(changeDuty,changeOutput,maxDuty,maxOutput);
        }else{ // Invalid setting so drawing slope line in RED
          stroke(250,0,0);
          line(changeDuty,changeOutput,maxDuty,maxOutput);
          stroke(graphColor);
        }
      }
            
      //Labels
      textSize(graphFontSize); //Size for labels
      //For data labels on X axis
      final float xAxisDataLabelxOffset = -5;  // horizontal distance from parameter reference line
      final float xAxisDataLabely = 28; //vertical distance from x axis
      //For data labels on Y axis (below marker)
        final float yAxisDataLabelx = -19; //horizontal distance from y axis
        final float yAxisDataLabelyOffset = 16; // vertical distance from parameter reference line
      ////For data labels on Y axis (above reference line)
        //final float yAxisDataLabelx = 5; //horizontal distance from y axis
        //final float yAxisDataLabelyOffset = -4; // vertical distance from parameter reference line
      //StartDuty
      text("(1)",startDuty-3,15); 
      text(round(startDutyData),startDuty+xAxisDataLabelxOffset+3,xAxisDataLabely); //Data display
      //StopDuty
      text("(2)",stopDuty-14,15);
      text(round(stopDutyData),stopDuty+xAxisDataLabelxOffset-9,xAxisDataLabely); //Data display
      //MaxDuty Label
      text("(3)",maxDuty-6,15);
      text(round(maxDutyData),maxDuty+xAxisDataLabelxOffset,xAxisDataLabely);
      //MinOutput Label
      text("(4)",-20,minOutput+4);
      text(round(minOutputData),yAxisDataLabelx,minOutput+yAxisDataLabelyOffset);
      //MaxOutput Label
      text("(5)",-20,maxOutput+4);
      text(round(maxOutputData),yAxisDataLabelx,maxOutput+yAxisDataLabelyOffset);
      //Slope 
      text("(6) slope = "+nf(slopeData,0,2),startDuty+7,minOutput+10);  //slope 
      if(threePointProfile == true){  //for 3 point speed profile
        //changeDuty Label
        text("(8)",changeDuty-6,15);
        text(round(changeDutyData),changeDuty+xAxisDataLabelxOffset,xAxisDataLabely);
        //changeOutput Label
        text("(10)",-25,changeOutput+4);
        text(round(changeOutputData),yAxisDataLabelx,changeOutput+yAxisDataLabelyOffset);
        //Slope2 
        text("(9) slope2 = "+nf(slope2Data,0,2),changeDuty+7,changeOutput+10);  //slope2
      }
      if(cp5.getController("toggle_MaxOpen").getValue() == 1){
        if(openLoopFlag==true){
          //100% Output Label
          text("100%",-50,yAxisMax+4);
        }
        //100% Duty Label
        text("100%",xAxisMax-20,40);
      }
    popMatrix();
  popMatrix();
}
