/**
 ****************************************************************************
 * @file     ipdefine.h
 * @brief    Application Definitions
 * @version  V1.0
 *
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENCE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2021
 *****************************************************************************
 */
#ifndef _IPDEFINE_H
#define _IPDEFINE_H

#include <arm_math.h>

/* Select MCU */
#if defined(__MCU_M4KNA)
#include "TMPM4KyA.h"
#endif /* defined(__MCU_M4KNA) */

#ifdef DEFINE_APP
#define EXTERN
#else
#define EXTERN	extern
#endif


/*===================================================================*
	  MCU Parameter Definition
 *===================================================================*/
/* Setting fc */
#if defined(__TMPM4KNA_H__)
#define	cIMCLK_FRQ					(80)						/* [MHz] */
#endif /* defined(__TMPM4KNA_H__) */


/*===================================================================*
	  Interruption leve define
 *===================================================================*/
/* High   Low */
/*	0 ---- 7  */

#define	INT4KH_LEVEL			5				/* 4kH interval timer interrupt */
#define	INT_UART_LEVEL			6				/* UART interrupt */


/*****************************************************************
 * Constant data set
 *****************************************************************/

/* TMRB */
/* T32A */
#define	TMR_DIV2_PRD(x)			(uint16_t)( (uint32_t)x * cIMCLK_FRQ / 2)
#define	TMR_DIV8_PRD(x)			(uint16_t)( (uint32_t)x * cIMCLK_FRQ / 8)
#define	TMR_DIV32_PRD(x)		(uint16_t)( (uint32_t)x * cIMCLK_FRQ / 32)
#define	TMR_DIV64_PRD(x)		(uint16_t)( (uint32_t)x * cIMCLK_FRQ / 64)
#define	TMR_DIV128_PRD(x)		(uint16_t)( (uint32_t)x * cIMCLK_FRQ / 128)
#define	TMR_DIV256_PRD(x)		(uint16_t)( (uint32_t)x * cIMCLK_FRQ / 256)
#define	TMR_DIV512_PRD(x)		(uint16_t)( (uint32_t)x * cIMCLK_FRQ / 512)

/*****************************************************************
 * Definition of variable
 *****************************************************************/
EXTERN uint16_t		M_Main_Counter; 		/* Main loop counter */


/*===================================================================*
	  Common Parameter Definition
 *===================================================================*/
/**** Main period ****/
#define	cMAINLOOP_PRD				(0.001)				/* [s] Cycle time of MAIN control */
#define	cMAINLOOP_CNT				((uint16_t)(cMAINLOOP_PRD / (250 * 1e-6)))


/*===================================================================*
  Includes
 *===================================================================*/
#include "ipdrv.h"

#endif /* _IPDEFINE_H */


/*************************** END OF FILE **************************************/
