/**
 ****************************************************************************
 * @file:    system_int.h
 * @brief:   System Interrupt Definitions for TOSHIBA 'TMPM4K' Device Series
 * @version: V1.0
 *
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *****************************************************************************
 */
#ifndef _SYSTEM_INT_H
#define _SYSTEM_INT_H


void NMI_Handler(void);
void HardFault_Handler(void);
void MemManage_Handler(void);
void BusFault_Handler(void);
void UsageFault_Handler(void);
void SVC_Handler(void);
void DebugMon_Handler(void);
void PendSV_Handler(void);
void SysTick_Handler(void);

void INT00_IRQHandler(void);
void INT01_IRQHandler(void);
void INT02_IRQHandler(void);
void INT03_IRQHandler(void);
void INT04_IRQHandler(void);
void INT05_IRQHandler(void);
void INT06_IRQHandler(void);
void INT07_IRQHandler(void);
void INT08_IRQHandler(void);
void INT09_IRQHandler(void);
void INT10_IRQHandler(void);
void INT11_IRQHandler(void);
void INT12_IRQHandler(void);
void INT13_IRQHandler(void);
void INT14_IRQHandler(void);
void INT15_IRQHandler(void);
void INT16_IRQHandler(void);
void INT17_IRQHandler(void);
void INT18_IRQHandler(void);
void INT21_IRQHandler(void);
void INTVCN0_IRQHandler(void);
void INTVCT0_IRQHandler(void);
void INTEMG0_IRQHandler(void);
void INTEMG1_IRQHandler(void);
void INTEMG2_IRQHandler(void);
void INTOVV0_IRQHandler(void);
void INTOVV1_IRQHandler(void);
void INTOVV2_IRQHandler(void);
void INTPWM0_IRQHandler(void);
void INTPWM1_IRQHandler(void);
void INTPWM2_IRQHandler(void);
void INTENC00_IRQHandler(void);
void INTENC01_IRQHandler(void);
void INTENC10_IRQHandler(void);
void INTENC11_IRQHandler(void);
void INTENC20_IRQHandler(void);
void INTENC21_IRQHandler(void);
void INTADAPDA_IRQHandler(void);
void INTADAPDB_IRQHandler(void);
void INTADACPA_IRQHandler(void);
void INTADACPB_IRQHandler(void);
void INTADATRG_IRQHandler(void);
void INTADASGL_IRQHandler(void);
void INTADACNT_IRQHandler(void);
void INTADBPDA_IRQHandler(void);
void INTADBPDB_IRQHandler(void);
void INTADBCPA_IRQHandler(void);
void INTADBCPB_IRQHandler(void);
void INTADBTRG_IRQHandler(void);
void INTADBSGL_IRQHandler(void);
void INTADBCNT_IRQHandler(void);
void INTADCPDA_IRQHandler(void);
void INTADCPDB_IRQHandler(void);
void INTADCCPA_IRQHandler(void);
void INTADCCPB_IRQHandler(void);
void INTADCTRG_IRQHandler(void);
void INTADCSGL_IRQHandler(void);
void INTADCCNT_IRQHandler(void);
void INTSC0RX_IRQHandler(void);
void INTSC0TX_IRQHandler(void);
void INTSC0ERR_IRQHandler(void);
void INTSC1RX_IRQHandler(void);
void INTSC1TX_IRQHandler(void);
void INTSC1ERR_IRQHandler(void);
void INTSC2RX_IRQHandler(void);
void INTSC2TX_IRQHandler(void);
void INTSC2ERR_IRQHandler(void);
void INTSC3RX_IRQHandler(void);
void INTSC3TX_IRQHandler(void);
void INTSC3ERR_IRQHandler(void);
void INTI2C0_IRQHandler(void);
void INTI2C0AL_IRQHandler(void);
void INTI2C0BF_IRQHandler(void);
void INTI2C0NA_IRQHandler(void);
void INTI2C1_IRQHandler(void);
void INTI2C1AL_IRQHandler(void);
void INTI2C1BF_IRQHandler(void);
void INTI2C1NA_IRQHandler(void);
void INTCANGLB_IRQHandler(void);
void INTCANRXD_IRQHandler(void);
void INTCANTXD_IRQHandler(void);
void INTT32A0AC_IRQHandler(void);
void INTT32A0ACCAP0_IRQHandler(void);
void INTT32A0ACCAP1_IRQHandler(void);
void INTT32A0B_IRQHandler(void);
void INTT32A0BCAP0_IRQHandler(void);
void INTT32A0BCAP1_IRQHandler(void);
void INTT32A1AC_IRQHandler(void);
void INTT32A1ACCAP0_IRQHandler(void);
void INTT32A1ACCAP1_IRQHandler(void);
void INTT32A1B_IRQHandler(void);
void INTT32A1BCAP0_IRQHandler(void);
void INTT32A1BCAP1_IRQHandler(void);
void INTT32A2AC_IRQHandler(void);
void INTT32A2ACCAP0_IRQHandler(void);
void INTT32A2ACCAP1_IRQHandler(void);
void INTT32A2B_IRQHandler(void);
void INTT32A2BCAP0_IRQHandler(void);
void INTT32A2BCAP1_IRQHandler(void);
void INTT32A3AC_IRQHandler(void);
void INTT32A3ACCAP0_IRQHandler(void);
void INTT32A3ACCAP1_IRQHandler(void);
void INTT32A3B_IRQHandler(void);
void INTT32A3BCAP0_IRQHandler(void);
void INTT32A3BCAP1_IRQHandler(void);
void INTT32A4AC_IRQHandler(void);
void INTT32A4ACCAP0_IRQHandler(void);
void INTT32A4ACCAP1_IRQHandler(void);
void INTT32A4B_IRQHandler(void);
void INTT32A4BCAP0_IRQHandler(void);
void INTT32A4BCAP1_IRQHandler(void);
void INTT32A5AC_IRQHandler(void);
void INTT32A5ACCAP0_IRQHandler(void);
void INTT32A5ACCAP1_IRQHandler(void);
void INTT32A5B_IRQHandler(void);
void INTT32A5BCAP0_IRQHandler(void);
void INTT32A5BCAP1_IRQHandler(void);
void INTFLCRDY_IRQHandler(void);


#endif /* _SYSTEM_INT_H */


/******************************** END OF FILE *********************************/
