/**
 ****************************************************************************
 * @file	 HPFC_Para.h
 * @brief	 Interleaved Power Factor Correction control Parameter Header File
 * @version  V1.0
 *
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2023
 *****************************************************************************
 */
#ifndef _D_HPFC_PARA_H
#define _D_HPFC_PARA_H

/*===================================================================*
	  Select Board type
 *===================================================================*/

/*===================================================================*
	  Select parts
 *===================================================================*/

/*===================================================================*
	  Board Parameter Definition
 *===================================================================*/

/* High/Low side driver logic */
#define cPOLL_PFC						(1)				    /* Low	side	 0:Low active, 1:High active */
#define cPOLH_PFC						(1)				    /* 0:Low active 1: High active */
#define cPFC_SHUNT						(4)

/* V MAX */
#define cV_MAX_PFC						(cV_MAX_FAN)	    /* [V] Input voltage(Vdc)  at ADC = 0xFFF0(5V) */
#define cVAC_MAX						(470.0f)			/* Vac max */
#define cVDC_LIM						(365.0f)			/* Vdc limit */

/* A MAX */
#define cA_MAX_PFC						(33.33f)			                    /* [A] Input current(Iabc) at ADC = 0xFFF0(5V) */
#define cPFC_STUP_CNT					(1000.0f)/* (4000.0f)*/                 /* [ms]Vdc increase delay time */
#define cPFC_VDCTARGET_CNT				(30)				                    /* [ms]Vdc up to target time */
#define cPFC_VADD						(5)				                        /* [V]the inteval of vdq pre&now */
#define cPFC_VDCDWLIMIT 				(20)				                    /* [V]Vdq down value */
#define cPFC_VDC_TGT_CTRCYCLE			(20)				                    /* VDC add control cycle */
#define cPFC_VDQ_PERCENT				(15)				                    /* [%]Vdq percent */
#define cPFC_VDQ_CNT					(272)
#define cVAL_ERR_VDC_OVER				((375 * FIX_12)/cV_MAX_PFC)			    /* [AD] Vdc Over voltage */
#define cVAL_ERR_VAC_OVER				((353 * FIX_12/2)/cVAC_MAX)			    /* [AD] Vac Over voltage */ 	
#define cVAL_ERR_VDC_UNDER				((150 * FIX_12)/cV_MAX_PFC)			    /* [AD] Vdc Under voltage */ 
#define cVAL_ERR_VAC_UNDER				((226 * FIX_12/2)/cVAC_MAX)			    /* [AD] Vac Under voltage */ 
#define cVAL_ERR_I_OVER 				((16 * FIX_12/2)/cA_MAX_PFC)			/* [AD] Iac Over current */ 
#define cM_ERR_MODE_NUM 				(3)									    /* Error times */

/* AD Channel */
#define cADCH_CURRENT_IAC				PFC_IAC_CH						        /* AD channel for IAC current of 1shunt */
#define cADCH_VOLTAGE_VAC				PFC_VAC_CH								/* AD Channel for VACcurrent of 1shunt */

/* Over current */
/* #define	cOVC_PFC						(11.00f)*/							/* [A] Over current  */

/* Over voltage */
#define cOVV_HPFC						(380.0f)								/* [V] Over voltage */
#define cVDC_DELTA						(uint16_t)((0.0f/cV_MAX_PFC)*FIX_12)	/* Vdc for restart value*/
#define cZERO_DELAY 					(30)									/* [ms] */
#define cZERO_ERROR_CYCLE				(cZERO_DELAY * 1000 / cPWMPRD_FAN)	    /* [times] */

/*===================================================================*
	  Motor Parameter Definition
 *===================================================================*/

/* PWM Parameter */
/* #define cPWMPRD_PFC 					(16.7f)	*/						/* [us] PWM Period */
#define cPWMPRD_PFC 					(25.0f)							/* [us] PWM Period */
#define cTMER_FRQ						(80.0f)							/* [Mhz] */
#define cPWMPRD_PFC_T					(cPWMPRD_PFC*cTMER_FRQ)		    /* Hpfc period count*/
#define cTRG_SWITCH_POINT				(10.0f)							/* [us] */	
#define cTRG_SWITCH_CONSTANT			(FIX_15*((cTRG_SWITCH_POINT * cTMER_FRQ) / cPWMPRD_PFC_T))/* Hpfc sample switch point time */

/* Control Gain constant */
#define cVOL_KP_PFC 					(0.025f/2)	    /* [A/V]  Voltage control Proportinal gain */
#define cVOL_KI_PFC 					(64.95f)	    /* [A/Vs] Voltage control Integral gain */
#define cVOL_RESTART_KP_TMP 			(0.069f)	    /* [A/V]  Voltage control Proportinal gain for hpfc hw restart */
#define cVOL_RESTART_KI_TMP 			(0)			    /* [A/Vs] Voltage control Integral gain for hpfc hw restart*/

#define cCRT_KP_PFC 					(1.172f)	    /* [%/A]  Current control Proportinal gain */
#define cCRT_KI_PFC 					(18312.38f/2)	/* [%/As] Current control Integral gain */

/* Limit */
#define cCURRENT_LIM_PFC				(17.0f)			/* [A] */
#define cCURRENT_LIM_RESTART_PFC		(14.0f)			/* [A] */

#define cPWM_DUTY_MIN_PFC				(4.0f)			/* [%] PWM Duty minimum limit (Do not set 0.) */
#define cPWM_DUTY_MAX_PFC				(96.0f)			/* [%] PWM Duty maximum limit (Do not set 100.) */

#define cPFC_TRG0						(7.0 * FIX_15 / cPWMPRD_PFC)		/* [us] Trg0 compensate*/	
#define cPFC_TRG1						(0.5 * FIX_15 / cPWMPRD_PFC)		/* [us] Trg1 compensate*/	

#define cFILTER_PFC 					(30)								/* VAC peak filter */
#define cIAC_LIM_UP_PFC 				(1800)								/* Iac PI control up limit */
#define cIAC_LIM_DW_PFC 				(-1800)								/* Iac PI control down limit */

#define cVAC_SAMPLE_FREQ				(1)									/* Vac sample times */

#define cFREQ_ERR_OVER					1e6/120/cPWMPRD_FAN 			    /* Frequence error up limit */	 
#define cFREQ_ERR_UNDER 				1e6/80/cPWMPRD_FAN				    /* Frequence error down limit */
#define cFREQ_NORMAL					(uint16_t)(1e6/100/cPWMPRD_FAN) 	/* Frequence normal value */

/*===================================================================*/

/* Control period of motor */
#define cVOL_PI_CTRL_PRD_HPFC			(cPWMPRD_PFC * 1e-6)				/* [s] Voltage PI Contorol Period. */
#define cCRT_PI_CTRL_PRD_HPFC			(cPWMPRD_PFC * 1e-6)				/* [s] Current PI Contorol Period. */

/*===================================================================*
  Macro Definition
 *===================================================================*/

/***** AD Unit setting for HPFC *****/
#define HPFC_ADUNIT 					PFC_SAMPLE_CH						/* Hpfc sample AD ch */

/***** HPFC PWM Output timer *****/

/* PWM Timer rate setting */
#define PFC_PWM_CLKDIV					T32A_CLK_DIV_1						/* 1/2 PhiT0 */
#define PFC_PWM_US2CNT(x)				T32A_DIV1_PRD(x)					/* us -> timer count value */

/* PWM Timer Interrupt Level setting */
#define HPFC_PWMA_IRQ_LEVEL 			(1)									/* PWM */

/***** HPFC Trigger timing timer *****/
#define HPFC_ADTRG_IRQ_LEVEL			(HPFC_PWMA_IRQ_LEVEL + 2)			/* ADTRG IRQ Level */
#define HPFC_ADTRG_IRQ_INTADTMR 		INTADCTRG_IRQn						/* ADTRG IRQ */

/*****	*****/

/*===================================================================*
	Parameter check
 *===================================================================*/
#if (!((cPOLL_PFC == 0) || (cPOLL_PFC == 1)))
#error cPOLL_HPFC define error.
#error cPOLL_HPFC only 0 or 1.
#endif


#endif /* _D_HPFC_PARA_H */

/*************************** END OF FILE **************************************/
